/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.cache.osgi;

import com.openexchange.caching.CacheKey;
import com.openexchange.caching.events.CacheEvent;
import com.openexchange.caching.events.CacheEventService;
import com.openexchange.caching.events.CacheListener;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.cache.memory.FolderMapManagement;
import com.openexchange.folderstorage.internal.Tools;
import java.io.Serializable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class FolderMapInvalidator
implements CacheListener,
ServiceTrackerCustomizer<CacheEventService, CacheEventService> {
    private final BundleContext context;

    public FolderMapInvalidator(BundleContext context) {
        this.context = context;
    }

    public void onEvent(Object sender, CacheEvent cacheEvent, boolean fromRemote) {
        if (fromRemote) {
            String region = cacheEvent.getRegion();
            if ("GlobalFolderCache".equals(region)) {
                int contextId = Tools.getUnsignedInteger(cacheEvent.getGroupName());
                if (null == cacheEvent.getKey()) {
                    FolderMapManagement.getInstance().dropFor(contextId);
                } else {
                    Serializable[] keys = ((CacheKey)cacheEvent.getKey()).getKeys();
                    String id = keys[1].toString();
                    String treeId = keys[0].toString();
                    this.removeFromUserCache(id, treeId, contextId);
                }
            } else if ("OXFolderCache".equals(region)) {
                CacheKey cacheKey = (CacheKey)cacheEvent.getKey();
                String id = cacheKey.getKeys()[0].toString();
                String treeId = FolderStorage.REAL_TREE_ID;
                this.removeFromUserCache(id, treeId, cacheKey.getContextId());
            }
        }
    }

    private void removeFromUserCache(String id, String treeId, int contextId) {
        FolderMapManagement.getInstance().dropFor(id, treeId, -1, contextId);
    }

    public CacheEventService addingService(ServiceReference<CacheEventService> reference) {
        CacheEventService service = (CacheEventService)this.context.getService(reference);
        service.addListener("GlobalFolderCache", (CacheListener)this);
        service.addListener("OXFolderCache", (CacheListener)this);
        return service;
    }

    public void modifiedService(ServiceReference<CacheEventService> reference, CacheEventService service) {
    }

    public void removedService(ServiceReference<CacheEventService> reference, CacheEventService service) {
        service.removeListener("GlobalFolderCache", (CacheListener)this);
        service.removeListener("OXFolderCache", (CacheListener)this);
        this.context.ungetService(reference);
    }
}

