/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.writer;

import com.openexchange.exception.OXException;
import com.openexchange.tools.iterator.SearchIterator;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONWriter;

public abstract class TimedWriter<T> {
    protected JSONWriter jsonWriter;

    public TimedWriter(JSONWriter w) {
        this.jsonWriter = w;
    }

    public void timedResult(long timestamp) throws JSONException {
        this.jsonWriter.object();
        this.jsonWriter.key("timestamp");
        this.jsonWriter.value(timestamp);
        this.jsonWriter.key("data");
    }

    public void endTimedResult() throws JSONException {
        this.jsonWriter.endObject();
    }

    public void writeDelta(SearchIterator<T> iterator, SearchIterator<T> deleted, Object[] cols, boolean ignoreDeleted, TimeZone tz) throws JSONException, OXException {
        this.jsonWriter.array();
        this.fillArray(iterator, cols, tz);
        while (deleted.hasNext() && !ignoreDeleted) {
            int del = this.getId(deleted.next());
            this.jsonWriter.value((long)del);
        }
        this.jsonWriter.endArray();
    }

    protected abstract int getId(Object var1);

    protected abstract void fillArray(SearchIterator<T> var1, Object[] var2, TimeZone var3) throws JSONException, OXException;
}

