/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview.cache;

import com.openexchange.ajax.requesthandler.cache.ResourceCache;
import com.openexchange.ajax.requesthandler.converters.preview.cache.ResourceCacheMBean;
import com.openexchange.context.ContextService;
import com.openexchange.database.DatabaseService;
import com.openexchange.database.Databases;
import com.openexchange.exception.OXException;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceCacheMBeanImpl
extends StandardMBean
implements ResourceCacheMBean {
    public static final AtomicReference<ResourceCache> CACHE_REF = new AtomicReference();

    public ResourceCacheMBeanImpl() throws NotCompliantMBeanException {
        super(ResourceCacheMBean.class);
    }

    @Override
    public void clear() throws MBeanException {
        ResourceCache resourceCache = CACHE_REF.get();
        if (null != resourceCache) {
            Logger logger = LoggerFactory.getLogger(ResourceCacheMBeanImpl.class);
            List<Integer> contextIds = null;
            try {
                contextIds = this.getContextIds();
            }
            catch (OXException e) {
                logger.error("", (Throwable)e);
                String message = e.getMessage();
                throw new MBeanException(new Exception(message), message);
            }
            for (Integer contextId : contextIds) {
                try {
                    resourceCache.clearFor(contextId);
                }
                catch (OXException e) {
                    logger.error("", (Throwable)e);
                    String message = e.getMessage();
                    throw new MBeanException(new Exception(message), message);
                }
                catch (RuntimeException e) {
                    logger.error("", (Throwable)e);
                    String message = e.getMessage();
                    throw new MBeanException(new Exception(message), message);
                }
            }
        }
    }

    private List<Integer> getContextIds() throws OXException {
        ContextService contextService = ServerServiceRegistry.getInstance().getService(ContextService.class);
        if (null == contextService) {
            throw ServiceExceptionCode.absentService(ContextService.class);
        }
        return contextService.getAllContextIds();
    }

    @Override
    public void clearFor(int contextId) throws MBeanException {
        ResourceCache resourceCache = CACHE_REF.get();
        if (null != resourceCache) {
            try {
                resourceCache.clearFor(contextId);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(ResourceCacheMBeanImpl.class).error("", (Throwable)e);
                String message = e.getMessage();
                throw new MBeanException(new Exception(message), message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sanitizeMimeTypesInDatabaseFor(int contextId, String invalids) throws MBeanException {
        final Logger logger = LoggerFactory.getLogger(ResourceCacheMBeanImpl.class);
        try {
            TIntHashSet contextIds;
            final DatabaseService databaseService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
            if (null == databaseService) {
                String message = "Missing service: " + DatabaseService.class.getName();
                throw new MBeanException(new Exception(message), message);
            }
            final HashSet<String> invalidsSet = new HashSet<String>(Arrays.asList("application/force-download", "application/x-download", "application/$suffix"));
            if (!this.isEmpty(invalids)) {
                for (String invalid : invalids.split(" *, *")) {
                    invalidsSet.add(this.toLowerCase(invalid.trim()));
                }
            }
            if (contextId >= 0) {
                return this.processContext(contextId, invalidsSet, databaseService);
            }
            Connection configDbCon = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                configDbCon = databaseService.getReadOnly();
                stmt = configDbCon.prepareStatement("SELECT cid FROM context");
                rs = stmt.executeQuery();
                contextIds = new TIntHashSet();
                while (rs.next()) {
                    contextIds.add(rs.getInt(1));
                }
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, stmt);
                rs = null;
                stmt = null;
                if (null != configDbCon) {
                    databaseService.backReadOnly(configDbCon);
                    configDbCon = null;
                }
                throw throwable;
            }
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            rs = null;
            stmt = null;
            if (null != configDbCon) {
                databaseService.backReadOnly(configDbCon);
                configDbCon = null;
            }
            if (contextIds.isEmpty()) {
                return "No contexts found";
            }
            final String sep = System.getProperty("line.separator");
            final StringBuilder responseBuilder = new StringBuilder(65536);
            AtomicReference errorRef = new AtomicReference();
            contextIds.forEach(new TIntProcedure(){

                public boolean execute(int cid) {
                    if (responseBuilder.length() > 0) {
                        responseBuilder.append(sep);
                    }
                    try {
                        responseBuilder.append(ResourceCacheMBeanImpl.this.processContext(cid, invalidsSet, databaseService));
                    }
                    catch (Exception e) {
                        logger.error("Context {} could not be processed", (Object)cid, (Object)e);
                        responseBuilder.append("Context ").append(cid).append(" could not be processed: >>>").append(e.getMessage()).append("<<<");
                    }
                    return true;
                }
            });
            Exception exc = (Exception)errorRef.get();
            if (null != exc) {
                throw exc;
            }
            return responseBuilder.toString();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            String message = e.getMessage();
            throw new MBeanException(new Exception(message), message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String processContext(int contextId, Set<String> invalidsSet, DatabaseService databaseService) throws OXException, SQLException {
        String string;
        class Tuple {
            int id;
            int version;
            String mimeType;

            Tuple(String mimeType, ResultSet rs) throws SQLException {
                this.id = rs.getInt(1);
                this.version = rs.getInt(2);
                this.mimeType = mimeType;
            }
        }
        LinkedList<Tuple> tuples;
        boolean afterReading;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block19: {
            String fileName;
            block18: {
                con = null;
                stmt = null;
                rs = null;
                afterReading = true;
                con = databaseService.getForUpdateTask(contextId);
                stmt = con.prepareStatement("SELECT infostore_id, version_number, file_mimetype, filename FROM infostore_document WHERE cid=?");
                stmt.setInt(1, contextId);
                rs = stmt.executeQuery();
                if (rs.next()) break block18;
                String string2 = "Context " + contextId + " does not hold any documents.";
                Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                if (null != con) {
                    if (afterReading) {
                        databaseService.backForUpdateTaskAfterReading(contextId, con);
                    } else {
                        databaseService.backForUpdateTask(contextId, con);
                    }
                }
                return string2;
            }
            String defaultMimeType = "application/octet-stream";
            tuples = new LinkedList<Tuple>();
            do {
                String mimeType;
                if (this.isEmpty(fileName = rs.getString(4)) || this.isEmpty(mimeType = rs.getString(3))) continue;
                String contentTypeByFileName = MimeType2ExtMap.getContentType(fileName);
                if (!invalidsSet.contains(this.toLowerCase(mimeType)) && ("application/octet-stream".equals(contentTypeByFileName) || this.equalPrimaryTypes(mimeType, contentTypeByFileName))) continue;
                tuples.add(new Tuple(contentTypeByFileName, rs));
            } while (rs.next());
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            rs = null;
            stmt = null;
            if (!tuples.isEmpty()) break block19;
            fileName = "No document with a broken/corrupt MIME type found in context " + contextId;
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            if (null != con) {
                if (afterReading) {
                    databaseService.backForUpdateTaskAfterReading(contextId, con);
                } else {
                    databaseService.backForUpdateTask(contextId, con);
                }
            }
            return fileName;
        }
        try {
            stmt = con.prepareStatement("UPDATE infostore_document SET file_mimetype=? WHERE cid=? AND infostore_id=? AND version_number=?");
            stmt.setInt(2, contextId);
            for (Tuple tuple : tuples) {
                stmt.setString(1, tuple.mimeType);
                stmt.setInt(3, tuple.id);
                stmt.setInt(4, tuple.version);
                stmt.addBatch();
            }
            int[] result = stmt.executeBatch();
            afterReading = false;
            string = "Fixed " + Integer.toString(result.length) + (result.length == 1 ? " document" : " documents") + " with a broken/corrupt MIME type in context " + contextId;
        }
        catch (Throwable throwable) {
            Databases.closeSQLStuff(rs, stmt);
            if (null != con) {
                if (afterReading) {
                    databaseService.backForUpdateTaskAfterReading(contextId, con);
                } else {
                    databaseService.backForUpdateTask(contextId, con);
                }
            }
            throw throwable;
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        if (null != con) {
            if (afterReading) {
                databaseService.backForUpdateTaskAfterReading(contextId, con);
            } else {
                databaseService.backForUpdateTask(contextId, con);
            }
        }
        return string;
    }

    private boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }

    private String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    private String getPrimaryType(String contentType) {
        if (this.isEmpty(contentType)) {
            return contentType;
        }
        int pos = contentType.indexOf(47);
        return pos > 0 ? contentType.substring(0, pos) : contentType;
    }

    private boolean equalPrimaryTypes(String contentType1, String contentType2) {
        if (null == contentType1 || null == contentType2) {
            return false;
        }
        return this.toLowerCase(this.getPrimaryType(contentType1)).startsWith(this.toLowerCase(this.getPrimaryType(contentType2)));
    }
}

