/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.annotation.NonNull;
import com.openexchange.annotation.Nullable;
import com.openexchange.exception.OXException;
import com.openexchange.java.StringAllocator;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class AJAXRequestResult {
    private static final String JSON = "json".intern();
    public static final long SECOND_IN_MILLIS = 1000L;
    public static final long MINUTE_IN_MILLIS = 60000L;
    public static final long HOUR_IN_MILLIS = 3600000L;
    public static final long DAY_IN_MILLIS = 86400000L;
    public static final long WEEK_IN_MILLIS = 604800000L;
    public static final long YEAR_IN_MILLIS = 31449600000L;
    public static final AJAXRequestResult EMPTY_REQUEST_RESULT = new AJAXRequestResult(){

        @Override
        public void setResultObject(Object resultObject) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public void setResultObject(Object object, String format) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public void setFormat(String format) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public void setTimestamp(Date timestamp) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public void setHeader(String header, String value) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public void setDeferred(boolean deferred) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public void setExpires(long expires) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public AJAXRequestResult setType(ResultType resultType) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public AJAXRequestResult addWarnings(Collection<OXException> warnings) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public void setParameter(String name, Object value) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public void setResponseProperty(String name, Object value) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public void removeHeader(String header) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public void removeParameter(String name) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }

        @Override
        public void removeResponseProperty(String name) {
            throw new UnsupportedOperationException("Method not allowed for empty AJAX request result.");
        }
    };
    public static final Object DIRECT_OBJECT = new Object();
    @NonNull
    private ResultType resultType;
    @Nullable
    private Object resultObject;
    @Nullable
    private Date timestamp;
    @Nullable
    private Collection<OXException> warnings;
    private boolean deferred;
    @NonNull
    private final Map<String, String> headers = new LinkedHashMap<String, String>(8);
    @NonNull
    private final Map<String, Object> parameters = new HashMap<String, Object>(8);
    @NonNull
    private final Map<String, Object> responseProperties = new HashMap<String, Object>(4);
    @Nullable
    private String format;
    private long expires;
    @Nullable
    private OXException exception;
    private long duration = -1L;
    private int httpStatusCode = 200;

    public AJAXRequestResult() {
        this(null, null, null);
    }

    public AJAXRequestResult(@Nullable Object resultObject) {
        this(resultObject, null, null);
    }

    public AJAXRequestResult(@Nullable Object resultObject, @Nullable Date timestamp) {
        this(resultObject, timestamp, null);
    }

    public AJAXRequestResult(@Nullable Object resultObject, @Nullable String format) {
        this(resultObject, null, format);
    }

    public AJAXRequestResult(@Nullable Object resultObject, @Nullable Date timestamp, @Nullable String format) {
        this.timestamp = null == timestamp ? null : new Date(timestamp.getTime());
        String string = this.format = null == format ? JSON : format;
        if ("direct".equals(format)) {
            this.resultType = ResultType.DIRECT;
            this.resultObject = DIRECT_OBJECT;
        } else {
            this.resultType = ResultType.COMMON;
            this.resultObject = resultObject;
        }
        this.expires = -1L;
    }

    public long getDuration() {
        return this.duration;
    }

    @NonNull
    public AJAXRequestResult setDuration(long duration) {
        this.duration = duration < 0L ? -1L : duration;
        return this;
    }

    @NonNull
    public AJAXRequestResult setDurationByStart(long start) {
        return this.setDuration(System.currentTimeMillis() - start);
    }

    @NonNull
    public AJAXRequestResult addDuration(long duration) {
        if (this.duration < 0L) {
            return this.setDuration(duration);
        }
        this.duration += duration;
        return this;
    }

    @NonNull
    public AJAXRequestResult addDurationByStart(long start) {
        return this.addDuration(System.currentTimeMillis() - start);
    }

    @NonNull
    public ResultType getType() {
        return this.resultType;
    }

    @NonNull
    public AJAXRequestResult setType(@NonNull ResultType resultType) {
        this.resultType = resultType;
        return this;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    @NonNull
    public AJAXRequestResult setHttpStatusCode(int httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
        this.resultType = ResultType.HTTP_ERROR;
        return this;
    }

    public long getExpires() {
        return this.expires;
    }

    public void setExpires(long expires) {
        this.expires = expires;
    }

    public boolean isDeferred() {
        return this.deferred;
    }

    public void setDeferred(boolean deferred) {
        this.deferred = deferred;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        Object thisResultObject = this.resultObject;
        result = 31 * result + (thisResultObject == null ? 0 : thisResultObject.hashCode());
        Date thisTimestamp = this.timestamp;
        result = 31 * result + (thisTimestamp == null ? 0 : thisTimestamp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AJAXRequestResult)) {
            return false;
        }
        AJAXRequestResult other = (AJAXRequestResult)obj;
        Object thisResultObject = this.resultObject;
        if (thisResultObject == null ? other.resultObject != null : !thisResultObject.equals(other.resultObject)) {
            return false;
        }
        Date thisTimestamp = this.timestamp;
        return !(thisTimestamp == null ? other.timestamp != null : !thisTimestamp.equals(other.timestamp));
    }

    @Nullable
    public Object getResultObject() {
        return this.resultObject;
    }

    public void setResultObject(@Nullable Object resultObject) {
        this.resultObject = resultObject;
    }

    @Nullable
    public String getFormat() {
        return this.format;
    }

    public void setFormat(@Nullable String format) {
        this.format = format;
    }

    @Nullable
    public Date getTimestamp() {
        Date thisTimestamp = this.timestamp;
        return null == thisTimestamp ? null : new Date(thisTimestamp.getTime());
    }

    public void setTimestamp(@Nullable Date timestamp) {
        this.timestamp = timestamp;
    }

    @NonNull
    public Collection<OXException> getWarnings() {
        Collection<OXException> thisWarnings = this.warnings;
        if (null == thisWarnings) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(thisWarnings);
    }

    @NonNull
    public AJAXRequestResult addWarnings(@Nullable Collection<OXException> warnings) {
        if (null == warnings || warnings.isEmpty()) {
            return this;
        }
        Collection<OXException> thisWarning = this.warnings;
        if (null == thisWarning) {
            this.warnings = new HashSet<OXException>(warnings);
        } else {
            thisWarning.addAll(warnings);
        }
        return this;
    }

    public void setHeader(@NonNull String header, @Nullable String value) {
        if (null == value) {
            this.headers.remove(header);
        } else {
            this.headers.put(header, value);
        }
    }

    public void removeHeader(@NonNull String header) {
        this.headers.remove(header);
    }

    public String getHeader(@NonNull String header) {
        return this.headers.get(header);
    }

    @NonNull
    public Map<String, String> getHeaders() {
        return new HashMap<String, String>(this.headers);
    }

    public void setParameter(@NonNull String name, @Nullable Object value) {
        if (null == value) {
            this.parameters.remove(name);
        } else {
            this.parameters.put(name, value);
        }
    }

    public void removeParameter(@NonNull String name) {
        this.parameters.remove(name);
    }

    public Object getParameter(@NonNull String name) {
        return this.parameters.get(name);
    }

    @NonNull
    public Map<String, Object> getParameters() {
        return new HashMap<String, Object>(this.parameters);
    }

    public void setResponseProperty(@NonNull String name, @Nullable Object value) {
        if (null == value) {
            this.responseProperties.remove(name);
        } else {
            this.responseProperties.put(name, value);
        }
    }

    public void removeResponseProperty(@NonNull String name) {
        this.responseProperties.remove(name);
    }

    public Object getResponseProperty(@NonNull String name) {
        return this.responseProperties.get(name);
    }

    @NonNull
    public Map<String, Object> getResponseProperties() {
        return this.responseProperties;
    }

    public String toString() {
        Collection<OXException> thisWarnings = this.warnings;
        return new StringAllocator(34).append(super.toString()).append(" resultObject=").append(this.resultObject).append(", timestamp=").append((Object)this.timestamp).append(" warnings=").append(null == thisWarnings ? "<none>" : thisWarnings.toString()).toString();
    }

    public void setResultObject(@Nullable Object object, @Nullable String format) {
        this.setResultObject(object);
        this.setFormat(format);
    }

    public void setException(@Nullable OXException exception) {
        this.exception = exception;
    }

    @Nullable
    public OXException getException() {
        return this.exception;
    }

    public static enum ResultType {
        COMMON,
        ETAG,
        DIRECT,
        HTTP_ERROR;

    }
}

