/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login.osgi;

import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.login.HashCalculator;
import com.openexchange.ajax.requesthandler.DefaultDispatcherPrefixService;
import com.openexchange.config.ConfigurationService;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.dispatcher.DispatcherPrefixService;
import com.openexchange.login.ConfigurationProperty;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginServletRegisterer
implements ServiceTrackerCustomizer<Object, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(LoginServletRegisterer.class);
    private static final String SERVLET_PATH_APPENDIX = "login";
    private final BundleContext context;
    private final Lock lock = new ReentrantLock();
    private ConfigurationService configService;
    private HttpService httpService;
    private DispatcherPrefixService prefixService;
    private LoginServlet login;

    public LoginServletRegisterer(BundleContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference<Object> reference) {
        boolean needsRegistration;
        Object obj = this.context.getService(reference);
        this.lock.lock();
        try {
            if (obj instanceof ConfigurationService) {
                this.configService = (ConfigurationService)obj;
                HashCalculator.getInstance().configure(this.configService);
            }
            if (obj instanceof HttpService) {
                this.httpService = (HttpService)obj;
            }
            if (obj instanceof DispatcherPrefixService) {
                this.prefixService = (DispatcherPrefixService)obj;
            }
            boolean bl = needsRegistration = null != this.configService && null != this.httpService && this.login == null && this.prefixService != null;
            if (needsRegistration) {
                this.login = new LoginServlet();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (needsRegistration) {
            Hashtable<String, String> params = new Hashtable<String, String>(32);
            this.addProperty(params, ServerConfig.Property.UI_WEB_PATH);
            this.addProperty(params, ServerConfig.Property.COOKIE_HASH);
            this.addProperty(params, ServerConfig.Property.COOKIE_TTL);
            this.addProperty(params, ServerConfig.Property.COOKIE_FORCE_HTTPS);
            this.addProperty(params, ServerConfig.Property.FORCE_HTTPS);
            this.addProperty(params, ServerConfig.Property.IP_CHECK);
            this.addProperty(params, ServerConfig.Property.IP_MASK_V4);
            this.addProperty(params, ServerConfig.Property.IP_MASK_V6);
            this.addProperty(params, ServerConfig.Property.IP_CHECK_WHITELIST);
            String tmp = this.configService.getText("noipcheck.cnf");
            if (null != tmp) {
                ((Dictionary)params).put(ConfigurationProperty.NO_IP_CHECK_RANGE.getPropertyName(), tmp);
            }
            this.addProperty(params, ConfigurationProperty.SESSIOND_AUTOLOGIN);
            this.addProperty(params, ConfigurationProperty.HTTP_AUTH_AUTOLOGIN);
            this.addProperty(params, ConfigurationProperty.HTTP_AUTH_CLIENT);
            this.addProperty(params, ConfigurationProperty.HTTP_AUTH_VERSION);
            this.addProperty(params, ConfigurationProperty.ERROR_PAGE_TEMPLATE);
            this.addProperty(params, ConfigurationProperty.INSECURE);
            this.addProperty(params, ConfigurationProperty.REDIRECT_IP_CHANGE_ALLOWED);
            this.addProperty(params, ConfigurationProperty.DISABLE_TRIM_LOGIN);
            this.addProperty(params, ConfigurationProperty.FORM_LOGIN_WITHOUT_AUTHID);
            this.addProperty(params, ConfigurationProperty.RANDOM_TOKEN);
            try {
                LOG.info("Registering login servlet.");
                this.httpService.registerServlet(this.prefixService.getPrefix() + SERVLET_PATH_APPENDIX, (Servlet)new LoginServlet(), params, null);
            }
            catch (ServletException e) {
                LOG.error("Registering login servlet failed.", (Throwable)e);
            }
            catch (NamespaceException e) {
                LOG.error("Registering login servlet failed.", (Throwable)e);
            }
        }
        return obj;
    }

    private void addProperty(Dictionary<String, String> params, ServerConfig.Property property) {
        String propertyName = property.getPropertyName();
        String prop = this.configService.getProperty(propertyName);
        if (prop == null) {
            String defaultValue = property.getDefaultValue();
            LOG.warn("Missing configuration property \"{}\". Using fall-back value: {}", (Object)propertyName, (Object)defaultValue);
            params.put(propertyName, defaultValue);
        } else {
            params.put(propertyName, prop);
        }
    }

    private void addProperty(Dictionary<String, String> params, ConfigurationProperty property) {
        String propertyName = property.getPropertyName();
        String value = this.configService.getProperty(propertyName, property.getDefaultValue());
        if (null != value) {
            params.put(propertyName, value.trim());
        }
    }

    public void modifiedService(ServiceReference<Object> reference, Object service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<Object> reference, Object service) {
        HttpService unregister = null;
        this.lock.lock();
        try {
            if (service instanceof ConfigurationService) {
                this.configService = null;
            }
            if (service instanceof HttpService) {
                if (this.login != null) {
                    unregister = this.httpService;
                    this.login = null;
                }
                this.httpService = null;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (null != unregister) {
            LOG.info("Unregistering login servlet.");
            unregister.unregister(DefaultDispatcherPrefixService.getInstance().getPrefix() + SERVLET_PATH_APPENDIX);
        }
        this.context.ungetService(reference);
    }
}

