/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.results;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.results.Delta;
import com.openexchange.tools.iterator.CombinedSearchIterator;
import com.openexchange.tools.iterator.SearchIterator;

public class DeltaImpl<T>
implements Delta<T> {
    private final SearchIterator<T> New;
    private final SearchIterator<T> Modified;
    private final SearchIterator<T> Deleted;
    private final long sequenceNumber;

    public DeltaImpl(SearchIterator<T> New, SearchIterator<T> Modified, SearchIterator<T> Deleted, long sequenceNumber) {
        this.New = New;
        this.Modified = Modified;
        this.Deleted = Deleted;
        this.sequenceNumber = sequenceNumber;
    }

    @Override
    public SearchIterator<T> getNew() {
        return this.New;
    }

    @Override
    public SearchIterator<T> getModified() {
        return this.Modified;
    }

    @Override
    public SearchIterator<T> getDeleted() {
        return this.Deleted;
    }

    @Override
    public SearchIterator<T> results() throws OXException {
        return new CombinedSearchIterator(this.New, this.Modified);
    }

    @Override
    public long sequenceNumber() throws OXException {
        return this.sequenceNumber;
    }

    public void close() throws OXException {
        this.New.close();
        this.Modified.close();
        this.Deleted.close();
    }
}

