/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.datatypes.genericonf.json;

import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.datatypes.genericonf.FormElement;
import com.openexchange.datatypes.genericonf.json.ValueWriterSwitch;
import com.openexchange.i18n.Translator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FormDescriptionWriter {
    public static final String WIDGET = "widget";
    public static final String NAME = "name";
    public static final String DISPLAY_NAME = "displayName";
    private static final String MANDATORY = "mandatory";
    private static final String OPTIONS = "options";
    private static final String DEFAULT_VALUE = "defaultValue";
    private static final ValueWriterSwitch valueWrite = new ValueWriterSwitch();
    private final Translator translator;

    public FormDescriptionWriter(Translator translator) {
        this.translator = translator;
    }

    public FormDescriptionWriter() {
        this(Translator.EMPTY);
    }

    public JSONArray write(DynamicFormDescription form) throws JSONException {
        JSONArray formDescriptionArray = new JSONArray();
        for (FormElement formElement : form) {
            JSONObject formElementObject = this.write(formElement);
            formDescriptionArray.put((Object)formElementObject);
        }
        return formDescriptionArray;
    }

    public JSONObject write(FormElement formElement) throws JSONException {
        JSONObject object = new JSONObject();
        if (formElement.getWidget() != FormElement.Widget.CUSTOM) {
            object.put(WIDGET, (Object)formElement.getWidget().getKeyword());
        } else {
            object.put(WIDGET, (Object)formElement.getCustomWidget());
        }
        Map<String, String> options = formElement.getOptions();
        if (options != null && !options.isEmpty()) {
            JSONObject jsonOptions = new JSONObject();
            for (Map.Entry<String, String> entry : options.entrySet()) {
                jsonOptions.put(entry.getKey(), (Object)entry.getValue());
            }
            object.put(OPTIONS, (Object)jsonOptions);
        }
        object.put(NAME, (Object)formElement.getName());
        object.put(DISPLAY_NAME, (Object)this.translator.translate(formElement.getDisplayName()));
        object.put(MANDATORY, formElement.isMandatory());
        if (null != formElement.getDefaultValue()) {
            object.put(DEFAULT_VALUE, formElement.getWidget().doSwitch(valueWrite, formElement.getDefaultValue()));
        }
        return object;
    }
}

