/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import com.fasterxml.jackson.core.io.CharTypes;
import java.io.IOException;
import java.io.Reader;

public class JSONStringEncoderReader
extends Reader {
    private static final int[] sOutputEscapes = CharTypes.get7BitOutputEscapes();
    private static final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();
    private static final int SURR1_FIRST = 55296;
    private static final int SURR2_LAST = 57343;
    private final Reader in;
    private CharStack buffer;

    public JSONStringEncoderReader(Reader in) {
        this.in = in;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private int checkBuffer() {
        if (null == this.buffer) {
            return -1;
        }
        int bufferedChar = this.buffer.next();
        if (bufferedChar < 0) {
            this.buffer = null;
        }
        return bufferedChar;
    }

    @Override
    public int read() throws IOException {
        int buffered = this.checkBuffer();
        if (buffered > 0) {
            return buffered;
        }
        int read = this.in.read();
        if (read < 0) {
            return read;
        }
        return this.readChar(read, 0, sOutputEscapes);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        boolean first = true;
        int offset = off;
        int end = offset + len;
        int count = 0;
        while (offset < end) {
            int next = this.read();
            if (next < 0) {
                return first ? -1 : count;
            }
            cbuf[offset++] = (char)next;
            ++count;
            if (!first) continue;
            first = false;
        }
        return count;
    }

    private int readChar(int ch, int maxUnescaped, int[] escCodes) {
        if (ch <= 127) {
            int escape = escCodes[ch];
            if (escape == 0) {
                return ch;
            }
            if (escape > 0) {
                this.buffer = new SingletonCharStack(escape);
                return 92;
            }
            return this.asGenericEscape(ch);
        }
        if (maxUnescaped > 0 && ch > maxUnescaped) {
            return this.asGenericEscape(ch);
        }
        if (ch <= 2047) {
            return ch;
        }
        return this.asMultiByteChar(ch);
    }

    private int asGenericEscape(int ch) {
        int c = ch;
        if (c > 255) {
            int hi = c >> 8 & 0xFF;
            this.buffer = new ArrayCharStack(new char[]{'u', HEX_CHARS[hi >> 4], HEX_CHARS[hi & 0xF], HEX_CHARS[c >> 4], HEX_CHARS[c & 0xF]});
            return 92;
        }
        this.buffer = new ArrayCharStack(new char[]{'u', '0', '0', HEX_CHARS[c >> 4], HEX_CHARS[c & 0xF]});
        return 92;
    }

    private int asMultiByteChar(int ch) {
        if (ch >= 55296 && ch <= 57343) {
            this.buffer = new ArrayCharStack(new char[]{'u', HEX_CHARS[ch >> 12 & 0xF], HEX_CHARS[ch >> 8 & 0xF], HEX_CHARS[ch >> 4 & 0xF], HEX_CHARS[ch & 0xF]});
            return 92;
        }
        return ch;
    }

    private static class SingletonCharStack
    implements CharStack {
        private int ch;

        SingletonCharStack(int ch) {
            this.ch = ch;
        }

        @Override
        public int next() {
            if (this.ch < 0) {
                return -1;
            }
            int ch = this.ch;
            this.ch = -1;
            return ch;
        }
    }

    private static class ArrayCharStack
    implements CharStack {
        private final char[] chars;
        private int pos;

        ArrayCharStack(char[] chars) {
            this.chars = chars;
            this.pos = 0;
        }

        @Override
        public int next() {
            return this.pos < this.chars.length ? this.chars[this.pos++] : -1;
        }
    }

    private static interface CharStack {
        public int next();
    }
}

