/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.task;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.java.Autoboxing;
import com.openexchange.webdav.xml.TaskTest;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;

public class ListTest
extends TaskTest {
    public ListTest(String name) {
        super(name);
    }

    public void testPropFindWithModified() throws Exception {
        Task taskObj = this.createTask("testPropFindWithModified");
        int objectId1 = ListTest.insertTask(this.webCon, taskObj, "http://" + this.hostName, this.login, this.password, this.context);
        ListTest.insertTask(this.webCon, taskObj, "http://" + this.hostName, this.login, this.password, this.context);
        Thread.sleep(1000L);
        Task loadTask = ListTest.loadTask(this.getWebConversation(), objectId1, this.taskFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Date modified = loadTask.getLastModified();
        Task[] taskArray = ListTest.listTask(this.webCon, this.taskFolderId, ListTest.decrementDate(modified), true, false, "http://" + this.hostName, this.login, this.password, this.context);
        ListTest.assertTrue((String)"check response", (taskArray.length >= 2 ? 1 : 0) != 0);
    }

    public void testPropFindWithDelete() throws Exception {
        Task taskObj = this.createTask("testPropFindWithModified");
        int objectId1 = ListTest.insertTask(this.webCon, taskObj, "http://" + this.hostName, this.login, this.password, this.context);
        int objectId2 = ListTest.insertTask(this.webCon, taskObj, "http://" + this.hostName, this.login, this.password, this.context);
        Thread.sleep(1000L);
        Task loadTask = ListTest.loadTask(this.getWebConversation(), objectId1, this.taskFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Date modified = loadTask.getLastModified();
        int[][] objectIdAndFolderId = new int[][]{{objectId1, this.taskFolderId}, {objectId2, this.taskFolderId}};
        ListTest.deleteTask(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
        Task[] taskArray = ListTest.listTask(this.webCon, this.taskFolderId, ListTest.decrementDate(modified), false, true, "http://" + this.hostName, this.login, this.password, this.context);
        ListTest.assertTrue((String)"wrong response array length", (taskArray.length >= 2 ? 1 : 0) != 0);
    }

    public void testPropFindWithObjectId() throws Exception {
        Task taskObj = this.createTask("testPropFindWithObjectId");
        int objectId = ListTest.insertTask(this.webCon, taskObj, "http://" + this.hostName, this.login, this.password, this.context);
        ListTest.loadTask(this.webCon, objectId, this.taskFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testObjectNotFound() throws Exception {
        Task taskObj = this.createTask("testObjectNotFound");
        int objectId = ListTest.insertTask(this.webCon, taskObj, "http://" + this.hostName, this.login, this.password, this.context);
        try {
            ListTest.loadTask(this.webCon, objectId + 1000, this.taskFolderId, "http://" + this.hostName, this.login, this.password, this.context);
            ListTest.fail((String)"object not found exception expected!");
        }
        catch (OXException exc) {
            ListTest.assertExceptionMessage(exc.getDisplayMessage(Locale.ENGLISH), 1001);
        }
        int[][] objectIdAndFolderId = new int[][]{{objectId, this.taskFolderId}};
        ListTest.deleteTask(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testListWithAllFields() throws Exception {
        Task taskObj = new Task();
        taskObj.setTitle("testListWithAllFields");
        taskObj.setStartDate(this.startTime);
        taskObj.setEndDate(this.endTime);
        taskObj.setParentFolderID(this.taskFolderId);
        taskObj.setPrivateFlag(true);
        taskObj.setLabel(2);
        taskObj.setNote("note");
        taskObj.setCategories("testcat1,testcat2,testcat3");
        taskObj.setActualCosts(new BigDecimal("1.50"));
        taskObj.setActualDuration(Autoboxing.L((long)210L));
        taskObj.setBillingInformation("billing information");
        taskObj.setCompanies("companies");
        taskObj.setCurrency("currency");
        taskObj.setDateCompleted(this.dateCompleted);
        taskObj.setPercentComplete(50);
        taskObj.setPriority(Integer.valueOf(3));
        taskObj.setStatus(2);
        taskObj.setTargetCosts(new BigDecimal("5.50"));
        taskObj.setTargetDuration(Autoboxing.L((long)450L));
        taskObj.setTripMeter("trip meter");
        int objectId = ListTest.insertTask(this.webCon, taskObj, "http://" + this.hostName, this.login, this.password, this.context);
        Thread.sleep(1000L);
        Task loadTask = ListTest.loadTask(this.getWebConversation(), objectId, this.taskFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Date modified = loadTask.getLastModified();
        Task[] taskArray = ListTest.listTask(this.webCon, this.taskFolderId, ListTest.decrementDate(modified), true, false, "http://" + this.hostName, this.login, this.password, this.context);
        ListTest.assertEquals((String)"wrong response array length", (int)1, (int)taskArray.length);
        loadTask = taskArray[0];
        taskObj.setObjectID(objectId);
        taskObj.setStartDate(this.startTime);
        taskObj.setEndDate(this.endTime);
        ListTest.compareObject(taskObj, loadTask);
    }

    public void testListWithAllFieldsOnUpdate() throws Exception {
        Task taskObj = this.createTask("testListWithAllFieldsOnUpdate");
        int objectId = ListTest.insertTask(this.webCon, taskObj, "http://" + this.hostName, this.login, this.password, this.context);
        Task loadTask = ListTest.loadTask(this.getWebConversation(), objectId, this.taskFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Date modified = loadTask.getLastModified();
        taskObj = new Task();
        taskObj.setTitle("testListWithAllFieldsOnUpdate");
        taskObj.setStartDate(this.startTime);
        taskObj.setEndDate(this.endTime);
        taskObj.setPrivateFlag(true);
        taskObj.setLabel(2);
        taskObj.setNote("note");
        taskObj.setCategories("testcat1,testcat2,testcat3");
        taskObj.setActualCosts(new BigDecimal("1.50"));
        taskObj.setActualDuration(Autoboxing.L((long)210L));
        taskObj.setBillingInformation("billing information");
        taskObj.setCompanies("companies");
        taskObj.setCurrency("currency");
        taskObj.setDateCompleted(this.dateCompleted);
        taskObj.setPercentComplete(50);
        taskObj.setPriority(Integer.valueOf(3));
        taskObj.setStatus(2);
        taskObj.setTargetCosts(new BigDecimal("5.50"));
        taskObj.setTargetDuration(Autoboxing.L((long)450L));
        taskObj.setTripMeter("trip meter");
        taskObj.setParentFolderID(this.taskFolderId);
        ListTest.updateTask(this.webCon, taskObj, objectId, this.taskFolderId, "http://" + this.hostName, this.login, this.password, this.context);
        Task[] taskArray = ListTest.listTask(this.webCon, this.taskFolderId, ListTest.decrementDate(modified), true, false, "http://" + this.hostName, this.login, this.password, this.context);
        loadTask = null;
        for (int i = 0; i < taskArray.length && loadTask == null; ++i) {
            if (taskArray[i].getObjectID() != objectId) continue;
            loadTask = taskArray[i];
        }
        ListTest.assertNotNull((String)"unable to find updated task.", (Object)loadTask);
        taskObj.setObjectID(objectId);
        taskObj.setStartDate(this.startTime);
        taskObj.setEndDate(this.endTime);
        taskObj.setParentFolderID(this.taskFolderId);
        ListTest.compareObject(taskObj, loadTask);
    }

    public void testList() throws Exception {
        Task taskObj = this.createTask("testList");
        int objectId = ListTest.insertTask(this.webCon, taskObj, "http://" + this.hostName, this.login, this.password, this.context);
        int[] idArray = ListTest.listTask(this.getWebConversation(), this.taskFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        boolean found = false;
        for (int a = 0; a < idArray.length; ++a) {
            if (idArray[a] != objectId) continue;
            found = true;
            break;
        }
        ListTest.assertTrue((String)("id " + objectId + " not found in response"), (boolean)found);
        ListTest.deleteTask(this.getWebConversation(), objectId, this.taskFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }
}

