/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.parser;

import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.resource.Resource;
import com.openexchange.resource.ResourceGroup;
import com.openexchange.test.TestException;
import com.openexchange.webdav.xml.XmlServlet;
import com.openexchange.webdav.xml.parser.AppointmentParser;
import com.openexchange.webdav.xml.parser.ContactParser;
import com.openexchange.webdav.xml.parser.DataParser;
import com.openexchange.webdav.xml.parser.FolderParser;
import com.openexchange.webdav.xml.parser.GroupParser;
import com.openexchange.webdav.xml.parser.ResourceGroupParser;
import com.openexchange.webdav.xml.parser.ResourceParser;
import com.openexchange.webdav.xml.parser.TaskParser;
import com.openexchange.webdav.xml.types.Response;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class ResponseParser {
    public static final Namespace webdav = Namespace.getNamespace((String)"D", (String)"DAV:");

    public static Response[] parse(Document doc, int module) throws OXException, OXException {
        return ResponseParser.parse(doc, module, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Response[] parse(Document doc, int module, boolean bList) throws OXException, OXException {
        Element rootElement = doc.getRootElement();
        List responseElements = rootElement.getChildren("response", webdav);
        Response[] response = null;
        if (module == 115) {
            if (responseElements.size() != 1) throw new TestException("invalid number of response elements in response!");
            return ResponseParser.parseGroupUserResponse((Element)responseElements.get(0));
        }
        response = new Response[responseElements.size()];
        int a = 0;
        while (a < response.length) {
            response[a] = ResponseParser.parseResponse((Element)responseElements.get(a), module, bList);
            ++a;
        }
        return response;
    }

    protected static Response parseResponse(Element eResponse, int module, boolean bList) throws OXException, OXException {
        Response response = new Response();
        Element ePropstat = eResponse.getChild("propstat", webdav);
        Element eProp = ePropstat.getChild("prop", webdav);
        if (bList) {
            response.setDataObject(ResponseParser.parseList(eProp));
        } else {
            switch (module) {
                case 1: {
                    response.setDataObject(ResponseParser.parseAppointmentResponse(eProp));
                    break;
                }
                case 7: {
                    response.setDataObject(ResponseParser.parseContactResponse(eProp));
                    break;
                }
                case 20: {
                    response.setDataObject(ResponseParser.parseFolderResponse(eProp));
                    break;
                }
                case 4: {
                    response.setDataObject(ResponseParser.parseTaskResponse(eProp));
                    break;
                }
                default: {
                    throw new TestException("invalid module!");
                }
            }
        }
        Element eStatus = ePropstat.getChild("status", webdav);
        Element eResponsedescription = ePropstat.getChild("responsedescription", webdav);
        int status = Integer.parseInt(eStatus.getValue());
        response.setStatus(status);
        String responseDescription = eResponsedescription.getValue();
        if (status != 200) {
            response.setErrorMessage(responseDescription);
        }
        return response;
    }

    protected static int[] parseList(Element eProp) {
        Element eIdList = eProp.getChild("object_list", XmlServlet.NS);
        List idList = eIdList.getChildren("id", XmlServlet.NS);
        int[] idArray = new int[idList.size()];
        for (int a = 0; a < idList.size(); ++a) {
            Element eId = (Element)idList.get(a);
            idArray[a] = DataParser.getValueAsInt(eId);
        }
        return idArray;
    }

    protected static Response[] parseGroupUserResponse(Element eResponse) {
        int a;
        Element ePropstat = eResponse.getChild("propstat", webdav);
        Element eProp = ePropstat.getChild("prop", webdav);
        Element eUsers = eProp.getChild("users", XmlServlet.NS);
        Element eGroups = eProp.getChild("groups", XmlServlet.NS);
        Element eResources = eProp.getChild("resources", XmlServlet.NS);
        Element eResourcegroups = eProp.getChild("resourcegroups", XmlServlet.NS);
        List userList = eUsers != null ? eUsers.getChildren("user", XmlServlet.NS) : Collections.emptyList();
        List groupList = eGroups != null ? eGroups.getChildren("group", XmlServlet.NS) : Collections.emptyList();
        List resourceList = eResources != null ? eResources.getChildren("resource", XmlServlet.NS) : Collections.emptyList();
        List resourcegroupList = eResourcegroups != null ? eResourcegroups.getChildren("resourcegroup", XmlServlet.NS) : Collections.emptyList();
        Response[] response = new Response[userList.size() + groupList.size() + resourceList.size() + resourcegroupList.size()];
        int counter = 0;
        int size = userList.size();
        for (a = 0; a < size; ++a) {
            response[counter] = new Response();
            response[counter].setDataObject(ResponseParser.parseUserResponse((Element)userList.get(a)));
            response[counter].setStatus(200);
            ++counter;
        }
        size = groupList.size();
        for (a = 0; a < size; ++a) {
            response[counter] = new Response();
            response[counter].setDataObject(ResponseParser.parseGroupResponse((Element)groupList.get(a)));
            response[counter].setStatus(200);
            ++counter;
        }
        size = resourceList.size();
        for (a = 0; a < size; ++a) {
            response[counter] = new Response();
            response[counter].setDataObject(ResponseParser.parseResourceResponse((Element)resourceList.get(a)));
            response[counter].setStatus(200);
            ++counter;
        }
        size = resourcegroupList.size();
        for (a = 0; a < size; ++a) {
            response[counter] = new Response();
            response[counter].setDataObject(ResponseParser.parseResourceGroupResponse((Element)resourcegroupList.get(a)));
            response[counter].setStatus(200);
            ++counter;
        }
        return response;
    }

    protected static Appointment parseAppointmentResponse(Element eProp) throws OXException {
        Appointment appointmentObj = new Appointment();
        AppointmentParser appointmentParser = new AppointmentParser();
        appointmentParser.parse(appointmentObj, eProp);
        return appointmentObj;
    }

    protected static Contact parseContactResponse(Element eProp) {
        Contact contactObj = new Contact();
        ContactParser contactParser = new ContactParser();
        contactParser.parse(contactObj, eProp);
        return contactObj;
    }

    protected static FolderObject parseFolderResponse(Element eProp) throws OXException, OXException {
        FolderObject folderObj = new FolderObject();
        FolderParser folderParser = new FolderParser();
        folderParser.parse(folderObj, eProp);
        return folderObj;
    }

    protected static Task parseTaskResponse(Element eProp) throws OXException {
        Task taskObj = new Task();
        TaskParser taskParser = new TaskParser();
        taskParser.parse(taskObj, eProp);
        return taskObj;
    }

    protected static Contact parseUserResponse(Element eProp) {
        Contact contactObj = new Contact();
        ContactParser contactParser = new ContactParser();
        contactParser.parse(contactObj, eProp);
        LinkedHashMap<String, String> hm = new LinkedHashMap<String, String>(4);
        if (DataParser.hasElement(eProp.getChild("myidentity", XmlServlet.NS))) {
            hm.put("myidentity", DataParser.getValue(eProp.getChild("myidentity", XmlServlet.NS)));
        }
        if (DataParser.hasElement(eProp.getChild("context_id", XmlServlet.NS))) {
            hm.put("context_id", DataParser.getValue(eProp.getChild("context_id", XmlServlet.NS)));
        }
        contactObj.setMap(hm);
        return contactObj;
    }

    protected static Group parseGroupResponse(Element eProp) {
        Group groupObj = new Group();
        GroupParser groupParser = new GroupParser();
        groupParser.parse(groupObj, eProp);
        return groupObj;
    }

    protected static Resource parseResourceResponse(Element eProp) {
        Resource resourceObj = new Resource();
        ResourceParser resourceParser = new ResourceParser();
        resourceParser.parse(resourceObj, eProp);
        return resourceObj;
    }

    protected static ResourceGroup parseResourceGroupResponse(Element eProp) {
        ResourceGroup resourcegroupObj = new ResourceGroup();
        ResourceGroupParser resourcegroupParser = new ResourceGroupParser();
        resourcegroupParser.parse(resourcegroupObj, eProp);
        return resourcegroupObj;
    }
}

