/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.appointment;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.webdav.xml.AppointmentTest;
import com.openexchange.webdav.xml.FolderTest;
import java.util.Date;

public class Bug12050Test
extends AppointmentTest {
    private int objectId = -1;
    private Appointment appointment;
    private Appointment exception;
    private Appointment exceptionUpdate;

    public Bug12050Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        FolderTest.clearFolder(this.webCon, new int[]{this.appointmentFolderId}, new String[]{"calendar"}, new Date(), "http://" + this.hostName, this.login, this.password, this.context);
        this.appointment = new Appointment();
        this.appointment.setTitle("testBug12050");
        this.appointment.setStartDate(this.startTime);
        this.appointment.setEndDate(this.endTime);
        this.appointment.setParentFolderID(this.appointmentFolderId);
        this.appointment.setRecurrenceType(1);
        this.appointment.setInterval(1);
        this.appointment.setOccurrence(3);
        this.appointment.setIgnoreConflicts(true);
        this.exception = new Appointment();
        this.exception.setParentFolderID(this.appointmentFolderId);
        this.exception.setRecurrencePosition(2);
        this.exception.setTitle("testBug12050 - Exception");
        this.exceptionUpdate = new Appointment();
        this.exceptionUpdate.setParentFolderID(this.appointmentFolderId);
        Date exceptionStart = new Date(this.startTime.getTime() + 90000000L);
        this.exceptionUpdate.setStartDate(exceptionStart);
        Date exceptionEnd = new Date(this.endTime.getTime() + 90000000L);
        this.exceptionUpdate.setEndDate(exceptionEnd);
    }

    public void testBug12050() throws Exception {
        this.createAppointment();
        this.createException();
        this.updateException();
    }

    public void tearDown() throws Exception {
        if (this.objectId != -1) {
            Bug12050Test.deleteAppointment(this.getWebConversation(), this.objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        }
        super.tearDown();
    }

    private void createAppointment() throws Exception {
        this.objectId = Bug12050Test.insertAppointment(this.getWebConversation(), this.appointment, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        this.appointment.setObjectID(this.objectId);
    }

    private void createException() throws Exception {
        this.exception.setLastModified(this.appointment.getLastModified());
        int exceptionId = Bug12050Test.updateAppointment(this.getWebConversation(), this.exception, this.objectId, this.appointmentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        this.exception.setObjectID(exceptionId);
    }

    private void updateException() throws Exception {
        this.exceptionUpdate.setLastModified(this.exception.getLastModified());
        this.exceptionUpdate.setObjectID(this.exception.getObjectID());
        try {
            Bug12050Test.updateAppointment(this.getWebConversation(), this.exceptionUpdate, this.exception.getObjectID(), this.appointmentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        }
        catch (OXException e) {
            Bug12050Test.fail((String)e.getMessage());
        }
    }
}

