/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.protocol;

import com.openexchange.webdav.protocol.AbstractResourceTest;
import com.openexchange.webdav.protocol.TestWebdavFactoryBuilder;
import com.openexchange.webdav.protocol.WebdavCollection;
import com.openexchange.webdav.protocol.WebdavFactory;
import com.openexchange.webdav.protocol.WebdavLock;
import com.openexchange.webdav.protocol.WebdavMethod;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavResource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;

public class LockInteractionTest
extends TestCase {
    protected static WebdavFactory FACTORY = null;
    protected static final Random RANDOM = new Random();
    private WebdavPath testCollection;

    public void setUp() throws Exception {
        TestWebdavFactoryBuilder.setUp();
        FACTORY = TestWebdavFactoryBuilder.buildFactory();
        FACTORY.beginRequest();
        this.testCollection = new WebdavPath(new String[]{"public_infostore", "testCollection" + RANDOM.nextInt()});
        FACTORY.resolveCollection(this.testCollection).create();
    }

    public void tearDown() throws Exception {
        FACTORY.resolveCollection(this.testCollection).delete();
        FACTORY.endRequest(200);
        TestWebdavFactoryBuilder.tearDown();
    }

    private WebdavLock getLock(int depth) {
        WebdavLock lock = new WebdavLock();
        lock.setDepth(depth);
        lock.setOwner("me");
        lock.setScope(WebdavLock.Scope.EXCLUSIVE_LITERAL);
        lock.setTimeout(-1L);
        lock.setType(WebdavLock.Type.WRITE_LITERAL);
        return lock;
    }

    public void lockInheritanceTest(int depth, int lockNumber) throws Exception {
        WebdavLock lock = this.getLock(depth);
        WebdavCollection collection = FACTORY.resolveCollection(this.testCollection);
        collection.lock(lock);
        WebdavResource res = collection.resolveResource(new WebdavPath((CharSequence)"test.txt"));
        res.create();
        LockInteractionTest.assertEquals((int)lockNumber, (int)res.getLocks().size());
    }

    public void testCreateInDepth0LockedCollection() throws Exception {
        this.lockInheritanceTest(0, 0);
    }

    public void testCreateInDepth1LockedCollection() throws Exception {
        this.lockInheritanceTest(1, 1);
    }

    public void testCreateInDepthInfinityLockedCollection() throws Exception {
        this.lockInheritanceTest(-1, 1);
    }

    public void testDeleteLocked() throws Exception {
        WebdavLock lock = this.getLock(0);
        WebdavCollection collection = FACTORY.resolveCollection(this.testCollection);
        WebdavResource res = collection.resolveResource(new WebdavPath((CharSequence)"test.txt"));
        res.create();
        res.lock(lock);
        res.delete();
        res = collection.resolveResource(new WebdavPath((CharSequence)"test.txt"));
        LockInteractionTest.assertEquals((int)0, (int)res.getLocks().size());
    }

    public void testMoveLocked() throws Exception {
        WebdavLock lock = this.getLock(0);
        WebdavCollection collection = FACTORY.resolveCollection(this.testCollection);
        WebdavResource res = collection.resolveResource(new WebdavPath((CharSequence)"test.txt"));
        res.create();
        res.lock(lock);
        res.move(this.testCollection.dup().append(new String[]{"test2.txt"}));
        res = collection.resolveResource(new WebdavPath((CharSequence)"test2.txt"));
        LockInteractionTest.assertEquals((int)0, (int)res.getLocks().size());
    }

    public void testCreateLockNullResource() throws Exception {
        WebdavLock lock = this.getLock(0);
        WebdavCollection collection = FACTORY.resolveCollection(this.testCollection);
        WebdavResource res = collection.resolveResource(new WebdavPath((CharSequence)"test.txt"));
        res.lock(lock);
        res = collection.resolveResource(new WebdavPath((CharSequence)"test.txt"));
        LockInteractionTest.assertTrue((boolean)res.isLockNull());
        LockInteractionTest.assertTrue((boolean)res.exists());
        LockInteractionTest.assertEquals((int)0, (int)collection.getChildren().size());
    }

    public void testRemoveLockNullResource() throws Exception {
        WebdavLock lock = this.getLock(0);
        WebdavCollection collection = FACTORY.resolveCollection(this.testCollection);
        WebdavResource res = collection.resolveResource(new WebdavPath((CharSequence)"test.txt"));
        res.lock(lock);
        res = collection.resolveResource(new WebdavPath((CharSequence)"test.txt"));
        LockInteractionTest.assertTrue((boolean)res.isLockNull());
        res.unlock(lock.getToken());
        res = collection.resolveResource(new WebdavPath((CharSequence)"test.txt"));
        LockInteractionTest.assertFalse((boolean)res.exists());
    }

    public void testLockNullProperties() throws Exception {
        this.testCreateLockNullResource();
        WebdavResource res = FACTORY.resolveResource(this.testCollection.dup().append(new String[]{"test.txt"}));
        LockInteractionTest.assertNull((Object)res.getProperty("DAV:", "creationdate"));
        LockInteractionTest.assertNull((Object)res.getProperty("DAV:", "getcontentlanguage"));
        LockInteractionTest.assertNull((Object)res.getProperty("DAV:", "getcontentlength"));
        LockInteractionTest.assertNull((Object)res.getProperty("DAV:", "getetag"));
        LockInteractionTest.assertNull((Object)res.getProperty("DAV:", "getcontenttype"));
        LockInteractionTest.assertNull((Object)res.getProperty("DAV:", "getlastmodified"));
        LockInteractionTest.assertNull((Object)res.getProperty("DAV:", "resourcetype"));
        LockInteractionTest.assertNull((Object)res.getProperty("DAV:", "source"));
        LockInteractionTest.assertNotNull((Object)res.getProperty("DAV:", "displayname"));
        LockInteractionTest.assertNotNull((Object)res.getProperty("DAV:", "lockdiscovery"));
        LockInteractionTest.assertNotNull((Object)res.getProperty("DAV:", "supportedlock"));
    }

    public void testLockNullOptions() throws Exception {
        WebdavLock lock = this.getLock(0);
        WebdavCollection collection = FACTORY.resolveCollection(this.testCollection);
        WebdavResource res = collection.resolveResource(new WebdavPath((CharSequence)"test.txt"));
        res.lock(lock);
        res = collection.resolveResource(new WebdavPath((CharSequence)"test.txt"));
        WebdavMethod[] methods = res.getOptions();
        List<WebdavMethod> expect = Arrays.asList(WebdavMethod.PUT, WebdavMethod.MKCOL, WebdavMethod.OPTIONS, WebdavMethod.PROPFIND, WebdavMethod.LOCK, WebdavMethod.UNLOCK, WebdavMethod.TRACE);
        AbstractResourceTest.assertOptions(expect, methods);
    }

    public void testTransformLockNullResource() throws Exception {
        WebdavLock lock = this.getLock(0);
        WebdavCollection collection = FACTORY.resolveCollection(this.testCollection);
        WebdavResource res = collection.resolveResource(new WebdavPath((CharSequence)"test.txt"));
        res.lock(lock);
        res = collection.resolveResource(new WebdavPath((CharSequence)"test.txt"));
        res.putBodyAndGuessLength((InputStream)new ByteArrayInputStream(new byte[2]));
        res.create();
        res = collection.resolveResource(new WebdavPath((CharSequence)"test.txt"));
        LockInteractionTest.assertTrue((boolean)res.exists());
        LockInteractionTest.assertFalse((boolean)res.isCollection());
        LockInteractionTest.assertFalse((boolean)res.isLockNull());
        LockInteractionTest.assertEquals((int)1, (int)res.getLocks().size());
        LockInteractionTest.assertNotNull((Object)res.getLock(lock.getToken()));
        res.unlock(lock.getToken());
        res.save();
    }

    public void testTransformLockNullCollection() throws Exception {
        WebdavLock lock = this.getLock(0);
        WebdavCollection collection = FACTORY.resolveCollection(this.testCollection);
        WebdavResource res = collection.resolveResource(new WebdavPath((CharSequence)"test"));
        res.lock(lock);
        res = collection.resolveCollection(new WebdavPath((CharSequence)"test"));
        res.create();
        res = collection.resolveResource(new WebdavPath((CharSequence)"test"));
        LockInteractionTest.assertTrue((boolean)res.exists());
        LockInteractionTest.assertTrue((boolean)res.isCollection());
        LockInteractionTest.assertFalse((boolean)res.isLockNull());
        LockInteractionTest.assertEquals((int)1, (int)res.getLocks().size());
        LockInteractionTest.assertNotNull((Object)res.getLock(lock.getToken()));
    }
}

