/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.servlet.ratelimit;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.SimConfigurationService;
import com.openexchange.java.ConcurrentHashSet;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.threadpool.internal.ThreadPoolProperties;
import com.openexchange.threadpool.internal.ThreadPoolServiceImpl;
import com.openexchange.timer.TimerService;
import com.openexchange.timer.internal.CustomThreadPoolExecutorTimerService;
import com.openexchange.tools.servlet.ratelimit.Key;
import com.openexchange.tools.servlet.ratelimit.RateLimiter;
import java.util.Random;
import junit.framework.TestCase;

public class Bug41499Test
extends TestCase {
    private static final int MAX_RATE = 1500;
    private static final int MAX_RATE_TIME_WINDOW = 5000;
    private static final int THREAD_COUNT = 10;
    private static final int REQUESTS_PER_THREAD = 10;

    public void setUp() throws Exception {
        super.setUp();
        ServerServiceRegistry services = ServerServiceRegistry.getInstance();
        SimConfigurationService configService = new SimConfigurationService();
        configService.stringProperties.put("com.openexchange.servlet.maxRate", String.valueOf(1500));
        configService.stringProperties.put("com.openexchange.servlet.maxRateTimeWindow", String.valueOf(5000));
        services.addService(ConfigurationService.class, (Object)configService);
        ThreadPoolServiceImpl threadPoolService = ThreadPoolServiceImpl.newInstance((ThreadPoolProperties)new ThreadPoolProperties().init((ConfigurationService)configService));
        CustomThreadPoolExecutorTimerService timerService = new CustomThreadPoolExecutorTimerService(threadPoolService.getThreadPoolExecutor());
        services.addService(TimerService.class, (Object)timerService);
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRateLimiterEviction() throws Exception {
        int i;
        final ConcurrentHashSet expectedSlots = new ConcurrentHashSet();
        final Random random = new Random();
        Thread[] threads = new Thread[10];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 10; ++i) {
                    String userAgent = "userAgent" + random.nextInt(10);
                    String remoteAddr = "192.168.32." + random.nextInt(256);
                    Key key = new Key(0, remoteAddr, userAgent, null);
                    expectedSlots.add((Object)key);
                    RateLimiter.checkRateLimitFor((Key)key, (int)1500, (int)5000, null);
                }
            }
        };
        for (i = 0; i < 10; ++i) {
            threads[i] = new Thread(runnable);
        }
        for (i = 0; i < 10; ++i) {
            threads[i].start();
        }
        for (i = 0; i < 10; ++i) {
            threads[i].join();
        }
        Bug41499Test.assertEquals((long)100L, (long)RateLimiter.getProcessedRequests());
        Bug41499Test.assertEquals((int)expectedSlots.size(), (int)((int)RateLimiter.getSlotCount((boolean)true)));
        Thread.sleep(10000L);
        Bug41499Test.assertEquals((long)0L, (long)RateLimiter.getSlotCount((boolean)true));
    }
}

