/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures;

import com.openexchange.exception.OXException;
import com.openexchange.mailaccount.internal.CustomMailAccount;
import com.openexchange.test.fixtures.DefaultFixtures;
import com.openexchange.test.fixtures.Fixture;
import com.openexchange.test.fixtures.FixtureException;
import com.openexchange.test.fixtures.FixtureFactory;
import com.openexchange.test.fixtures.FixtureLoader;
import com.openexchange.test.fixtures.Fixtures;
import com.openexchange.test.fixtures.transformators.BooleanTransformator;
import com.openexchange.test.fixtures.transformators.Transformator;
import java.util.HashMap;
import java.util.Map;

public class MultiMailFixtureFactory
implements FixtureFactory<CustomMailAccount> {
    private final FixtureLoader fixtureLoader;

    public MultiMailFixtureFactory(FixtureLoader fixtureLoader) {
        this.fixtureLoader = fixtureLoader;
    }

    @Override
    public Fixtures<CustomMailAccount> createFixture(String fixtureName, Map<String, Map<String, String>> entries) {
        return new MultiMailFixtures(fixtureName, entries, this.fixtureLoader);
    }

    private class MultiMailFixtures
    extends DefaultFixtures<CustomMailAccount>
    implements Fixtures<CustomMailAccount> {
        private final Map<String, Map<String, String>> entries;
        private final Map<String, Fixture<CustomMailAccount>> mailaccounts;

        public MultiMailFixtures(String fixtureName, Map<String, Map<String, String>> entries, FixtureLoader fixtureLoader) {
            super(CustomMailAccount.class, entries, fixtureLoader);
            this.mailaccounts = new HashMap<String, Fixture<CustomMailAccount>>();
            this.entries = entries;
            this.addTransformator((Transformator)new BooleanTransformator(), "unified_inbox_enabled");
            this.addTransformator((Transformator)new BooleanTransformator(), "mail_secure");
            this.addTransformator((Transformator)new BooleanTransformator(), "transport_secure");
        }

        @Override
        public Fixture<CustomMailAccount> getEntry(String entryName) throws OXException {
            if (this.mailaccounts.containsKey(entryName)) {
                return this.mailaccounts.get(entryName);
            }
            Map<String, String> values = this.entries.get(entryName);
            if (null == values) {
                throw new FixtureException("Entry with name " + entryName + " not found");
            }
            this.defaults(values);
            CustomMailAccount customMailAccount = new CustomMailAccount(0);
            this.apply(customMailAccount, values);
            Fixture<CustomMailAccount> fixture = new Fixture<CustomMailAccount>(customMailAccount, values.keySet().toArray(new String[values.size()]), values);
            this.mailaccounts.put(entryName, fixture);
            return fixture;
        }

        private void defaults(Map<String, String> values) {
        }
    }
}

