/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.messagestorage;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.messagestorage.MessageStorageTest;

public final class MailColorLabelTest
extends MessageStorageTest {
    private static final MailField[] FIELDS_ID_AND_COLORLABEL = new MailField[]{MailField.ID, MailField.COLOR_LABEL};

    public void testMailColorLabelNonExistingIds() throws OXException {
        if (!this.mailAccess.getFolderStorage().getFolder("INBOX").isSupportsUserFlags()) {
            System.err.println("User flags not supported. Skipping test for non-exsiting ids");
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (int i = 0; i < 11; ++i) {
            this.mailAccess.getMessageStorage().updateMessageColorLabel("INBOX", new String[]{String.valueOf(currentTimeMillis), String.valueOf(currentTimeMillis + 1L)}, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailColorLabelNonExistingIdsMixed() throws OXException {
        if (!this.mailAccess.getFolderStorage().getFolder("INBOX").isSupportsUserFlags()) {
            System.err.println("User flags not supported. Skipping test for non-exsiting mixed ids");
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        String[] uids = this.mailAccess.getMessageStorage().appendMessages("INBOX", this.testmessages);
        try {
            for (int i = 0; i < 11; ++i) {
                this.mailAccess.getMessageStorage().updateMessageColorLabel("INBOX", new String[]{String.valueOf(currentTimeMillis), uids[0]}, i);
                MailMessage[] fetchedMails = this.mailAccess.getMessageStorage().getMessages("INBOX", new String[]{uids[0]}, FIELDS_ID_AND_COLORLABEL);
                MailColorLabelTest.assertTrue((String)"Missing color label", (boolean)fetchedMails[0].containsColorLabel());
                MailColorLabelTest.assertTrue((String)"Mail's color flag does not carry expected value", (fetchedMails[0].getColorLabel() == i ? 1 : 0) != 0);
            }
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailColorLabelNotExistingFolder() throws OXException {
        String[] uids = this.mailAccess.getMessageStorage().appendMessages("INBOX", this.testmessages);
        try {
            for (int i = 0; i < 11; ++i) {
                try {
                    this.mailAccess.getMessageStorage().updateMessageColorLabel("MichGibtEsNicht1337", uids, i);
                    continue;
                }
                catch (OXException e) {
                    MailColorLabelTest.assertTrue((String)"Wrong Exception is thrown.", (boolean)e.getErrorCode().endsWith("-1002"));
                }
            }
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailColorLabel() throws OXException {
        if (!this.mailAccess.getFolderStorage().getFolder("INBOX").isSupportsUserFlags()) {
            System.err.println("User flags not supported. Skipping test for color labels");
            return;
        }
        String[] uids = this.mailAccess.getMessageStorage().appendMessages("INBOX", this.testmessages);
        try {
            for (int i = 0; i < 11; ++i) {
                this.mailAccess.getMessageStorage().updateMessageColorLabel("INBOX", uids, i);
                MailMessage[] fetchedMails = this.mailAccess.getMessageStorage().getMessages("INBOX", uids, FIELDS_ID_AND_COLORLABEL);
                for (int o = 0; o < fetchedMails.length; ++o) {
                    MailColorLabelTest.assertTrue((String)"Missing color label", (boolean)fetchedMails[o].containsColorLabel());
                    MailColorLabelTest.assertTrue((String)"Mail's color flag does not carry expected value", (fetchedMails[o].getColorLabel() == i ? 1 : 0) != 0);
                }
            }
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
        }
    }
}

