/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests.untiltests;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class UntilTest
extends CalendarSqlTest {
    protected static final int MONTHLY2 = 5;
    protected static final int YEARLY2 = 6;
    protected static final Date u = TimeTools.D("01.02.2016 00:00");
    protected static final int occ = 10;
    protected CalendarDataObject setUntil;
    protected CalendarDataObject setOccurrences;
    protected CalendarDataObject removeUntil;
    protected static final Map<Integer, Date> generatedUntils = new HashMap<Integer, Date>(){
        {
            this.put(1, TimeTools.D("10.02.2010 00:00"));
            this.put(2, TimeTools.D("05.04.2010 00:00"));
            this.put(3, TimeTools.D("01.11.2010 00:00"));
            this.put(4, TimeTools.D("01.02.2019 00:00"));
            this.put(5, TimeTools.D("01.11.2010 00:00"));
            this.put(6, TimeTools.D("04.02.2019 00:00"));
        }
    };

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.setUntil = new CalendarDataObject();
        this.setUntil.setUntil(u);
        this.setOccurrences = new CalendarDataObject();
        this.setOccurrences.setOccurrence(10);
        this.removeUntil = new CalendarDataObject();
        this.removeUntil.setUntil(null);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    protected CalendarDataObject createAppointment(int type, boolean occurrences, boolean until, boolean fulltime) throws Exception {
        CalendarDataObject retval = null;
        if (fulltime) {
            retval = this.getAppointment("01.02.2010 00:00", "02.02.2010 00:00");
            retval.setTitle("Until Test - fulltime");
            retval.setFullTime(true);
        } else {
            retval = this.getAppointment("01.02.2010 08:00", "01.02.2010 10:00");
            retval.setTitle("Until Test");
        }
        if (until) {
            retval.setUntil(u);
            retval.setTitle(retval.getTitle() + " - until (01.02.2016)");
        }
        if (occurrences) {
            retval.setOccurrence(10);
            retval.setTitle(retval.getTitle() + " - occurrences (10)");
        }
        retval.setRecurrenceType(type);
        retval.setInterval(1);
        retval.setIgnoreConflicts(true);
        switch (type) {
            case 1: {
                retval.setTitle(retval.getTitle() + " - daily");
                break;
            }
            case 2: {
                retval.setDays(2);
                retval.setTitle(retval.getTitle() + " - weekly");
                break;
            }
            case 3: {
                retval.setDayInMonth(1);
                retval.setTitle(retval.getTitle() + " - monthly");
                break;
            }
            case 5: {
                retval.setRecurrenceType(3);
                retval.setDayInMonth(1);
                retval.setDays(2);
                retval.setTitle(retval.getTitle() + " - monthly2");
                break;
            }
            case 4: {
                retval.setDayInMonth(1);
                retval.setMonth(1);
                retval.setTitle(retval.getTitle() + " - yearly");
                break;
            }
            case 6: {
                retval.setRecurrenceType(4);
                retval.setDayInMonth(1);
                retval.setDays(2);
                retval.setMonth(1);
                retval.setTitle(retval.getTitle() + " - yearly2");
                break;
            }
            default: {
                throw new Exception("Bad recurrence type.");
            }
        }
        this.insertAppointment(retval);
        return retval;
    }

    private CalendarDataObject getAppointment(String start, String end) {
        return this.appointments.buildBasicAppointment(TimeTools.D(start), TimeTools.D(end));
    }

    private void insertAppointment(CalendarDataObject appointment) throws Exception {
        this.appointments.save(appointment);
        this.clean.add(appointment);
    }

    protected void updateAppointment(CalendarDataObject old, CalendarDataObject update) throws OXException {
        CalendarDataObject copy = this.appointments.createIdentifyingCopy(old);
        this.overrideRecurringInformation(old, copy);
        this.overrideRecurringInformation(update, copy);
        copy.setIgnoreConflicts(true);
        this.appointments.save(copy);
    }

    private void overrideRecurringInformation(CalendarDataObject source, CalendarDataObject target) {
        if (source.containsRecurrenceType()) {
            target.setRecurrenceType(source.getRecurrenceType());
        }
        if (source.containsOccurrence()) {
            target.setOccurrence(source.getOccurrence());
        } else {
            target.removeOccurrence();
        }
        if (source.containsUntil()) {
            target.setUntil(source.getUntil());
        } else {
            target.removeUntil();
        }
        ArrayList<Integer> fields = new ArrayList<Integer>(){
            {
                this.add(212);
                this.add(213);
                this.add(214);
                this.add(215);
            }
        };
        Iterator i$ = fields.iterator();
        while (i$.hasNext()) {
            int field = (Integer)i$.next();
            if (!source.contains(field)) continue;
            target.set(field, source.get(field));
        }
    }

    protected void checkUntilInformation(CalendarDataObject appointment, Date until, Integer occurrences) throws Exception {
        CalendarDataObject loaded = this.appointments.load(appointment.getObjectID(), appointment.getParentFolderID());
        if (until == null) {
            UntilTest.assertFalse((String)"Unexpected Until value.", (boolean)loaded.containsUntil());
        } else {
            UntilTest.assertTrue((String)"Until not set.", (boolean)loaded.containsUntil());
            UntilTest.assertEquals((String)"Wrong Until value.", (Object)until, (Object)loaded.getUntil());
        }
        if (occurrences == null) {
            UntilTest.assertFalse((String)"Unexpected Occurrences value.", (boolean)loaded.containsOccurrence());
            UntilTest.assertEquals((String)"Unexpected Occurrences value.", (int)0, (int)loaded.getOccurrence());
        } else {
            UntilTest.assertTrue((String)"Occurrences not set.", (boolean)loaded.containsOccurrence());
            UntilTest.assertEquals((String)"Wrong occurrences value.", (int)occurrences, (int)loaded.getOccurrence());
        }
    }

    protected void withoutTest(int type, boolean fulltime) throws Exception {
        CalendarDataObject without = this.createAppointment(type, false, false, fulltime);
        this.checkUntilInformation(without, null, null);
        this.updateAppointment(without, this.setUntil);
        this.checkUntilInformation(without, u, null);
        this.updateAppointment(without, this.setOccurrences);
        this.checkUntilInformation(without, generatedUntils.get(type), 10);
        this.updateAppointment(without, this.removeUntil);
        this.checkUntilInformation(without, null, null);
        without = this.createAppointment(type, false, false, fulltime);
        this.updateAppointment(without, this.setOccurrences);
        this.checkUntilInformation(without, generatedUntils.get(type), 10);
        this.updateAppointment(without, this.setUntil);
        this.checkUntilInformation(without, u, null);
        this.updateAppointment(without, this.removeUntil);
        this.checkUntilInformation(without, null, null);
    }

    protected void withOccurrencesTest(int type, boolean fulltime) throws Exception {
        CalendarDataObject withOccurrences = this.createAppointment(type, true, false, fulltime);
        this.checkUntilInformation(withOccurrences, generatedUntils.get(type), 10);
        this.updateAppointment(withOccurrences, this.removeUntil);
        this.checkUntilInformation(withOccurrences, null, null);
        this.updateAppointment(withOccurrences, this.setUntil);
        this.checkUntilInformation(withOccurrences, u, null);
        this.updateAppointment(withOccurrences, this.setOccurrences);
        this.checkUntilInformation(withOccurrences, generatedUntils.get(type), 10);
        withOccurrences = this.createAppointment(type, true, false, fulltime);
        this.updateAppointment(withOccurrences, this.setUntil);
        this.checkUntilInformation(withOccurrences, u, null);
        this.updateAppointment(withOccurrences, this.removeUntil);
        this.checkUntilInformation(withOccurrences, null, null);
        this.updateAppointment(withOccurrences, this.setOccurrences);
        this.checkUntilInformation(withOccurrences, generatedUntils.get(type), 10);
    }

    protected void withUntilTest(int type, boolean fulltime) throws Exception {
        CalendarDataObject withUntil = this.createAppointment(type, false, true, fulltime);
        this.checkUntilInformation(withUntil, u, null);
        this.updateAppointment(withUntil, this.removeUntil);
        this.checkUntilInformation(withUntil, null, null);
        this.updateAppointment(withUntil, this.setOccurrences);
        this.checkUntilInformation(withUntil, generatedUntils.get(type), 10);
        this.updateAppointment(withUntil, this.setUntil);
        this.checkUntilInformation(withUntil, u, null);
        withUntil = this.createAppointment(type, false, true, fulltime);
        this.updateAppointment(withUntil, this.setOccurrences);
        this.checkUntilInformation(withUntil, generatedUntils.get(type), 10);
        this.updateAppointment(withUntil, this.removeUntil);
        this.checkUntilInformation(withUntil, null, null);
        this.updateAppointment(withUntil, this.setUntil);
        this.checkUntilInformation(withUntil, u, null);
    }
}

