/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import com.openexchange.groupware.calendar.tools.CommonAppointments;
import java.sql.SQLException;
import java.util.Date;

public class Bug11307Test
extends CalendarSqlTest {
    public void testRecurringAppointmentShouldBeConvertibleToSingleAppointment() throws OXException, SQLException {
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        CalendarDataObject appointment = this.appointments.buildBasicAppointment(start, end);
        appointment.setTitle("unzelll");
        appointment.setRecurrenceType(2);
        appointment.setDays(4);
        appointment.setInterval(1);
        appointment.setRecurrenceCount(3);
        this.appointments.save(appointment);
        this.clean.add(appointment);
        CalendarDataObject update = this.appointments.createIdentifyingCopy(appointment);
        update.setRecurrenceType(0);
        update.setStartDate(start);
        update.setEndDate(end);
        this.appointments.save(update);
        CalendarDataObject reloaded = this.appointments.reload(appointment);
        Bug11307Test.assertEquals((String)"Wrong start date", (long)start.getTime(), (long)reloaded.getStartDate().getTime());
        Bug11307Test.assertEquals((String)"Wrong end date", (Object)end, (Object)reloaded.getEndDate());
        Bug11307Test.assertEquals((String)"Wrong recurrence type", (int)0, (int)reloaded.getRecurrenceType());
    }
}

