/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheService;
import com.openexchange.caching.events.CacheEventConfiguration;
import com.openexchange.caching.events.CacheEventService;
import com.openexchange.caching.events.internal.CacheEventServiceImpl;
import com.openexchange.caching.internal.JCSCacheService;
import com.openexchange.caching.internal.JCSCacheServiceInit;
import com.openexchange.calendar.CalendarAdministration;
import com.openexchange.calendar.CalendarReminderDelete;
import com.openexchange.calendar.api.AppointmentSqlFactory;
import com.openexchange.calendar.api.CalendarCollection;
import com.openexchange.calendar.cache.CalendarVolatileCache;
import com.openexchange.capabilities.CapabilityChecker;
import com.openexchange.capabilities.CapabilityService;
import com.openexchange.capabilities.internal.AbstractCapabilityService;
import com.openexchange.charset.CollectionCharsetProvider;
import com.openexchange.charset.CustomCharsetProvider;
import com.openexchange.charset.CustomCharsetProviderInit;
import com.openexchange.charset.ModifyCharsetExtendedProvider;
import com.openexchange.cluster.timer.ClusterTimerService;
import com.openexchange.cluster.timer.internal.ClusterTimerServiceImpl;
import com.openexchange.config.ConfigurationService;
import com.openexchange.config.ConfigurationServiceHolder;
import com.openexchange.config.cascade.ConfigProviderService;
import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.config.cascade.impl.ConfigCascade;
import com.openexchange.config.cascade.impl.InMemoryConfigProvider;
import com.openexchange.config.internal.ConfigurationImpl;
import com.openexchange.config.internal.filewatcher.FileWatcher;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.configuration.SystemConfig;
import com.openexchange.contact.ContactService;
import com.openexchange.contact.internal.ContactServiceImpl;
import com.openexchange.contact.internal.ContactServiceLookup;
import com.openexchange.contact.storage.ContactStorage;
import com.openexchange.contact.storage.internal.DefaultContactStorageRegistry;
import com.openexchange.contact.storage.rdb.internal.RdbContactStorage;
import com.openexchange.contact.storage.rdb.internal.RdbServiceLookup;
import com.openexchange.contact.storage.registry.ContactStorageRegistry;
import com.openexchange.contacts.json.converters.ContactInsertDataHandler;
import com.openexchange.context.ContextService;
import com.openexchange.context.internal.ContextServiceImpl;
import com.openexchange.conversion.ConversionService;
import com.openexchange.conversion.DataHandler;
import com.openexchange.conversion.DataSource;
import com.openexchange.conversion.engine.internal.ConversionEngineRegistry;
import com.openexchange.conversion.engine.internal.ConversionServiceImpl;
import com.openexchange.data.conversion.ical.ICalEmitter;
import com.openexchange.data.conversion.ical.ICalParser;
import com.openexchange.data.conversion.ical.ical4j.ICal4JEmitter;
import com.openexchange.data.conversion.ical.ical4j.ICal4JParser;
import com.openexchange.data.conversion.ical.ical4j.internal.OXResourceResolver;
import com.openexchange.data.conversion.ical.ical4j.internal.OXUserResolver;
import com.openexchange.data.conversion.ical.ical4j.internal.calendar.CreatedBy;
import com.openexchange.data.conversion.ical.ical4j.internal.calendar.Participants;
import com.openexchange.database.DatabaseService;
import com.openexchange.databaseold.Database;
import com.openexchange.event.impl.AppointmentEventInterface;
import com.openexchange.event.impl.EventDispatcher;
import com.openexchange.event.impl.EventInit;
import com.openexchange.event.impl.EventQueue;
import com.openexchange.event.impl.TaskEventInterface;
import com.openexchange.exception.OXException;
import com.openexchange.filestore.FileStorageService;
import com.openexchange.filestore.FileStorages;
import com.openexchange.filestore.QuotaFileStorageService;
import com.openexchange.filestore.impl.CompositeFileStorageService;
import com.openexchange.filestore.impl.DBQuotaFileStorageService;
import com.openexchange.filestore.impl.osgi.Services;
import com.openexchange.folder.FolderService;
import com.openexchange.folder.internal.FolderInitialization;
import com.openexchange.folder.internal.FolderServiceImpl;
import com.openexchange.group.GroupService;
import com.openexchange.group.internal.GroupInit;
import com.openexchange.group.internal.GroupServiceImpl;
import com.openexchange.groupware.Component;
import com.openexchange.groupware.TestServiceRegistry;
import com.openexchange.groupware.alias.UserAliasStorage;
import com.openexchange.groupware.alias.impl.RdbAliasStorage;
import com.openexchange.groupware.attach.AttachmentConfig;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.calendar.CalendarAdministrationService;
import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.calendar.CalendarConfig;
import com.openexchange.groupware.configuration.ParticipantConfig;
import com.openexchange.groupware.contexts.impl.ContextInit;
import com.openexchange.groupware.generic.FolderUpdaterRegistry;
import com.openexchange.groupware.impl.id.IDGeneratorServiceImpl;
import com.openexchange.groupware.infostore.InfostoreConfig;
import com.openexchange.groupware.infostore.facade.impl.InfostoreFacadeImpl;
import com.openexchange.groupware.notify.NotificationConfig;
import com.openexchange.groupware.reminder.TargetService;
import com.openexchange.groupware.reminder.internal.TargetRegistry;
import com.openexchange.groupware.settings.impl.ConfigTreeInit;
import com.openexchange.groupware.update.internal.InternalList;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorageInit;
import com.openexchange.html.HtmlService;
import com.openexchange.html.internal.HtmlServiceImpl;
import com.openexchange.html.osgi.HTMLServiceActivator;
import com.openexchange.html.services.ServiceRegistry;
import com.openexchange.i18n.I18nService;
import com.openexchange.i18n.impl.I18nImpl;
import com.openexchange.i18n.impl.POTranslationsDiscoverer;
import com.openexchange.i18n.impl.ResourceBundleDiscoverer;
import com.openexchange.i18n.impl.TranslationsI18N;
import com.openexchange.i18n.parsing.Translations;
import com.openexchange.id.IDGeneratorService;
import com.openexchange.imap.IMAPProvider;
import com.openexchange.imap.storecache.IMAPStoreCache;
import com.openexchange.importexport.osgi.ImportExportServices;
import com.openexchange.mail.MailInitialization;
import com.openexchange.mail.MailProviderRegistry;
import com.openexchange.mail.api.MailProvider;
import com.openexchange.mail.autoconfig.AutoconfigService;
import com.openexchange.mail.autoconfig.internal.AutoconfigServiceImpl;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.conversion.VCardMailPartDataSource;
import com.openexchange.mail.transport.config.TransportPropertiesInit;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.mailaccount.internal.MailAccountStorageInit;
import com.openexchange.osgi.util.ServiceCallWrapperModifier;
import com.openexchange.passwordmechs.PasswordMechFactory;
import com.openexchange.passwordmechs.PasswordMechFactoryImpl;
import com.openexchange.push.udp.registry.PushServiceRegistry;
import com.openexchange.resource.ResourceService;
import com.openexchange.resource.internal.ResourceServiceImpl;
import com.openexchange.resource.internal.ResourceStorageInit;
import com.openexchange.server.Initialization;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.SimpleServiceLookup;
import com.openexchange.server.services.I18nServices;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.sessiond.impl.SessiondInit;
import com.openexchange.sessiond.impl.SessiondServiceImpl;
import com.openexchange.sessionstorage.SessionStorageService;
import com.openexchange.sessionstorage.TestSessionStorageService;
import com.openexchange.share.ShareService;
import com.openexchange.share.impl.DefaultShareService;
import com.openexchange.share.impl.cleanup.GuestCleaner;
import com.openexchange.sms.PhoneNumberParserService;
import com.openexchange.sms.impl.PhoneNumberParserServiceImpl;
import com.openexchange.spamhandler.SpamHandler;
import com.openexchange.spamhandler.SpamHandlerRegistry;
import com.openexchange.spamhandler.defaultspamhandler.DefaultSpamHandler;
import com.openexchange.spamhandler.spamassassin.SpamAssassinSpamHandler;
import com.openexchange.subscribe.SimSubscriptionSourceDiscoveryService;
import com.openexchange.subscribe.SubscriptionSourceDiscoveryService;
import com.openexchange.subscribe.internal.ContactFolderMultipleUpdaterStrategy;
import com.openexchange.subscribe.internal.ContactFolderUpdaterStrategy;
import com.openexchange.subscribe.internal.FolderUpdaterStrategy;
import com.openexchange.subscribe.internal.StrategyFolderUpdaterService;
import com.openexchange.subscribe.internal.SubscriptionExecutionServiceImpl;
import com.openexchange.subscribe.osgi.SubscriptionServiceRegistry;
import com.openexchange.test.TestInit;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.internal.DelegateExecutorService;
import com.openexchange.threadpool.internal.ThreadPoolProperties;
import com.openexchange.threadpool.internal.ThreadPoolServiceImpl;
import com.openexchange.threadpool.osgi.ThreadPoolActivator;
import com.openexchange.timer.TimerService;
import com.openexchange.timer.internal.CustomThreadPoolExecutorTimerService;
import com.openexchange.tools.events.TestEventAdmin;
import com.openexchange.tools.file.FileStorage;
import com.openexchange.tools.file.QuotaFileStorage;
import com.openexchange.tools.oxfolder.OXFolderProperties;
import com.openexchange.tools.strings.BasicTypesStringParser;
import com.openexchange.tools.strings.StringParser;
import com.openexchange.user.UserService;
import com.openexchange.user.UserServiceInterceptor;
import com.openexchange.user.UserServiceInterceptorRegistry;
import com.openexchange.user.internal.UserServiceImpl;
import com.openexchange.userconf.UserConfigurationService;
import com.openexchange.userconf.UserPermissionService;
import com.openexchange.userconf.internal.UserConfigurationServiceImpl;
import com.openexchange.userconf.internal.UserPermissionServiceImpl;
import com.openexchange.version.Version;
import com.openexchange.version.internal.Numbers;
import com.openexchange.xml.jdom.JDOMParser;
import com.openexchange.xml.jdom.impl.JDOMParserImpl;
import com.openexchange.xml.spring.SpringParser;
import com.openexchange.xml.spring.impl.DefaultSpringParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import net.freeutils.charset.CharsetProvider;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Init {
    private static final Logger LOG = LoggerFactory.getLogger(Init.class);
    private static final List<Initialization> started = new ArrayList<Initialization>();
    private static final AtomicBoolean running = new AtomicBoolean();
    private static final Map<Class<?>, Object> services = new HashMap();
    public static final ServiceLookup LOOKUP = new ServiceLookup(){

        public <S> S getService(Class<? extends S> clazz) {
            return (S)services.get(clazz);
        }

        public <S> S getOptionalService(Class<? extends S> clazz) {
            return (S)services.get(clazz);
        }
    };
    private static final Initialization[] inits = new Initialization[]{SystemConfig.getInstance(), CalendarConfig.getInstance(), new CustomCharsetProviderInit(), ContextInit.getInstance(), new FolderInitialization(), OXFolderProperties.getInstance(), MailInitialization.getInstance(), InfostoreConfig.getInstance(), AttachmentConfig.getInstance(), UserConfigurationStorageInit.getInstance(), ResourceStorageInit.getInstance(), NotificationConfig.getInstance(), ConfigTreeInit.getInstance(), new EventInit(), TransportPropertiesInit.getInstance(), SessiondInit.getInstance(), new GroupInit()};
    private static boolean databaseUpdateinitialized = false;

    public static void injectProperty() {
        String propDir1 = TestInit.getTestProperty("openexchange.propdir");
        if (null != propDir1) {
            System.setProperty("openexchange.propdir", propDir1);
        }
    }

    public static void startServer() throws Exception {
        long start = System.currentTimeMillis();
        if (!running.compareAndSet(false, true)) {
            return;
        }
        Init.injectProperty();
        long startTestServices = System.currentTimeMillis();
        Init.injectTestServices();
        System.out.println("Injecting the test services took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        for (Initialization init : inits) {
            long startInit = System.currentTimeMillis();
            init.start();
            System.out.println("Starting init for " + init.toString() + " took " + (System.currentTimeMillis() - startInit) + "ms.");
            started.add(init);
        }
        ServiceCallWrapperModifier.initTestRun(services);
        System.out.println("Initializing the test setup took " + (System.currentTimeMillis() - start) + "ms.");
    }

    private static void injectTestServices() throws Exception {
        long startTestServices = System.currentTimeMillis();
        Init.startVersionBundle();
        System.out.println("startVersionBundle took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectIDGeneratorService();
        System.out.println("startAndInjectIDGeneratorService took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectConfigBundle();
        System.out.println("startAndInjectConfigBundle took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectConfigViewFactory();
        System.out.println("startAndInjectConfigViewFactory took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectThreadPoolBundle();
        System.out.println("startAndInjectThreadPoolBundle took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectBasicServices();
        System.out.println("startAndInjectBasicServices took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectHTMLService();
        System.out.println("startAndInjectHTMLService took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectServerConfiguration();
        System.out.println("startAndInjectServerConfiguration took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectNotification();
        System.out.println("startAndInjectNotification took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectCache();
        System.out.println("startAndInjectCache took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectCalendarServices();
        System.out.println("startAndInjectCalendarServices took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectDatabaseBundle();
        System.out.println("startAndInjectDatabaseBundle took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectDatabaseUpdate();
        System.out.println("startAndInjectDatabaseUpdate took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        System.out.println("startAndInjectI18NBundle took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectMonitoringBundle();
        System.out.println("startAndInjectMonitoringBundle took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectEventBundle();
        System.out.println("startAndInjectEventBundle took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectSessiondBundle();
        System.out.println("startAndInjectSessiondBundle took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectContextService();
        System.out.println("startAndInjectContextService took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectFileStorage();
        System.out.println("startAndInjectFileStorage took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectGroupService();
        System.out.println("startAndInjectGroupService took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectFolderService();
        System.out.println("startAndInjectFolderService took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectResourceService();
        System.out.println("startAndInjectResourceService took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectMailAccountStorageService();
        System.out.println("startAndInjectMailAccountStorageService took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectMailAutoconfigService();
        System.out.println("startAndInjectMailAutoconfigService took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectMailBundle();
        System.out.println("startAndInjectMailBundle took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectSpamHandler();
        System.out.println("startAndInjectSpamHandler took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectICalServices();
        System.out.println("startAndInjectICalServices took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectConverterService();
        System.out.println("startAndInjectConverterService took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectXMLServices();
        System.out.println("startAndInjectXMLServices took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectSubscribeServices();
        System.out.println("startAndInjectSubscribeServices took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectContactStorageServices();
        System.out.println("startAndInjectContactStorageServices took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectContactServices();
        System.out.println("startAndInjectContactServices took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectContactCollector();
        System.out.println("startAndInjectContactCollector took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectImportExportServices();
        System.out.println("startAndInjectImportExportServices took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectCapabilitiesServices();
        System.out.println("startAndInjectCapabilitiesServices took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectClusterTimerService();
        System.out.println("startAndInjectClusterTimerService took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectDefaultShareService();
        System.out.println("startAndInjectDefaultShareService took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectPhoneNumberParserService();
        System.out.println("startAndInjectPhoneNumberParserService took " + (System.currentTimeMillis() - startTestServices) + "ms.");
        startTestServices = System.currentTimeMillis();
        Init.startAndInjectAliasService();
        System.out.println("startAndInjectAliasService took " + (System.currentTimeMillis() - startTestServices) + "ms.");
    }

    private static void startAndInjectCapabilitiesServices() {
        AbstractCapabilityService c = new AbstractCapabilityService(new ServiceLookup(){

            public <S> S getService(Class<? extends S> clazz) {
                return TestServiceRegistry.getInstance().getService(clazz);
            }

            public <S> S getOptionalService(Class<? extends S> clazz) {
                return null;
            }
        }, null){

            protected Map<String, List<CapabilityChecker>> getCheckers() {
                return Collections.emptyMap();
            }
        };
        services.put(CapabilityService.class, c);
        TestServiceRegistry.getInstance().addService(CapabilityService.class, c);
    }

    private static void startAndInjectConfigViewFactory() {
        ConfigCascade cascade = new ConfigCascade();
        cascade.setProvider("server", (ConfigProviderService)new InMemoryConfigProvider());
        cascade.setProvider("context", (ConfigProviderService)new InMemoryConfigProvider());
        cascade.setProvider("user", (ConfigProviderService)new InMemoryConfigProvider());
        cascade.setSearchPath(new String[]{"user", "context", "server"});
        cascade.setStringParser((StringParser)new BasicTypesStringParser());
        services.put(ConfigViewFactory.class, cascade);
        TestServiceRegistry.getInstance().addService(ConfigViewFactory.class, cascade);
    }

    private static void startVersionBundle() throws Exception {
        Version.getInstance().setNumbers(new Numbers("0.0.0", "0"));
    }

    public static void startAndInjectConfigBundle() {
        ConfigurationImpl config = new ConfigurationImpl(Collections.emptyList());
        services.put(ConfigurationService.class, config);
        TestServiceRegistry.getInstance().addService(ConfigurationService.class, config);
        com.openexchange.http.grizzly.osgi.Services.setServiceLookup((ServiceLookup)LOOKUP);
    }

    private static void startAndInjectThreadPoolBundle() {
        if (null == TestServiceRegistry.getInstance().getService(ThreadPoolService.class)) {
            ConfigurationService config = (ConfigurationService)services.get(ConfigurationService.class);
            ThreadPoolProperties props = new ThreadPoolProperties().init(config);
            ThreadPoolServiceImpl threadPool = ThreadPoolServiceImpl.newInstance((int)props.getCorePoolSize(), (int)props.getMaximumPoolSize(), (long)props.getKeepAliveTime(), (String)props.getWorkQueue(), (int)props.getWorkQueueSize(), (boolean)props.isBlocking(), (String)props.getRefusedExecutionBehavior());
            services.put(ThreadPoolService.class, threadPool);
            TestServiceRegistry.getInstance().addService(ThreadPoolService.class, threadPool);
            ThreadPoolActivator.REF_THREAD_POOL.set(threadPool);
            DelegateExecutorService delegateExecutorService = new DelegateExecutorService((ExecutorService)threadPool.getThreadPoolExecutor());
            services.put(ExecutorService.class, delegateExecutorService);
            TestServiceRegistry.getInstance().addService(ExecutorService.class, delegateExecutorService);
            CustomThreadPoolExecutorTimerService timer = new CustomThreadPoolExecutorTimerService(threadPool.getThreadPoolExecutor());
            services.put(TimerService.class, timer);
            TestServiceRegistry.getInstance().addService(TimerService.class, timer);
        }
    }

    private static void startAndInjectBasicServices() throws OXException {
        if (null == TestServiceRegistry.getInstance().getService(UserService.class)) {
            UserServiceImpl us = new UserServiceImpl(new UserServiceInterceptorRegistry(null){

                public synchronized List<UserServiceInterceptor> getInterceptors() {
                    return Collections.emptyList();
                }
            }, (PasswordMechFactory)new PasswordMechFactoryImpl());
            services.put(UserService.class, us);
            TestServiceRegistry.getInstance().addService(UserService.class, us);
        }
        if (null == TestServiceRegistry.getInstance().getService(UserConfigurationService.class)) {
            try {
                new CustomCharsetProviderInit().start();
                java.nio.charset.spi.CharsetProvider[] results = ModifyCharsetExtendedProvider.modifyCharsetExtendedProvider();
                CollectionCharsetProvider collectionCharsetProvider = (CollectionCharsetProvider)results[1];
                collectionCharsetProvider.addCharsetProvider((java.nio.charset.spi.CharsetProvider)new CharsetProvider());
                collectionCharsetProvider.addCharsetProvider((java.nio.charset.spi.CharsetProvider)new CustomCharsetProvider());
            }
            catch (NoSuchFieldException e) {
                throw Init.getWrappingOXException(e);
            }
            catch (IllegalAccessException e) {
                throw Init.getWrappingOXException(e);
            }
            services.put(UserConfigurationService.class, new UserConfigurationServiceImpl());
            services.put(UserPermissionService.class, new UserPermissionServiceImpl());
            TestServiceRegistry.getInstance().addService(UserConfigurationService.class, services.get(UserConfigurationService.class));
            TestServiceRegistry.getInstance().addService(UserPermissionService.class, services.get(UserPermissionService.class));
        }
    }

    private static void startAndInjectHTMLService() {
        if (null == TestServiceRegistry.getInstance().getService(HtmlService.class)) {
            ConfigurationService configService = (ConfigurationService)services.get(ConfigurationService.class);
            ServiceRegistry.getInstance().addService(ConfigurationService.class, (Object)configService);
            Object[] maps = HTMLServiceActivator.getHTMLEntityMaps((File)configService.getFileByName("HTMLEntities.properties"));
            Map htmlEntityMap = (Map)maps[1];
            htmlEntityMap.put("apos", Character.valueOf('\''));
            Map htmlCharMap = (Map)maps[0];
            htmlCharMap.put(Character.valueOf('\''), "apos");
            HtmlServiceImpl service = new HtmlServiceImpl(htmlCharMap, htmlEntityMap);
            services.put(HtmlService.class, service);
            TestServiceRegistry.getInstance().addService(HtmlService.class, service);
        }
    }

    private static final OXException getWrappingOXException(Exception cause) {
        String message = cause.getMessage();
        new Component(){
            private static final long serialVersionUID = 2411378382745647554L;

            public String getAbbreviation() {
                return "TEST";
            }
        };
        return new OXException(9999, null == message ? "[Not available]" : message, (Throwable)cause, new Object[0]);
    }

    private static void startAndInjectCalendarServices() {
        if (null == TestServiceRegistry.getInstance().getService(CalendarCollectionService.class)) {
            TestServiceRegistry.getInstance().addService(CalendarCollectionService.class, new CalendarCollection());
            TestServiceRegistry.getInstance().addService(AppointmentSqlFactoryService.class, new AppointmentSqlFactory());
            TargetRegistry.getInstance().addService(1, (TargetService)new CalendarReminderDelete());
            TestServiceRegistry.getInstance().addService(CalendarAdministrationService.class, new CalendarAdministration());
            if (null == CalendarVolatileCache.getInstance()) {
                try {
                    String regionName = "CalendarVolatileCache";
                    int maxObjects = 10000000;
                    int maxLifeSeconds = 300;
                    int idleTimeSeconds = 180;
                    int shrinkerIntervalSeconds = 60;
                    byte[] ccf = "jcs.region.CalendarVolatileCache=LTCP\njcs.region.CalendarVolatileCache.cacheattributes=org.apache.jcs.engine.CompositeCacheAttributes\njcs.region.CalendarVolatileCache.cacheattributes.MaxObjects=10000000\njcs.region.CalendarVolatileCache.cacheattributes.MemoryCacheName=org.apache.jcs.engine.memory.lru.LRUMemoryCache\njcs.region.CalendarVolatileCache.cacheattributes.UseMemoryShrinker=true\njcs.region.CalendarVolatileCache.cacheattributes.MaxMemoryIdleTimeSeconds=180\njcs.region.CalendarVolatileCache.cacheattributes.ShrinkerIntervalSeconds=60\njcs.region.CalendarVolatileCache.elementattributes=org.apache.jcs.engine.ElementAttributes\njcs.region.CalendarVolatileCache.elementattributes.IsEternal=false\njcs.region.CalendarVolatileCache.elementattributes.MaxLifeSeconds=300\njcs.region.CalendarVolatileCache.elementattributes.IdleTime=180\njcs.region.CalendarVolatileCache.elementattributes.IsSpool=false\njcs.region.CalendarVolatileCache.elementattributes.IsRemote=false\njcs.region.CalendarVolatileCache.elementattributes.IsLateral=false\n".getBytes();
                    CacheService cacheService = TestServiceRegistry.getInstance().getService(CacheService.class);
                    cacheService.loadConfiguration((InputStream)new ByteArrayInputStream(ccf));
                    CalendarVolatileCache.initInstance((Cache)cacheService.getCache("CalendarVolatileCache"));
                }
                catch (OXException e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
        }
    }

    private static void startAndInjectXMLServices() {
        if (null == TestServiceRegistry.getInstance().getService(SpringParser.class)) {
            DefaultSpringParser springParser = new DefaultSpringParser();
            TestServiceRegistry.getInstance().addService(SpringParser.class, springParser);
        }
        if (null == TestServiceRegistry.getInstance().getService(JDOMParser.class)) {
            JDOMParserImpl jdomParser = new JDOMParserImpl();
            TestServiceRegistry.getInstance().addService(JDOMParser.class, jdomParser);
        }
    }

    private static void startAndInjectImportExportServices() throws OXException {
        if (null == ImportExportServices.LOOKUP.get()) {
            ImportExportServices.LOOKUP.set(new ServiceLookup(){

                public <S> S getService(Class<? extends S> clazz) {
                    return TestServiceRegistry.getInstance().getService(clazz);
                }

                public <S> S getOptionalService(Class<? extends S> clazz) {
                    return null;
                }
            });
            SubscriptionServiceRegistry.getInstance().addService(ContactService.class, services.get(ContactService.class));
        }
    }

    private static void startAndInjectIDGeneratorService() {
        IDGeneratorServiceImpl idService = new IDGeneratorServiceImpl();
        TestServiceRegistry.getInstance().addService(IDGeneratorService.class, idService);
    }

    private static void startAndInjectSubscribeServices() {
        ArrayList<StrategyFolderUpdaterService> folderUpdaters = new ArrayList<StrategyFolderUpdaterService>(2);
        folderUpdaters.add(new StrategyFolderUpdaterService((FolderUpdaterStrategy)new ContactFolderUpdaterStrategy()));
        folderUpdaters.add(new StrategyFolderUpdaterService((FolderUpdaterStrategy)new ContactFolderMultipleUpdaterStrategy(), true));
        ContextService contextService = (ContextService)services.get(ContextService.class);
        SubscriptionExecutionServiceImpl registry = new SubscriptionExecutionServiceImpl((SubscriptionSourceDiscoveryService)new SimSubscriptionSourceDiscoveryService(), folderUpdaters, contextService);
        TestServiceRegistry.getInstance().addService(FolderUpdaterRegistry.class, registry);
    }

    private static void startAndInjectContactStorageServices() {
        if (null == TestServiceRegistry.getInstance().getService(ContactStorageRegistry.class)) {
            DefaultContactStorageRegistry registry = new DefaultContactStorageRegistry();
            registry.addStorage((ContactStorage)new RdbContactStorage());
            TestServiceRegistry.getInstance().addService(ContactStorageRegistry.class, registry);
            RdbServiceLookup.set((ServiceLookup)new ServiceLookup(){

                public <S> S getService(Class<? extends S> clazz) {
                    return TestServiceRegistry.getInstance().getService(clazz);
                }

                public <S> S getOptionalService(Class<? extends S> clazz) {
                    return null;
                }
            });
        }
    }

    private static void startAndInjectContactServices() {
        if (null == TestServiceRegistry.getInstance().getService(ContactService.class)) {
            ContactServiceImpl contactService = new ContactServiceImpl(new UserServiceInterceptorRegistry(null));
            ContactServiceLookup.set((ServiceLookup)new ServiceLookup(){

                public <S> S getService(Class<? extends S> clazz) {
                    return TestServiceRegistry.getInstance().getService(clazz);
                }

                public <S> S getOptionalService(Class<? extends S> clazz) {
                    return null;
                }
            });
            TestServiceRegistry.getInstance().addService(ContactService.class, contactService);
            services.put(ContactService.class, contactService);
        }
    }

    public static void startAndInjectI18NBundle() throws FileNotFoundException {
        ConfigurationService config = (ConfigurationService)services.get(ConfigurationService.class);
        String directory_name = config.getProperty("i18n.language.path");
        if (directory_name == null) {
            LOG.error("Tried to load i18n files and did not find a property");
            return;
        }
        File dir = new File(directory_name);
        I18nServices i18nServices = I18nServices.getInstance();
        try {
            for (ResourceBundle rc : new ResourceBundleDiscoverer(dir).getResourceBundles()) {
                i18nServices.addService((I18nService)new I18nImpl(rc));
            }
            for (Translations tr : new POTranslationsDiscoverer(dir).getTranslations()) {
                i18nServices.addService((I18nService)new TranslationsI18N(tr));
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public static void startAndInjectServerConfiguration() {
        ConfigurationService config = (ConfigurationService)services.get(ConfigurationService.class);
        ServerConfig.getInstance().initialize(config);
    }

    public static void startAndInjectNotification() {
        ConfigurationService config = (ConfigurationService)services.get(ConfigurationService.class);
        ParticipantConfig.getInstance().initialize(config);
    }

    public static void startAndInjectDatabaseBundle() throws OXException, OXException {
        if (null == services.get(DatabaseService.class)) {
            ConfigurationService configurationService = (ConfigurationService)services.get(ConfigurationService.class);
            TimerService timerService = (TimerService)services.get(TimerService.class);
            CacheService cacheService = (CacheService)services.get(CacheService.class);
            ConfigViewFactory configViewFactory = (ConfigViewFactory)services.get(ConfigViewFactory.class);
            com.openexchange.database.internal.Initialization.getInstance().getTimer().setTimerService(timerService);
            DatabaseService dbService = com.openexchange.database.internal.Initialization.getInstance().start(configurationService, configViewFactory, null);
            services.put(DatabaseService.class, dbService);
            com.openexchange.database.internal.Initialization.getInstance().setCacheService(cacheService);
            Database.setDatabaseService((DatabaseService)dbService);
            TestServiceRegistry.getInstance().addService(DatabaseService.class, dbService);
        }
    }

    public static void startAndInjectFileStorage() {
        CompositeFileStorageService fileStorageStarter = new CompositeFileStorageService(null);
        FileStorage.setFileStorageStarter((FileStorageService)fileStorageStarter);
        DatabaseService dbService = (DatabaseService)services.get(DatabaseService.class);
        FileStorages.setFileStorageService((FileStorageService)fileStorageStarter);
        SimpleServiceLookup serviceLookup = new SimpleServiceLookup();
        serviceLookup.add(DatabaseService.class, (Object)dbService);
        ContextService contextService = (ContextService)services.get(ContextService.class);
        serviceLookup.add(ContextService.class, (Object)contextService);
        UserService userService = (UserService)services.get(UserService.class);
        serviceLookup.add(UserService.class, (Object)userService);
        Services.setServiceLookup((ServiceLookup)serviceLookup);
        DBQuotaFileStorageService qfss = new DBQuotaFileStorageService((FileStorageService)fileStorageStarter);
        QuotaFileStorage.setQuotaFileStorageStarter((QuotaFileStorageService)qfss);
        InfostoreFacadeImpl.setQuotaFileStorageService((QuotaFileStorageService)qfss);
        services.put(QuotaFileStorageService.class, qfss);
        TestServiceRegistry.getInstance().addService(QuotaFileStorageService.class, qfss);
        FileStorages.setQuotaFileStorageService((QuotaFileStorageService)qfss);
    }

    public static void startAndInjectDatabaseUpdate() throws OXException {
        if (databaseUpdateinitialized) {
            return;
        }
        InternalList.getInstance().start();
        databaseUpdateinitialized = true;
    }

    private static void startAndInjectMonitoringBundle() {
    }

    private static void startAndInjectMailBundle() throws Exception {
        MailProperties.getInstance().loadProperties();
        if (null == MailProviderRegistry.getMailProvider((String)"imap_imaps")) {
            com.openexchange.imap.services.Services.setServiceLookup((ServiceLookup)LOOKUP);
            IMAPStoreCache.initInstance();
            MailProviderRegistry.registerMailProvider((String)"imap_imaps", (MailProvider)IMAPProvider.getInstance());
        }
    }

    private static void startAndInjectContactCollector() {
    }

    private static void startAndInjectMailAccountStorageService() throws Exception {
        if (null == TestServiceRegistry.getInstance().getService(MailAccountStorageService.class)) {
            new MailAccountStorageInit().start();
            MailAccountStorageService storageService = MailAccountStorageInit.newMailAccountStorageService();
            services.put(MailAccountStorageService.class, storageService);
            TestServiceRegistry.getInstance().addService(MailAccountStorageService.class, storageService);
            SimpleServiceLookup services = new SimpleServiceLookup();
            services.add(MailAccountStorageService.class, (Object)storageService);
            com.openexchange.folderstorage.mail.osgi.Services.setServiceLookup((ServiceLookup)services);
            UnifiedInboxManagement unifiedINBOXManagement = MailAccountStorageInit.newUnifiedINBOXManagement();
            Init.services.put(UnifiedInboxManagement.class, unifiedINBOXManagement);
            TestServiceRegistry.getInstance().addService(UnifiedInboxManagement.class, unifiedINBOXManagement);
        }
    }

    private static void startAndInjectMailAutoconfigService() throws Exception {
        if (null == TestServiceRegistry.getInstance().getService(AutoconfigService.class)) {
            AutoconfigServiceImpl service = new AutoconfigServiceImpl(LOOKUP);
            services.put(AutoconfigService.class, service);
            TestServiceRegistry.getInstance().addService(AutoconfigService.class, service);
        }
    }

    private static void startAndInjectSpamHandler() {
        if (null == SpamHandlerRegistry.getSpamHandler((String)DefaultSpamHandler.getInstance().getSpamHandlerName())) {
            SpamHandlerRegistry.registerSpamHandler((String)DefaultSpamHandler.getInstance().getSpamHandlerName(), (SpamHandler)DefaultSpamHandler.getInstance());
        }
        if (null == SpamHandlerRegistry.getSpamHandler((String)SpamAssassinSpamHandler.getInstance().getSpamHandlerName())) {
            SpamHandlerRegistry.registerSpamHandler((String)SpamAssassinSpamHandler.getInstance().getSpamHandlerName(), (SpamHandler)SpamAssassinSpamHandler.getInstance());
        }
    }

    private static void startAndInjectResourceService() {
        if (null == TestServiceRegistry.getInstance().getService(ResourceService.class)) {
            ResourceServiceImpl resources = ResourceServiceImpl.getInstance();
            services.put(ResourceService.class, resources);
            TestServiceRegistry.getInstance().addService(ResourceService.class, resources);
        }
    }

    private static void startAndInjectGroupService() {
        if (null == TestServiceRegistry.getInstance().getService(GroupService.class)) {
            GroupServiceImpl us = new GroupServiceImpl();
            services.put(GroupService.class, us);
            TestServiceRegistry.getInstance().addService(GroupService.class, us);
        }
    }

    private static void startAndInjectFolderService() {
        if (null == TestServiceRegistry.getInstance().getService(FolderService.class)) {
            FolderServiceImpl fs = new FolderServiceImpl();
            services.put(FolderService.class, fs);
            TestServiceRegistry.getInstance().addService(FolderService.class, fs);
        }
    }

    private static void startAndInjectContextService() {
        if (null == TestServiceRegistry.getInstance().getService(ContextService.class)) {
            ContextServiceImpl cs = new ContextServiceImpl();
            services.put(ContextService.class, cs);
            TestServiceRegistry.getInstance().addService(ContextService.class, cs);
        }
    }

    private static void startAndInjectSessiondBundle() {
        if (null == TestServiceRegistry.getInstance().getService(SessiondService.class)) {
            SimpleServiceLookup serviceLookup = new SimpleServiceLookup();
            serviceLookup.add(ConfigurationService.class, services.get(ConfigurationService.class));
            serviceLookup.add(TimerService.class, services.get(TimerService.class));
            serviceLookup.add(EventAdmin.class, (Object)TestServiceRegistry.getInstance().getService(EventAdmin.class));
            TestSessionStorageService sessionStorageService = TestSessionStorageService.getInstance();
            serviceLookup.add(SessionStorageService.class, (Object)sessionStorageService);
            com.openexchange.sessiond.osgi.Services.setServiceLookup((ServiceLookup)serviceLookup);
            TestServiceRegistry.getInstance().addService(SessionStorageService.class, sessionStorageService);
            SessiondServiceImpl serviceImpl = new SessiondServiceImpl();
            SessiondService.SERVICE_REFERENCE.set(serviceImpl);
            TestServiceRegistry.getInstance().addService(SessiondService.class, serviceImpl);
        }
    }

    private static void startAndInjectEventBundle() throws Exception {
        if (null == TestServiceRegistry.getInstance().getService(EventAdmin.class)) {
            EventQueue.setNewEventDispatcher((EventDispatcher)new EventDispatcher(){

                public void addListener(AppointmentEventInterface listener) {
                }

                public void addListener(TaskEventInterface listener) {
                }
            });
            TestServiceRegistry.getInstance().addService(EventAdmin.class, TestEventAdmin.getInstance());
            PushServiceRegistry.getServiceRegistry().addService(EventAdmin.class, (Object)TestEventAdmin.getInstance());
        }
    }

    public static void startAndInjectCache() throws OXException {
        if (null == TestServiceRegistry.getInstance().getService(CacheService.class)) {
            CacheEventConfiguration config = new CacheEventConfiguration(){

                public boolean remoteInvalidationForPersonalFolders() {
                    return false;
                }
            };
            CacheEventServiceImpl cacheEventService = new CacheEventServiceImpl(config);
            services.put(CacheEventService.class, cacheEventService);
            TestServiceRegistry.getInstance().addService(CacheEventService.class, cacheEventService);
            JCSCacheServiceInit.initInstance();
            JCSCacheServiceInit.getInstance().setCacheEventService((CacheEventService)services.get(CacheEventService.class));
            JCSCacheServiceInit.getInstance().start((ConfigurationService)services.get(ConfigurationService.class));
            JCSCacheService cache = JCSCacheService.getInstance();
            services.put(CacheService.class, cache);
            TestServiceRegistry.getInstance().addService(CacheService.class, cache);
        }
    }

    public static void startAndInjectICalServices() {
        if (null == TestServiceRegistry.getInstance().getService(ICalParser.class)) {
            ICal4JParser parser = new ICal4JParser();
            ICal4JEmitter emitter = new ICal4JEmitter();
            OXUserResolver userResolver = new OXUserResolver();
            userResolver.setUserService((UserService)services.get(UserService.class));
            Participants.userResolver = userResolver;
            CreatedBy.userResolver = userResolver;
            OXResourceResolver resourceResolver = new OXResourceResolver();
            resourceResolver.setResourceService((ResourceService)services.get(ResourceService.class));
            Participants.resourceResolver = resourceResolver;
            services.put(ICalParser.class, parser);
            services.put(ICalEmitter.class, emitter);
            TestServiceRegistry.getInstance().addService(ICalParser.class, parser);
            TestServiceRegistry.getInstance().addService(ICalEmitter.class, emitter);
        }
    }

    public static void startAndInjectConverterService() {
        if (null == TestServiceRegistry.getInstance().getService(ConversionService.class)) {
            ConversionEngineRegistry.getInstance().putDataHandler("com.openexchange.contact", (DataHandler)new ContactInsertDataHandler((ServiceLookup)TestServiceRegistry.getInstance()));
            ConversionEngineRegistry.getInstance().putDataSource("com.openexchange.mail.vcard", (DataSource)new VCardMailPartDataSource());
            ConversionServiceImpl conversionService = new ConversionServiceImpl();
            services.put(ConversionService.class, conversionService);
            TestServiceRegistry.getInstance().addService(ConversionService.class, conversionService);
        }
    }

    public static void startAndInjectClusterTimerService() throws OXException {
        if (null == TestServiceRegistry.getInstance().getService(ClusterTimerService.class)) {
            ClusterTimerServiceImpl clusterTimerService = new ClusterTimerServiceImpl(LOOKUP, null);
            services.put(ClusterTimerService.class, clusterTimerService);
            TestServiceRegistry.getInstance().addService(ClusterTimerService.class, clusterTimerService);
        }
    }

    public static void startAndInjectAliasService() {
        if (null == TestServiceRegistry.getInstance().getService(UserAliasStorage.class)) {
            TestServiceRegistry.getInstance().addService(UserAliasStorage.class, new RdbAliasStorage());
        }
    }

    public static void startAndInjectDefaultShareService() throws OXException {
        if (null == TestServiceRegistry.getInstance().getService(ShareService.class)) {
            DefaultShareService service = new DefaultShareService(LOOKUP, new GuestCleaner(LOOKUP));
            services.put(ShareService.class, service);
            TestServiceRegistry.getInstance().addService(ShareService.class, service);
        }
    }

    public static void startAndInjectPhoneNumberParserService() throws OXException {
        if (null == TestServiceRegistry.getInstance().getService(PhoneNumberParserService.class)) {
            PhoneNumberParserServiceImpl service = new PhoneNumberParserServiceImpl();
            services.put(PhoneNumberParserService.class, service);
            TestServiceRegistry.getInstance().addService(PhoneNumberParserService.class, service);
        }
    }

    public static void stopServer() throws Exception {
        if (!running.compareAndSet(true, false)) {
            return;
        }
        Init.dropI18NBundle();
        Init.dropConfigBundle();
        Init.dropProperty();
    }

    public static void dropProperty() {
        Properties sysProps = System.getProperties();
        sysProps.remove("openexchange.propdir");
    }

    public static void dropConfigBundle() {
        services.remove(ConfigurationService.class);
        TestServiceRegistry.getInstance().removeService(ConfigurationService.class);
        FileWatcher.dropTimer();
    }

    public static void dropI18NBundle() {
        I18nServices i18nServices = I18nServices.getInstance();
        i18nServices.clear();
    }

    public static void stopMailBundle() {
        com.openexchange.imap.services.Services.setServiceLookup(null);
        IMAPStoreCache.shutDownInstance();
    }

    public static void stopDatabaseBundle() {
        Database.setDatabaseService(null);
        com.openexchange.database.internal.Initialization.getInstance().stop();
        databaseUpdateinitialized = false;
    }

    public static void stopThreadPoolBundle() throws Exception {
        services.remove(TimerService.class);
        ThreadPoolServiceImpl threadPool = (ThreadPoolServiceImpl)services.remove(ThreadPoolService.class);
        threadPool.shutdownNow();
        threadPool.awaitTermination(10000L);
    }

    public static ConfigurationServiceHolder getConfigurationServiceHolder() throws Exception {
        ConfigurationServiceHolder csh = ConfigurationServiceHolder.newInstance();
        csh.setService((Object)((ConfigurationService)services.get(ConfigurationService.class)));
        return csh;
    }
}

