/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.tests;

import com.openexchange.dav.PropertyNames;
import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.UserAgents;
import java.util.List;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Node;

public class CollectionsTest
extends CardDAVTest {
    @Test
    public void testMacOSClients() throws Exception {
        for (String userAgent : UserAgents.MACOS_ALL) {
            super.getWebDAVClient().setUserAgent(userAgent);
            this.discoverRoot();
            this.discoverAggregatedCollection(true);
            this.discoverContactsCollection(false);
            this.discoverGABCollection(false);
        }
    }

    @Test
    public void testIOSClients() throws Exception {
        for (String userAgent : UserAgents.IOS_ALL) {
            super.getWebDAVClient().setUserAgent(userAgent);
            this.discoverRoot();
            this.discoverAggregatedCollection(false);
            this.discoverContactsCollection(true);
            this.discoverGABCollection(true);
        }
    }

    @Test
    public void testOtherClients() throws Exception {
        for (String userAgent : UserAgents.OTHER_ALL) {
            super.getWebDAVClient().setUserAgent(userAgent);
            this.discoverRoot();
            this.discoverAggregatedCollection(false);
            this.discoverContactsCollection(true);
            this.discoverGABCollection(true);
        }
    }

    private void discoverRoot() throws Exception {
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.CURRENT_USER_PRINCIPAL);
        props.add(PropertyNames.PRINCIPAL_URL);
        props.add(PropertyNames.RESOURCETYPE);
        PropFindMethod propFind = new PropFindMethod(super.getWebDAVClient().getBaseURI() + "/", 0, props, 0);
        MultiStatusResponse response = CollectionsTest.assertSingleResponse(super.getWebDAVClient().doPropFind(propFind));
        Node node = super.extractNodeValue(PropertyNames.RESOURCETYPE, response);
        CollectionsTest.assertMatches(PropertyNames.COLLECTION, node);
    }

    private void discoverAggregatedCollection(boolean shouldExists) throws Exception {
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.ADD_MEMBER);
        props.add(PropertyNames.CURRENT_USER_PRIVILEGE_SET);
        props.add(PropertyNames.DISPLAYNAME);
        props.add(PropertyNames.MAX_IMAGE_SIZE);
        props.add(PropertyNames.MAX_RESOURCE_SIZE);
        props.add(PropertyNames.ME_CARD);
        props.add(PropertyNames.OWNER);
        props.add(PropertyNames.PUSH_TRANSPORTS);
        props.add(PropertyNames.PUSHKEY);
        props.add(PropertyNames.QUOTA_AVAILABLE_BYTES);
        props.add(PropertyNames.QUOTA_USED_BYTES);
        props.add(PropertyNames.RESOURCE_ID);
        props.add(PropertyNames.RESOURCETYPE);
        props.add(PropertyNames.SUPPORTED_REPORT_SET);
        props.add(PropertyNames.SYNC_TOKEN);
        PropFindMethod propFind = new PropFindMethod(super.getWebDAVClient().getBaseURI() + "/carddav/", 0, props, 1);
        MultiStatusResponse aggregatedCollectionResponse = null;
        for (MultiStatusResponse response : super.getWebDAVClient().doPropFind(propFind)) {
            if (!response.getHref().equals("/carddav/Contacts/")) continue;
            aggregatedCollectionResponse = response;
            break;
        }
        if (shouldExists) {
            Assert.assertNotNull((String)"Aggregated collection not found at /carddav/Contacts", aggregatedCollectionResponse);
            List<Node> nodeList = super.extractNodeListValue(PropertyNames.RESOURCETYPE, aggregatedCollectionResponse);
            CollectionsTest.assertContains(PropertyNames.COLLECTION, nodeList);
            CollectionsTest.assertContains(PropertyNames.ADDRESSBOOK, nodeList);
        } else {
            Assert.assertNull((String)"Aggregated collection found at /carddav/Contacts", aggregatedCollectionResponse);
        }
    }

    private void discoverContactsCollection(boolean shouldExist) throws Exception {
        String folderName = super.getDefaultFolder().getFolderName();
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.ADD_MEMBER);
        props.add(PropertyNames.CURRENT_USER_PRIVILEGE_SET);
        props.add(PropertyNames.DISPLAYNAME);
        props.add(PropertyNames.MAX_IMAGE_SIZE);
        props.add(PropertyNames.MAX_RESOURCE_SIZE);
        props.add(PropertyNames.ME_CARD);
        props.add(PropertyNames.OWNER);
        props.add(PropertyNames.PUSH_TRANSPORTS);
        props.add(PropertyNames.PUSHKEY);
        props.add(PropertyNames.QUOTA_AVAILABLE_BYTES);
        props.add(PropertyNames.QUOTA_USED_BYTES);
        props.add(PropertyNames.RESOURCE_ID);
        props.add(PropertyNames.RESOURCETYPE);
        props.add(PropertyNames.SUPPORTED_REPORT_SET);
        props.add(PropertyNames.SYNC_TOKEN);
        PropFindMethod propFind = new PropFindMethod(super.getWebDAVClient().getBaseURI() + "/carddav/", 0, props, 1);
        boolean found = false;
        for (MultiStatusResponse response : super.getWebDAVClient().doPropFind(propFind)) {
            String displayName = super.extractTextContent(DavPropertyName.DISPLAYNAME, response);
            if (null != displayName && 0 < displayName.length() && "\u200a".equals(displayName.substring(0, 1))) {
                displayName = displayName.substring(1);
            }
            if (!folderName.equals(displayName)) continue;
            found = true;
            break;
        }
        if (shouldExist) {
            Assert.assertTrue((String)"Default contact folder collection not found below /carddav/", (boolean)found);
        } else {
            Assert.assertFalse((String)"Default contact folder collection found below /carddav/", (boolean)found);
        }
    }

    private void discoverGABCollection(boolean shouldExist) throws Exception {
        String folderName = super.getGABFolder().getFolderName();
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.ADD_MEMBER);
        props.add(PropertyNames.CURRENT_USER_PRIVILEGE_SET);
        props.add(PropertyNames.DISPLAYNAME);
        props.add(PropertyNames.MAX_IMAGE_SIZE);
        props.add(PropertyNames.MAX_RESOURCE_SIZE);
        props.add(PropertyNames.ME_CARD);
        props.add(PropertyNames.OWNER);
        props.add(PropertyNames.PUSH_TRANSPORTS);
        props.add(PropertyNames.PUSHKEY);
        props.add(PropertyNames.QUOTA_AVAILABLE_BYTES);
        props.add(PropertyNames.QUOTA_USED_BYTES);
        props.add(PropertyNames.RESOURCE_ID);
        props.add(PropertyNames.RESOURCETYPE);
        props.add(PropertyNames.SUPPORTED_REPORT_SET);
        props.add(PropertyNames.SYNC_TOKEN);
        PropFindMethod propFind = new PropFindMethod(super.getWebDAVClient().getBaseURI() + "/carddav/", 0, props, 1);
        boolean found = false;
        for (MultiStatusResponse response : super.getWebDAVClient().doPropFind(propFind)) {
            String displayName = super.extractTextContent(DavPropertyName.DISPLAYNAME, response);
            if (!folderName.equals(displayName)) continue;
            found = true;
            break;
        }
        if (shouldExist) {
            Assert.assertTrue((String)"GAB folder collection not found below /carddav/", (boolean)found);
        } else {
            Assert.assertFalse((String)"GAB folder collection found below /carddav/", (boolean)found);
        }
    }
}

