/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.VisibleFoldersRequest;
import com.openexchange.ajax.folder.actions.VisibleFoldersResponse;
import com.openexchange.dav.PropertyNames;
import com.openexchange.dav.SyncToken;
import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.dav.reports.SyncCollectionResponse;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.cardme.vcard.types.TelType;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.client.methods.PutMethod;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Node;

public class BasicTest
extends CardDAVTest {
    @Override
    protected String getDefaultUserAgent() {
        return "iOS/8.4 (12H143) dataaccessd/1.0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPutAndGet() throws Exception {
        VCardResource vCardResource;
        String collection = String.valueOf(this.getDefaultFolderID());
        String uid = BasicTest.randomUID();
        String firstName = "John";
        String lastName = "Doe";
        String email = firstName.toLowerCase() + '.' + lastName.toLowerCase() + "@example.org";
        String vCard = "BEGIN:VCARD\r\nPRODID:-//Example Inc.//Example Client 1.0//EN\r\nVERSION:3.0\r\nN:" + lastName + ";" + firstName + ";;;" + "\r\n" + "FN:" + firstName + " " + lastName + "\r\n" + "EMAIL;type=INTERNET;type=WORK;type=pref:" + email + "\r\n" + "UID:" + uid + "\r\n" + "REV:" + BasicTest.formatAsUTC(new Date()) + "\r\n" + "END:VCARD" + "\r\n";
        String href = "/carddav/" + collection + "/" + uid + ".vcf";
        PutMethod put = null;
        try {
            put = new PutMethod(BasicTest.getBaseUri() + href);
            put.addRequestHeader("If-None-Match", "*");
            put.setRequestEntity((RequestEntity)new StringRequestEntity(vCard, "text/vcard", "UTF-8"));
            Assert.assertEquals((String)"Response code wrong", (long)201L, (long)this.getWebDAVClient().executeMethod((HttpMethod)put));
        }
        catch (Throwable throwable) {
            BasicTest.release(put);
            throw throwable;
        }
        BasicTest.release((HttpMethodBase)put);
        GetMethod get = null;
        try {
            get = new GetMethod(BasicTest.getBaseUri() + href);
            String reloadedVCard = this.getWebDAVClient().doGet(get);
            Assert.assertNotNull((Object)reloadedVCard);
            Header eTagHeader = get.getResponseHeader("ETag");
            String eTag = null != eTagHeader ? eTagHeader.getValue() : null;
            vCardResource = new VCardResource(reloadedVCard, href, eTag);
        }
        catch (Throwable throwable) {
            BasicTest.release(get);
            throw throwable;
        }
        BasicTest.release((HttpMethodBase)get);
        Assert.assertNotNull((String)"No ETag", (Object)vCardResource.getETag());
        Assert.assertEquals((String)"N wrong", (Object)firstName, (Object)vCardResource.getGivenName());
        Assert.assertEquals((String)"N wrong", (Object)lastName, (Object)vCardResource.getFamilyName());
        Assert.assertEquals((String)"FN wrong", (Object)(firstName + " " + lastName), (Object)vCardResource.getFN());
        String updatedVCard = "BEGIN:VCARD\r\nPRODID:-//Example Inc.//Example Client 1.0//EN\r\nVERSION:3.0\r\nN:" + lastName + ";" + firstName + ";;;" + "\r\n" + "FN:" + firstName + " " + lastName + "\r\n" + "EMAIL;type=INTERNET;type=WORK;type=pref:" + email + "\r\n" + "UID:" + uid + "\r\n" + "REV:" + BasicTest.formatAsUTC(new Date()) + "\r\n" + "TEL;type=CELL:352-3534" + "\r\n" + "CATEGORIES:Family,Private" + "\r\n" + "END:VCARD" + "\r\n";
        try {
            put = new PutMethod(BasicTest.getBaseUri() + href);
            put.addRequestHeader("If-Match", vCardResource.getETag());
            put.setRequestEntity((RequestEntity)new StringRequestEntity(updatedVCard, "text/vcard", "UTF-8"));
            Assert.assertEquals((String)"Response code wrong", (long)201L, (long)this.getWebDAVClient().executeMethod((HttpMethod)put));
        }
        finally {
            BasicTest.release((HttpMethodBase)put);
        }
        try {
            get = new GetMethod(BasicTest.getBaseUri() + href);
            String reloadedVCard = this.getWebDAVClient().doGet(get);
            Assert.assertNotNull((Object)reloadedVCard);
            Header eTagHeader = get.getResponseHeader("ETag");
            String eTag = null != eTagHeader ? eTagHeader.getValue() : null;
            vCardResource = new VCardResource(reloadedVCard, href, eTag);
        }
        finally {
            BasicTest.release((HttpMethodBase)get);
        }
        Assert.assertNotNull((String)"No ETag", (Object)vCardResource.getETag());
        Assert.assertEquals((String)"N wrong", (Object)firstName, (Object)vCardResource.getGivenName());
        Assert.assertEquals((String)"N wrong", (Object)lastName, (Object)vCardResource.getFamilyName());
        Assert.assertEquals((String)"FN wrong", (Object)(firstName + " " + lastName), (Object)vCardResource.getFN());
        Assert.assertTrue((String)"No TELs found", (null != vCardResource.getVCard().getTels() && 1 == vCardResource.getVCard().getTels().size() ? 1 : 0) != 0);
        Assert.assertEquals((String)"TEL wrong", (Object)"352-3534", (Object)((TelType)vCardResource.getVCard().getTels().get(0)).getTelephone());
        Assert.assertTrue((String)"CATEGORIES wrong", (boolean)vCardResource.getVCard().getCategories().getCategories().contains("Family"));
        Assert.assertTrue((String)"CATEGORIES wrong", (boolean)vCardResource.getVCard().getCategories().getCategories().contains("Private"));
    }

    @Test
    public void testSyncCollection() throws Exception {
        String collection = String.valueOf(this.getDefaultFolderID());
        SyncToken syncToken = new SyncToken(this.fetchSyncToken(collection));
        String uid = BasicTest.randomUID();
        String firstName = "John";
        String lastName = "Doe";
        String email = firstName.toLowerCase() + '.' + lastName.toLowerCase() + "@example.org";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setUid(uid);
        contact.setEmail1(email);
        this.rememberForCleanUp(this.create(contact));
        SyncCollectionResponse syncCollectionResponse = this.syncCollection(syncToken, "/carddav/" + collection + "/");
        Map<String, String> eTags = syncCollectionResponse.getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = this.addressbookMultiget(collection, eTags.keySet());
        VCardResource card = BasicTest.assertContains(uid, addressData);
        Assert.assertEquals((String)"N wrong", (Object)firstName, (Object)card.getGivenName());
        Assert.assertEquals((String)"N wrong", (Object)lastName, (Object)card.getFamilyName());
        Assert.assertEquals((String)"FN wrong", (Object)(firstName + " " + lastName), (Object)card.getFN());
        String href = card.getHref();
        contact.setCellularTelephone1("352-3534");
        contact.setCategories("Family,Private");
        contact = this.update(contact);
        syncCollectionResponse = this.syncCollection(syncToken, "/carddav/" + collection + "/");
        eTags = syncCollectionResponse.getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        addressData = this.addressbookMultiget(collection, eTags.keySet());
        card = BasicTest.assertContains(uid, addressData);
        Assert.assertEquals((String)"N wrong", (Object)firstName, (Object)card.getGivenName());
        Assert.assertEquals((String)"N wrong", (Object)lastName, (Object)card.getFamilyName());
        Assert.assertEquals((String)"FN wrong", (Object)(firstName + " " + lastName), (Object)card.getFN());
        Assert.assertTrue((String)"No TELs found", (null != card.getVCard().getTels() && 1 == card.getVCard().getTels().size() ? 1 : 0) != 0);
        Assert.assertEquals((String)"TEL wrong", (Object)"352-3534", (Object)((TelType)card.getVCard().getTels().get(0)).getTelephone());
        Assert.assertTrue((String)"CATEGORIES wrong", (boolean)card.getVCard().getCategories().containsCategory("Family"));
        Assert.assertTrue((String)"CATEGORIES wrong", (boolean)card.getVCard().getCategories().containsCategory("Private"));
        this.delete(contact);
        syncCollectionResponse = this.syncCollection(syncToken, "/carddav/" + collection + "/");
        List<String> hrefsNotFound = syncCollectionResponse.getHrefsStatusNotFound();
        Assert.assertTrue((String)"no resource deletions reported on sync collection", (null != hrefsNotFound && 1 == hrefsNotFound.size() ? 1 : 0) != 0);
        Assert.assertEquals((String)"href not found", (Object)href, (Object)hrefsNotFound.get(0));
    }

    @Test
    public void testDiscoverAddressbooks() throws Exception {
        ArrayList<String> expectedCollections = new ArrayList<String>();
        VisibleFoldersRequest foldersRequest = new VisibleFoldersRequest(EnumAPI.OX_NEW, "contacts", new int[]{1, 300});
        VisibleFoldersResponse foldersResponse = this.client.execute(foldersRequest);
        Iterator<FolderObject> folders = foldersResponse.getPrivateFolders();
        while (folders.hasNext()) {
            expectedCollections.add("/carddav/" + folders.next().getObjectID() + '/');
        }
        folders = foldersResponse.getSharedFolders();
        while (folders.hasNext()) {
            expectedCollections.add("/carddav/" + folders.next().getObjectID() + '/');
        }
        folders = foldersResponse.getPublicFolders();
        while (folders.hasNext()) {
            expectedCollections.add("/carddav/" + folders.next().getObjectID() + '/');
        }
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.CURRENT_USER_PRINCIPAL);
        props.add(PropertyNames.PRINCIPAL_URL);
        props.add(PropertyNames.RESOURCETYPE);
        PropFindMethod propFind = new PropFindMethod(BasicTest.getBaseUri() + "/", 0, props, 0);
        MultiStatusResponse propFindResponse = BasicTest.assertSingleResponse(this.getWebDAVClient().doPropFind(propFind));
        String principalURL = this.extractHref(PropertyNames.CURRENT_USER_PRINCIPAL, propFindResponse);
        Assert.assertTrue((String)("username not found in href child of " + PropertyNames.CURRENT_USER_PRINCIPAL), (boolean)principalURL.contains("/" + this.getClient().getValues().getUserId()));
        props = new DavPropertyNameSet();
        props.add(PropertyNames.ADDRESSBOOK_HOME_SET);
        props.add(PropertyNames.DISPLAYNAME);
        props.add(PropertyNames.EMAIL_ADDRESS_SET);
        props.add(PropertyNames.PRINCIPAL_COLLECTION_SET);
        props.add(PropertyNames.PRINCIPAL_URL);
        props.add(PropertyNames.RESOURCE_ID);
        props.add(PropertyNames.SUPPORTED_REPORT_SET);
        propFind = new PropFindMethod(BasicTest.getBaseUri() + principalURL, 0, props, 0);
        propFindResponse = BasicTest.assertSingleResponse(this.getWebDAVClient().doPropFind(propFind));
        String addressbookHomeSet = this.extractHref(PropertyNames.ADDRESSBOOK_HOME_SET, propFindResponse);
        props = new DavPropertyNameSet();
        props.add(PropertyNames.CURRENT_USER_PRIVILEGE_SET);
        props.add(PropertyNames.DISPLAYNAME);
        props.add(PropertyNames.MAX_IMAGE_SIZE);
        props.add(PropertyNames.MAX_RESOURCE_SIZE);
        props.add(PropertyNames.OWNER);
        props.add(PropertyNames.RESOURCETYPE);
        props.add(PropertyNames.SUPPORTED_REPORT_SET);
        ArrayList<String> actualCollections = new ArrayList<String>();
        propFind = new PropFindMethod(BasicTest.getBaseUri() + addressbookHomeSet, 0, props, 1);
        for (MultiStatusResponse response : this.getWebDAVClient().doPropFind(propFind)) {
            DavProperty property = response.getProperties(200).get(PropertyNames.RESOURCETYPE);
            Object value = property.getValue();
            Collection<Object> resourceTypeNodes = Collection.class.isInstance(value) ? (List)value : Collections.singleton((Node)value);
            for (Node node : resourceTypeNodes) {
                if (!"urn:ietf:params:xml:ns:carddav".equals(node.getNamespaceURI()) || !"addressbook".equals(node.getNodeName())) continue;
                actualCollections.add(response.getHref());
            }
        }
        for (String collection : actualCollections) {
            Assert.assertTrue((String)("Expected collection " + collection + " not found"), (boolean)actualCollections.contains(collection));
        }
        for (String collection : actualCollections) {
            Assert.assertTrue((String)("Unexpected collection " + collection + " found"), (boolean)expectedCollections.contains(collection));
        }
    }
}

