/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.bugs;

import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.groupware.container.Contact;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class Bug37172Test
extends CardDAVTest {
    @Test
    public void testNotLosingPhoneNumbers() throws Exception {
        String syncToken = super.fetchSyncToken();
        String uid = Bug37172Test.randomUID();
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:;Test;;;\r\nUID:" + uid + "\r\n" + "REV:2015-03-09T23:04:44+00:00\r\n" + "FN:Test\r\n" + "PRODID:-//ownCloud//NONSGML Contacts 0.3.0.18//EN\r\n" + "EMAIL;TYPE=WORK:test@abc123.de\r\n" + "TEL;TYPE=CELL:0151 123456789\r\n" + "TEL;TYPE=HOME:0911 9876543\r\n" + "TEL;TYPE=HOME:0160 123456\r\n" + "IMPP;X-SERVICE-TYPE=jabber:xmpp:87654321\r\n" + "TEL;TYPE=WORK:0912 12345678\r\n" + "END:VCARD\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putVCard(uid, vCard));
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        Assert.assertEquals((String)"uid wrong", (Object)uid, (Object)contact.getUid());
        Assert.assertEquals((String)"firstname wrong", (Object)"Test", (Object)contact.getGivenName());
        Assert.assertEquals((String)"lastname wrong", null, (Object)contact.getSurName());
        Assert.assertEquals((String)"cellular phone wrong", (Object)"0151 123456789", (Object)contact.getCellularTelephone1());
        Assert.assertEquals((String)"home phone wrong", (Object)"0911 9876543", (Object)contact.getTelephoneHome1());
        Assert.assertEquals((String)"home phone alternative wrong", (Object)"0160 123456", (Object)contact.getTelephoneHome2());
        Assert.assertEquals((String)"company phone wrong", (Object)"0912 12345678", (Object)contact.getTelephoneBusiness1());
        Assert.assertEquals((String)"xmpp jabber wrong", (Object)"xmpp:87654321", (Object)contact.getInstantMessenger2());
        Assert.assertEquals((String)"email wrong", (Object)"test@abc123.de", (Object)contact.getEmail1());
        Map<String, String> eTags = super.syncCollection(syncToken);
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = Bug37172Test.assertContains(uid, addressData);
        Assert.assertEquals((String)"N wrong", (Object)"Test", (Object)card.getGivenName());
        Assert.assertEquals((String)"FN wrong", (Object)"Test", (Object)card.getFN());
    }

    @Test
    public void testNotLosingPhoneNumbersAlt() throws Exception {
        String syncToken = super.fetchSyncToken();
        String uid = Bug37172Test.randomUID();
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:;Test;;;\r\nUID:" + uid + "\r\n" + "REV:2015-03-09T23:04:44+00:00\r\n" + "FN:Test\r\n" + "PRODID:-//ownCloud//NONSGML Contacts 0.3.0.18//EN\r\n" + "EMAIL;TYPE=WORK:test@abc123.de\r\n" + "TEL;TYPE=CELL:0151 123456789\r\n" + "TEL;TYPE=home,voice:0911 9876543\r\n" + "TEL;TYPE=home,voice:0160 123456\r\n" + "IMPP;X-SERVICE-TYPE=jabber:xmpp:87654321\r\n" + "TEL;TYPE=WORK,voice:0912 12345678\r\n" + "END:VCARD\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putVCard(uid, vCard));
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        Assert.assertEquals((String)"uid wrong", (Object)uid, (Object)contact.getUid());
        Assert.assertEquals((String)"firstname wrong", (Object)"Test", (Object)contact.getGivenName());
        Assert.assertEquals((String)"lastname wrong", null, (Object)contact.getSurName());
        Assert.assertEquals((String)"cellular phone wrong", (Object)"0151 123456789", (Object)contact.getCellularTelephone1());
        Assert.assertEquals((String)"home phone wrong", (Object)"0911 9876543", (Object)contact.getTelephoneHome1());
        Assert.assertEquals((String)"home phone alternative wrong", (Object)"0160 123456", (Object)contact.getTelephoneHome2());
        Assert.assertEquals((String)"company phone wrong", (Object)"0912 12345678", (Object)contact.getTelephoneBusiness1());
        Assert.assertEquals((String)"xmpp jabber wrong", (Object)"xmpp:87654321", (Object)contact.getInstantMessenger2());
        Assert.assertEquals((String)"email wrong", (Object)"test@abc123.de", (Object)contact.getEmail1());
        Map<String, String> eTags = super.syncCollection(syncToken);
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = Bug37172Test.assertContains(uid, addressData);
        Assert.assertEquals((String)"N wrong", (Object)"Test", (Object)card.getGivenName());
        Assert.assertEquals((String)"FN wrong", (Object)"Test", (Object)card.getFN());
    }
}

