/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.bugs;

import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.groupware.container.Contact;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class Bug21374Test
extends CardDAVTest {
    @Test
    public void testCreateWithProfession() throws Exception {
        String syncToken = super.fetchSyncToken();
        String uid = Bug21374Test.randomUID();
        String firstName = "test";
        String lastName = "jupp";
        String profession = "profession?";
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:jupp;test;;;\r\nFN:test jupp\r\nROLE:profession?\r\nUID:" + uid + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "PRODID:-//Apple Inc.//AddressBook 6.1//EN" + "\r\n" + "END:VCARD" + "\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putVCard(uid, vCard));
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        Assert.assertEquals((String)"uid wrong", (Object)uid, (Object)contact.getUid());
        Assert.assertEquals((String)"profession wrong", (Object)"profession?", (Object)contact.getProfession());
        Map<String, String> eTags = super.syncCollection(syncToken);
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = Bug21374Test.assertContains(uid, addressData);
        Assert.assertEquals((String)"N wrong", (Object)"test", (Object)card.getGivenName());
        Assert.assertEquals((String)"N wrong", (Object)"jupp", (Object)card.getFamilyName());
        Assert.assertEquals((String)"FN wrong", (Object)"test jupp", (Object)card.getFN());
        Assert.assertEquals((String)"ROLE wrong", (Object)"profession?", (Object)card.getVCard().getRole().getRole());
    }
}

