/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.ajax.importexport.actions.ICalImportRequest;
import com.openexchange.ajax.importexport.actions.ICalImportResponse;
import com.openexchange.dav.SyncToken;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.importexport.ImportResult;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class Bug44144Test
extends CalDAVTest {
    @Test
    public void testSyncImportedAppointment() throws Exception {
        SyncToken syncToken = new SyncToken(this.fetchSyncToken());
        String uid = Bug44144Test.randomUID();
        Date start = TimeTools.D("tomorrow at 6am");
        Date end = TimeTools.D("tomorrow at 8am");
        Date lastModified = TimeTools.D("Last month");
        Date created = TimeTools.D("Last month");
        String iCal = "BEGIN:VCALENDAR\r\nCALSCALE:GREGORIAN\r\nPRODID:-//Apple Inc.//iOS 9.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nDTSTART:19810329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nTZNAME:MESZ\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nDTSTART:19961027T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nTZNAME:MEZ\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCREATED:" + Bug44144Test.formatAsUTC(created) + "\r\n" + "DTEND;TZID=Europe/Berlin:" + Bug44144Test.format(end, "Europe/Berlin") + "\r\n" + "DTSTAMP:" + Bug44144Test.formatAsUTC(lastModified) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + Bug44144Test.format(start, "Europe/Berlin") + "\r\n" + "LAST-MODIFIED:" + Bug44144Test.formatAsUTC(lastModified) + "\r\n" + "SUMMARY:testimport\r\n" + "UID:" + uid + "\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        int parentFolderID = Integer.parseInt(this.getDefaultFolderID());
        ICalImportRequest importRequest = new ICalImportRequest(parentFolderID, Streams.newByteArrayInputStream((byte[])iCal.getBytes(Charsets.UTF_8)));
        ICalImportResponse importResponse = this.client.execute(importRequest);
        ImportResult[] importResult = importResponse.getImports();
        Assert.assertNotNull((String)"No import result", (Object)importResult);
        Assert.assertEquals((String)"Unexpected number of import results", (long)1L, (long)importResult.length);
        int objectID = Integer.parseInt(importResult[0].getObjectId());
        Appointment appointment = this.getManager().get(parentFolderID, objectID);
        Assert.assertNotNull((String)"Appointment not found", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Map<String, String> eTags = this.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = this.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = Bug44144Test.assertContains(uid, calendarData);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
    }

    @Test
    public void testSyncImportedAppointmentFromClient() throws Exception {
        SyncToken syncToken = new SyncToken(this.fetchSyncToken());
        String uid = Bug44144Test.randomUID();
        Date start = TimeTools.D("tomorrow at 6am");
        Date end = TimeTools.D("tomorrow at 8am");
        Date lastModified = TimeTools.D("Last month");
        Date created = TimeTools.D("Last month");
        String iCal = "BEGIN:VCALENDAR\r\nCALSCALE:GREGORIAN\r\nPRODID:-//Apple Inc.//iOS 9.1//EN\r\nVERSION:2.0\r\nBEGIN:VTIMEZONE\r\nTZID:Europe/Berlin\r\nBEGIN:DAYLIGHT\r\nDTSTART:19810329T020000\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\r\nTZNAME:MESZ\r\nTZOFFSETFROM:+0100\r\nTZOFFSETTO:+0200\r\nEND:DAYLIGHT\r\nBEGIN:STANDARD\r\nDTSTART:19961027T030000\r\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\r\nTZNAME:MEZ\r\nTZOFFSETFROM:+0200\r\nTZOFFSETTO:+0100\r\nEND:STANDARD\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nCREATED:" + Bug44144Test.formatAsUTC(created) + "\r\n" + "DTEND;TZID=Europe/Berlin:" + Bug44144Test.format(end, "Europe/Berlin") + "\r\n" + "DTSTAMP:" + Bug44144Test.formatAsUTC(lastModified) + "\r\n" + "DTSTART;TZID=Europe/Berlin:" + Bug44144Test.format(start, "Europe/Berlin") + "\r\n" + "LAST-MODIFIED:" + Bug44144Test.formatAsUTC(lastModified) + "\r\n" + "SUMMARY:testimport\r\n" + "UID:" + uid + "\r\n" + "END:VEVENT\r\n" + "END:VCALENDAR\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICal(uid, iCal));
        Appointment appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        this.rememberForCleanUp(appointment);
        Map<String, String> eTags = this.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = this.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = Bug44144Test.assertContains(uid, calendarData);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
    }
}

