/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.dav.SyncToken;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.test.CalendarTestManager;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Bug44131Test
extends CalDAVTest {
    private CalendarTestManager manager2;

    @Before
    public void setUp() throws Exception {
        this.manager2 = new CalendarTestManager(new AJAXClient(AJAXClient.User.User2));
        this.manager2.setFailOnError(true);
    }

    @After
    public void tearDown() throws Exception {
        if (null != this.manager2) {
            this.manager2.cleanUp();
            if (null != this.manager2.getClient()) {
                this.manager2.getClient().logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccessDeletedException() throws Exception {
        SyncToken syncToken = new SyncToken(this.fetchSyncToken());
        String uid = Bug44131Test.randomUID();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(TimeTools.D("last month in the morning", TimeZone.getTimeZone("Europe/Berlin")));
        Appointment appointment = new Appointment();
        appointment.setUid(uid);
        appointment.setTitle("Bug44131Test");
        appointment.setIgnoreConflicts(true);
        appointment.setRecurrenceType(1);
        appointment.setInterval(1);
        appointment.setStartDate(calendar.getTime());
        calendar.add(11, 1);
        appointment.setEndDate(calendar.getTime());
        appointment.addParticipant((Participant)new UserParticipant(this.manager2.getClient().getValues().getUserId()));
        appointment.addParticipant((Participant)new UserParticipant(new AJAXClient(AJAXClient.User.User3).getValues().getUserId()));
        appointment.setParentFolderID(this.manager2.getPrivateFolder());
        this.manager2.insert(appointment);
        Date clientLastModified = this.manager2.getLastModification();
        Appointment exception = new Appointment();
        exception.setTitle("Bug44131Test_edit");
        exception.setObjectID(appointment.getObjectID());
        exception.setRecurrencePosition(2);
        exception.setLastModified(clientLastModified);
        exception.setParentFolderID(appointment.getParentFolderID());
        exception.addParticipant((Participant)new UserParticipant(this.manager2.getClient().getValues().getUserId()));
        exception.addParticipant((Participant)new UserParticipant(new AJAXClient(AJAXClient.User.User3).getValues().getUserId()));
        exception.addParticipant((Participant)new UserParticipant(this.getClient().getValues().getUserId()));
        this.manager2.update(exception);
        clientLastModified = this.getManager().getLastModification();
        Map<String, String> eTags = this.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = this.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = Bug44131Test.assertContains(uid, calendarData);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)exception.getTitle(), (Object)iCalResource.getVEvent().getSummary());
        this.manager2.delete(exception);
        clientLastModified = this.getManager().getLastModification();
        GetMethod get = null;
        try {
            get = new GetMethod(Bug44131Test.getBaseUri() + iCalResource.getHref());
            Assert.assertEquals((String)"response code wrong", (long)404L, (long)this.getWebDAVClient().executeMethod((HttpMethod)get));
        }
        catch (Throwable throwable) {
            Bug44131Test.release(get);
            throw throwable;
        }
        Bug44131Test.release((HttpMethodBase)get);
        List<String> hrefs = this.syncCollection(syncToken).getHrefsStatusNotFound();
        Assert.assertTrue((String)"no resource deletions reported on sync collection", (0 < hrefs.size() ? 1 : 0) != 0);
        Assert.assertTrue((String)"href of change exception not found", (boolean)hrefs.contains(iCalResource.getHref()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccessExceptionAsRemovedParticipant() throws Exception {
        SyncToken syncToken = new SyncToken(this.fetchSyncToken());
        String uid = Bug44131Test.randomUID();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(TimeTools.D("last month in the morning", TimeZone.getTimeZone("Europe/Berlin")));
        Appointment appointment = new Appointment();
        appointment.setUid(uid);
        appointment.setTitle("Bug44131Test");
        appointment.setIgnoreConflicts(true);
        appointment.setRecurrenceType(1);
        appointment.setInterval(1);
        appointment.setStartDate(calendar.getTime());
        calendar.add(11, 1);
        appointment.setEndDate(calendar.getTime());
        appointment.addParticipant((Participant)new UserParticipant(this.manager2.getClient().getValues().getUserId()));
        appointment.addParticipant((Participant)new UserParticipant(new AJAXClient(AJAXClient.User.User3).getValues().getUserId()));
        appointment.setParentFolderID(this.manager2.getPrivateFolder());
        this.manager2.insert(appointment);
        Date clientLastModified = this.manager2.getLastModification();
        Appointment exception = new Appointment();
        exception.setTitle("Bug44131Test_edit");
        exception.setObjectID(appointment.getObjectID());
        exception.setRecurrencePosition(2);
        exception.setLastModified(clientLastModified);
        exception.setParentFolderID(appointment.getParentFolderID());
        exception.addParticipant((Participant)new UserParticipant(this.manager2.getClient().getValues().getUserId()));
        exception.addParticipant((Participant)new UserParticipant(new AJAXClient(AJAXClient.User.User3).getValues().getUserId()));
        exception.addParticipant((Participant)new UserParticipant(this.getClient().getValues().getUserId()));
        this.manager2.update(exception);
        clientLastModified = this.manager2.getLastModification();
        Map<String, String> eTags = this.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = this.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = Bug44131Test.assertContains(uid, calendarData);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)exception.getTitle(), (Object)iCalResource.getVEvent().getSummary());
        exception.removeParticipants();
        exception.addParticipant((Participant)new UserParticipant(this.manager2.getClient().getValues().getUserId()));
        exception.addParticipant((Participant)new UserParticipant(new AJAXClient(AJAXClient.User.User3).getValues().getUserId()));
        exception.setLastModified(clientLastModified);
        this.manager2.update(exception);
        clientLastModified = this.getManager().getLastModification();
        GetMethod get = null;
        try {
            get = new GetMethod(Bug44131Test.getBaseUri() + iCalResource.getHref());
            Assert.assertEquals((String)"response code wrong", (long)404L, (long)this.getWebDAVClient().executeMethod((HttpMethod)get));
        }
        catch (Throwable throwable) {
            Bug44131Test.release(get);
            throw throwable;
        }
        Bug44131Test.release((HttpMethodBase)get);
        List<String> hrefs = this.syncCollection(syncToken).getHrefsStatusNotFound();
        Assert.assertTrue((String)"no resource deletions reported on sync collection", (0 < hrefs.size() ? 1 : 0) != 0);
        Assert.assertTrue((String)"href of change exception not found", (boolean)hrefs.contains(iCalResource.getHref()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccessDeletedAppointment() throws Exception {
        SyncToken syncToken = new SyncToken(this.fetchSyncToken());
        String uid = Bug44131Test.randomUID();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(TimeTools.D("last month in the morning", TimeZone.getTimeZone("Europe/Berlin")));
        Appointment appointment = new Appointment();
        appointment.setUid(uid);
        appointment.setTitle("Bug44131Test");
        appointment.setIgnoreConflicts(true);
        appointment.setStartDate(calendar.getTime());
        calendar.add(11, 1);
        appointment.setEndDate(calendar.getTime());
        appointment.addParticipant((Participant)new UserParticipant(this.manager2.getClient().getValues().getUserId()));
        appointment.addParticipant((Participant)new UserParticipant(new AJAXClient(AJAXClient.User.User3).getValues().getUserId()));
        appointment.addParticipant((Participant)new UserParticipant(this.getClient().getValues().getUserId()));
        appointment.setParentFolderID(this.manager2.getPrivateFolder());
        this.manager2.insert(appointment);
        Map<String, String> eTags = this.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = this.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = Bug44131Test.assertContains(uid, calendarData);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)appointment.getTitle(), (Object)iCalResource.getVEvent().getSummary());
        this.manager2.delete(appointment);
        GetMethod get = null;
        try {
            get = new GetMethod(Bug44131Test.getBaseUri() + iCalResource.getHref());
            Assert.assertEquals((String)"response code wrong", (long)404L, (long)this.getWebDAVClient().executeMethod((HttpMethod)get));
        }
        catch (Throwable throwable) {
            Bug44131Test.release(get);
            throw throwable;
        }
        Bug44131Test.release((HttpMethodBase)get);
        List<String> hrefs = this.syncCollection(syncToken).getHrefsStatusNotFound();
        Assert.assertTrue((String)"no resource deletions reported on sync collection", (0 < hrefs.size() ? 1 : 0) != 0);
        Assert.assertTrue((String)"href of change exception not found", (boolean)hrefs.contains(iCalResource.getHref()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccessAppointmentAsRemovedParticipant() throws Exception {
        SyncToken syncToken = new SyncToken(this.fetchSyncToken());
        String uid = Bug44131Test.randomUID();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(TimeTools.D("last month in the morning", TimeZone.getTimeZone("Europe/Berlin")));
        Appointment appointment = new Appointment();
        appointment.setUid(uid);
        appointment.setTitle("Bug44131Test");
        appointment.setIgnoreConflicts(true);
        appointment.setStartDate(calendar.getTime());
        calendar.add(11, 1);
        appointment.setEndDate(calendar.getTime());
        appointment.addParticipant((Participant)new UserParticipant(this.manager2.getClient().getValues().getUserId()));
        appointment.addParticipant((Participant)new UserParticipant(new AJAXClient(AJAXClient.User.User3).getValues().getUserId()));
        appointment.addParticipant((Participant)new UserParticipant(this.getClient().getValues().getUserId()));
        appointment.setParentFolderID(this.manager2.getPrivateFolder());
        this.manager2.insert(appointment);
        Date clientLastModified = this.manager2.getLastModification();
        Map<String, String> eTags = this.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = this.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = Bug44131Test.assertContains(uid, calendarData);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)appointment.getTitle(), (Object)iCalResource.getVEvent().getSummary());
        appointment.removeParticipants();
        appointment.addParticipant((Participant)new UserParticipant(this.manager2.getClient().getValues().getUserId()));
        appointment.addParticipant((Participant)new UserParticipant(new AJAXClient(AJAXClient.User.User3).getValues().getUserId()));
        appointment.setLastModified(clientLastModified);
        this.manager2.update(appointment);
        GetMethod get = null;
        try {
            get = new GetMethod(Bug44131Test.getBaseUri() + iCalResource.getHref());
            Assert.assertEquals((String)"response code wrong", (long)404L, (long)this.getWebDAVClient().executeMethod((HttpMethod)get));
        }
        catch (Throwable throwable) {
            Bug44131Test.release(get);
            throw throwable;
        }
        Bug44131Test.release((HttpMethodBase)get);
        List<String> hrefs = this.syncCollection(syncToken).getHrefsStatusNotFound();
        Assert.assertTrue((String)"no resource deletions reported on sync collection", (0 < hrefs.size() ? 1 : 0) != 0);
        Assert.assertTrue((String)"href of change exception not found", (boolean)hrefs.contains(iCalResource.getHref()));
    }
}

