/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class Bug43782Test
extends CalDAVTest {
    @Test
    public void testUpdateSummary() throws Exception {
        this.testUpdateSummary(true);
    }

    @Test
    public void testUpdateSummaryRemovingAcknowledged() throws Exception {
        this.testUpdateSummary(false);
    }

    @Test
    public void testUpdateStartAndEnd() throws Exception {
        this.testUpdateStartAndEnd(true);
    }

    @Test
    public void testUpdateStartAndEndRemovingAcknowledged() throws Exception {
        this.testUpdateStartAndEnd(false);
    }

    private void testUpdateSummary(boolean preserveAcknowledged) throws Exception {
        SyncToken syncToken = new SyncToken(this.fetchSyncToken());
        String uid = Bug43782Test.randomUID();
        String summary = "test";
        String location = "ort";
        Date start = TimeTools.D("next tuesday at 12:30");
        Date end = TimeTools.D("next tuesday at 13:45");
        Appointment appointment = Bug43782Test.generateAppointment(start, end, uid, summary, location);
        appointment.setAlarm(15);
        appointment.setAlarmFlag(true);
        this.rememberForCleanUp(this.create(appointment));
        Map<String, String> eTags = this.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = this.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = Bug43782Test.assertContains(uid, calendarData);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)summary, (Object)iCalResource.getVEvent().getSummary());
        Assert.assertEquals((String)"LOCATION wrong", (Object)location, (Object)iCalResource.getVEvent().getLocation());
        List<SimpleICal.Component> vAlarms = iCalResource.getVEvent().getVAlarms();
        Assert.assertEquals((String)"Unexpected number of VALARMs found", (long)1L, (long)vAlarms.size());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)vAlarms.get(0).getPropertyValue("TRIGGER"));
        summary = summary + "_edit";
        iCalResource.getVEvent().setSummary(summary);
        if (!preserveAcknowledged) {
            iCalResource.getVEvent().getVAlarm().removeProperties("ACKNOWLEDGED");
        }
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(iCalResource));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertEquals((String)"Title wrong", (Object)summary, (Object)appointment.getTitle());
        Assert.assertEquals((String)"Start wrong", (Object)start, (Object)appointment.getStartDate());
        Assert.assertEquals((String)"End wrong", (Object)end, (Object)appointment.getEndDate());
        Assert.assertTrue((String)"No reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"Reminder wrong", (long)15L, (long)appointment.getAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)summary, (Object)iCalResource.getVEvent().getSummary());
        Assert.assertEquals((String)"LOCATION wrong", (Object)location, (Object)iCalResource.getVEvent().getLocation());
        vAlarms = iCalResource.getVEvent().getVAlarms();
        Assert.assertEquals((String)"Unexpected number of VALARMs found", (long)1L, (long)vAlarms.size());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)vAlarms.get(0).getPropertyValue("TRIGGER"));
    }

    private void testUpdateStartAndEnd(boolean preserveAcknowledged) throws Exception {
        SyncToken syncToken = new SyncToken(this.fetchSyncToken());
        String uid = Bug43782Test.randomUID();
        String summary = "test";
        String location = "ort";
        Date start = TimeTools.D("next tuesday at 12:30");
        Date end = TimeTools.D("next tuesday at 13:45");
        Appointment appointment = Bug43782Test.generateAppointment(start, end, uid, summary, location);
        appointment.setAlarm(15);
        appointment.setAlarmFlag(true);
        this.rememberForCleanUp(this.create(appointment));
        Map<String, String> eTags = this.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = this.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = Bug43782Test.assertContains(uid, calendarData);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)summary, (Object)iCalResource.getVEvent().getSummary());
        Assert.assertEquals((String)"LOCATION wrong", (Object)location, (Object)iCalResource.getVEvent().getLocation());
        List<SimpleICal.Component> vAlarms = iCalResource.getVEvent().getVAlarms();
        Assert.assertEquals((String)"Unexpected number of VALARMs found", (long)1L, (long)vAlarms.size());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)vAlarms.get(0).getPropertyValue("TRIGGER"));
        start = TimeTools.D("next tuesday at 11:30");
        SimpleICal.Property dtStart = iCalResource.getVEvent().getProperty("DTSTART");
        iCalResource.getVEvent().setProperty("DTSTART", Bug43782Test.format(start, dtStart.getAttribute("TZID")), dtStart.getAttributes());
        end = TimeTools.D("next tuesday at 12:45");
        SimpleICal.Property dtEnd = iCalResource.getVEvent().getProperty("DTEND");
        iCalResource.getVEvent().setProperty("DTEND", Bug43782Test.format(end, dtEnd.getAttribute("TZID")), dtEnd.getAttributes());
        if (!preserveAcknowledged) {
            iCalResource.getVEvent().getVAlarm().removeProperties("ACKNOWLEDGED");
        }
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(iCalResource));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertEquals((String)"Title wrong", (Object)summary, (Object)appointment.getTitle());
        Assert.assertEquals((String)"Start wrong", (Object)start, (Object)appointment.getStartDate());
        Assert.assertEquals((String)"End wrong", (Object)end, (Object)appointment.getEndDate());
        Assert.assertTrue((String)"No reminder found", (boolean)appointment.containsAlarm());
        Assert.assertEquals((String)"Reminder wrong", (long)15L, (long)appointment.getAlarm());
        iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)summary, (Object)iCalResource.getVEvent().getSummary());
        Assert.assertEquals((String)"LOCATION wrong", (Object)location, (Object)iCalResource.getVEvent().getLocation());
        vAlarms = iCalResource.getVEvent().getVAlarms();
        Assert.assertEquals((String)"Unexpected number of VALARMs found", (long)1L, (long)vAlarms.size());
        Assert.assertEquals((String)"ALARM wrong", (Object)"-PT15M", (Object)vAlarms.get(0).getPropertyValue("TRIGGER"));
    }
}

