/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Date;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.junit.Assert;
import org.junit.Test;

public class Bug42104Test
extends CalDAVTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetWithIfMatch() throws Exception {
        String uid = Bug42104Test.randomUID();
        String summary = "Bug42104Test";
        String location = "da";
        Date start = TimeTools.D("next friday at 02:00");
        Date end = TimeTools.D("next friday at 04:00");
        Appointment appointment = Bug42104Test.generateAppointment(start, end, uid, summary, location);
        this.rememberForCleanUp(this.create(appointment));
        ICalResource iCalResource = this.get(uid);
        Assert.assertEquals((String)"SUMMARY wrong", (Object)summary, (Object)iCalResource.getVEvent().getSummary());
        Assert.assertEquals((String)"LOCATION wrong", (Object)location, (Object)iCalResource.getVEvent().getLocation());
        String originalETag = iCalResource.getETag();
        iCalResource.getVEvent().setSummary(summary + "_edit");
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)this.putICalUpdate(iCalResource));
        appointment = this.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        GetMethod get = null;
        try {
            String href = "/caldav/" + this.getDefaultFolderID() + "/" + uid + ".ics";
            get = new GetMethod(Bug42104Test.getBaseUri() + href);
            get.addRequestHeader("If-Match", originalETag);
            Assert.assertEquals((String)"response code wrong", (long)304L, (long)this.getWebDAVClient().executeMethod((HttpMethod)get));
        }
        catch (Throwable throwable) {
            Bug42104Test.release(get);
            throw throwable;
        }
        Bug42104Test.release((HttpMethodBase)get);
    }
}

