/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class Bug31490Test
extends CalDAVTest {
    @Test
    public void testImportMalformedAttendee() throws Exception {
        String uid = Bug31490Test.randomUID();
        Date start = TimeTools.D("next sunday at 14:15");
        Date end = TimeTools.D("next sunday at 14:45");
        String iCal = "BEGIN:VCALENDAR\r\nPRODID:-//SurGATE Outlook DAV Client/v3.1\r\nVERSION:2.0\r\nMETHOD:PUBLISH\r\nX-MS-OLK-FORCEINSPECTOROPEN:TRUE\r\nBEGIN:VTIMEZONE\r\nTZID:America/Detroit\r\nBEGIN:STANDARD\r\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=+1SU\r\nDTSTART:16011101T020000\r\nTZOFFSETFROM:-0400\r\nTZOFFSETTO:-0500\r\nEND:STANDARD\r\nBEGIN:DAYLIGHT\r\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=+2SU\r\nDTSTART:16010302T020000\r\nTZOFFSETFROM:-0500\r\nTZOFFSETTO:-0400\r\nEND:DAYLIGHT\r\nEND:VTIMEZONE\r\nBEGIN:VEVENT\r\nATTENDEE;PARTSTAT=ACCEPTED;CN=\"'Jason Magouirk' <jason.magouirk@mocgnigass\r\n\te.mwo>\";ROLE=REQ-PARTICIPANT;RSVP=TRUE:'Jason Magouirk' <jason.magouirk@m\r\n\tocgnigasse.mwo>\r\nATTENDEE;PARTSTAT=DECLINED;CN=\"'Duy Doan' <duy.doan@mocgnigasse.mwo>\";ROLE\r\n\t=REQ-PARTICIPANT;RSVP=TRUE:'Duy Doan' <duy.doan@mocgnigasse.mwo>\r\nATTENDEE;PARTSTAT=DECLINED;CN=\"'Michael Mohammed' <mike.mohammed@mocgnigas\r\n\tse.mwo>\";ROLE=REQ-PARTICIPANT;RSVP=TRUE:'Michael Mohammed' <mike.mohammed\r\n\t@mocgnigasse.mwo>\r\nATTENDEE;PARTSTAT=DECLINED;CN=\"'David Kerr' <david.kerr@mocgnigasse.mwo>\";\r\n\tROLE=REQ-PARTICIPANT;RSVP=TRUE:'David Kerr' <david.kerr@mocgnigasse.mwo>\r\nATTENDEE;PARTSTAT=DECLINED;CN=\"'Estanislao Utrilla' <estanislao.gines@mocg\r\n\tnigasse.mwo>\";ROLE=REQ-PARTICIPANT;RSVP=TRUE:'Estanislao Utrilla' <estani\r\n\tslao.gines@mocgnigasse.mwo>\r\nATTENDEE;PARTSTAT=ACCEPTED;CN=\"'Benoit Raymond' <benoit.raymond@mocgnigass\r\n\te.mwo>\";ROLE=REQ-PARTICIPANT;RSVP=TRUE:'Benoit Raymond' <benoit.raymond@m\r\n\tocgnigasse.mwo>\r\nATTENDEE;PARTSTAT=ACCEPTED;CN=\"'Sophia Xu' <sophia.xu@mocgnigasse.mwo>\";RO\r\n\tLE=REQ-PARTICIPANT;RSVP=TRUE:'Sophia Xu' <sophia.xu@mocgnigasse.mwo>\r\nATTENDEE;PARTSTAT=ACCEPTED;CN=\"'Ted Corning' <" + this.client.getValues().getDefaultAddress() + ">\r\n" + "\t\";ROLE=REQ-PARTICIPANT;RSVP=TRUE:'Ted Corning' <" + this.client.getValues().getDefaultAddress() + "\r\n" + "ATTENDEE;PARTSTAT=ACCEPTED;CN=\"'Paolo Biancolli' <paolo.biancolli@mocgniga\r\n" + "\tsse.mwo>\";ROLE=REQ-PARTICIPANT;RSVP=TRUE:'Paolo Biancolli' <paolo.biancol\r\n" + "\tli@mocgnigasse.mwo>\r\n" + "ATTENDEE;PARTSTAT=ACCEPTED;CN=\"'Pat Matthews' <pat.matthews@mocgnigasse.mw\r\n" + "\to>\";ROLE=REQ-PARTICIPANT;RSVP=TRUE:'Pat Matthews' <pat.matthews@mocgnigas\r\n" + "\tse.mwo>\r\n" + "ATTENDEE;PARTSTAT=ACCEPTED;CN=\"'Pedro Romana' <pedro.romana@mocgnigasse.mw\r\n" + "\to>\";ROLE=REQ-PARTICIPANT;RSVP=TRUE:'Pedro Romana' <pedro.romana@mocgnigas\r\n" + "\tse.mwo>\r\n" + "ATTENDEE;PARTSTAT=TENTATIVE;CN=\"'Stacy Lanier' <stacy.lanier@mocgnigasse.m\r\n" + "\two>\";ROLE=REQ-PARTICIPANT;RSVP=TRUE:'Stacy Lanier' <stacy.lanier@mocgniga\r\n" + "\tsse.mwo>\r\n" + "CREATED:" + Bug31490Test.formatAsUTC(TimeTools.D("yesterday noon")) + "\r\n" + "CLASS:PUBLIC\r\n" + "DTSTAMP:" + Bug31490Test.formatAsUTC(new Date()) + "\r\n" + "LAST-MODIFIED:20140305T210711Z\r\n" + "RRULE:FREQ=WEEKLY;BYDAY=WE\r\n" + "DTSTART;TZID=America/Detroit:" + Bug31490Test.format(start, "America/Detroit") + "\r\n" + "DTEND;TZID=America/Detroit:" + Bug31490Test.format(end, "America/Detroit") + "\r\n" + "LOCATION:Bridge: 5227343\\\\; US: +1 303-248-9655\\\\;  Toll Free/Int'l: 866-3\r\n" + "\t65-4406\r\n" + "TRANSP:OPAQUE\r\n" + "X-MICROSOFT-CDO-BUSYSTATUS:BUSY\r\n" + "UID:" + uid + "\r\n" + "DESCRIPTION:Team, \\n\\nI am re-sending since for Mariner, but using individ\r\n" + "\tual addresses\\ninstead of the mailing list, since that didn't seem to go \r\n" + "\twell.\\nPlus I couldn't get it to save with a reminder set, no matter\\nwha\r\n" + "\tt I tried.\\n\\nThis is a meeting where we discuss issues, including approa\r\n" + "\tches to \\ntroubleshooting, data collection for possible escalation, gener\r\n" + "\tal \\nproduct questions, etc. While the meeting is mainly for Email Mx, \\n\r\n" + "\tEdge Gx, and Extensions, others products (Directory, WebEdge, etc) \\ncan \r\n" + "\talso be discussed. \\n\\nThe dial-in info is: \\nReady-Access Number: +1 303\r\n" + "\t-248-9655 \\nToll Free Ready-Access Number (if needed): 866-365-4406 \\\\n7-\r\n" + "\tDigit Access Code: 5227343 \\n\\nThanks! \\nTed \\n\\n\\n\\n\r\n" + "X-ALT-DESC;FMTTYPE=text/html:<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//\r\n" + "\tEN\">\\n<HTML>\\n<HEAD>\\n<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html;\r\n" + "\t charset=utf-8\">\\n<META NAME=\"Generator\" CONTENT=\"MS Exchange Server vers\r\n" + "\tion 14.02.5004.000\">\\n<TITLE> TPS Troubleshooting Roundtable</TITLE>\\n</H\r\n" + "\tEAD>\\n<BODY>\\n<!-- Converted from text/plain format -->\\n\\n<P><FONT SIZE=\r\n" + "\t2>Team,<BR>\\n<BR>\\nI am re-sending since for Mariner, but using individua\r\n" + "\tl addresses<BR>\\ninstead of the mailing list, since that didn't seem to g\r\n" + "\to well.<BR>\\nPlus I couldn't get it to save with a reminder set, no matte\r\n" + "\tr<BR>\\nwhat I tried.<BR>\\n<BR>\\nThis is a meeting where we discuss issues\r\n" + "\t, including approaches to<BR>\\ntroubleshooting, data collection for possi\r\n" + "\tble escalation, general<BR>\\nproduct questions, etc. While the meeting is\r\n" + "\t mainly for Email Mx,<BR>\\nEdge Gx, and Extensions, others products (Dire\r\n" + "\tctory, WebEdge, etc)<BR>\\ncan also be discussed.<BR>\\n<BR>\\nThe dial-in i\r\n" + "\tnfo is:<BR>\\nReady-Access Number: +1 303-248-9655<BR>\\nToll Free Ready-Ac\r\n" + "\tcess Number (if needed): 866-365-4406 \\\\n7-Digit Access Code: 5227343<BR>\r\n" + "\t\\n<BR>\\nThanks!<BR>\\nTed<BR>\\n<BR>\\n<BR>\\n<BR>\\n</FONT>\\n</P>\\n\\n</BODY>\\\r\n" + "\tn</HTML>\r\n" + "SUMMARY: TPS Troubleshooting Roundtable\r\n" + "LOCATION:Bridge: 5227343\\\\; US: +1 303-248-9655\\\\;  Toll Free/Int'l: 866-3\r\n" + "\t65-4406\r\n" + "PRIORITY:5\r\n" + "SEQUENCE:8\r\n" + "END:VEVENT\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICal(uid, iCal));
        Appointment appointment = super.getAppointment(uid);
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        super.rememberForCleanUp(appointment);
        Assert.assertNotNull((String)"No participants found", (Object)appointment.getParticipants());
        Assert.assertEquals((String)"incorrect number of participants", (long)12L, (long)appointment.getParticipants().length);
        ICalResource iCalResource = this.get(uid);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"UID wrong", (Object)uid, (Object)iCalResource.getVEvent().getUID());
        Assert.assertNotNull((String)"No ATTENDEEs found", iCalResource.getVEvent().getProperties("ATTENDEE"));
        Assert.assertEquals((String)"incorrect number of ATTENDEEs", (long)12L, (long)iCalResource.getVEvent().getProperties("ATTENDEE").size());
    }
}

