/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.subscribe.test;

import com.openexchange.ajax.subscribe.actions.NewSubscriptionResponse;
import com.openexchange.ajax.subscribe.actions.RefreshSubscriptionResponse;
import com.openexchange.ajax.subscribe.test.AbstractSubscriptionTest;
import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.subscribe.SimSubscriptionSourceDiscoveryService;
import com.openexchange.subscribe.Subscription;
import com.openexchange.subscribe.SubscriptionSourceDiscoveryService;
import java.io.IOException;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class RefreshSubscriptionTest
extends AbstractSubscriptionTest {
    public RefreshSubscriptionTest(String name) {
        super(name);
    }

    public void testShouldFailOnNonExistingSubscription() throws OXException, IOException, SAXException, JSONException {
    }

    public void testShouldNotFailOnExistingSubscription() throws OXException, IOException, SAXException, JSONException {
        FolderObject folder = this.createDefaultContactFolder();
        DynamicFormDescription formDescription = this.generateFormDescription();
        Subscription subscription = this.generateOXMFSubscription(formDescription, String.valueOf(folder.getObjectID()));
        SimSubscriptionSourceDiscoveryService discovery = new SimSubscriptionSourceDiscoveryService();
        discovery.addSource(subscription.getSource());
        this.subMgr.setFormDescription(formDescription);
        this.subMgr.setSubscriptionSourceDiscoveryService((SubscriptionSourceDiscoveryService)discovery);
        this.subMgr.newAction(subscription);
        RefreshSubscriptionTest.assertFalse((String)"Insert failed!", (boolean)((NewSubscriptionResponse)this.subMgr.getLastResponse()).hasError());
        this.subMgr.refreshAction(subscription.getId());
        RefreshSubscriptionResponse response = (RefreshSubscriptionResponse)this.subMgr.getLastResponse();
        RefreshSubscriptionTest.assertFalse((String)("Should have been successful, but got: " + response.getErrorMessage()), (boolean)response.hasError());
    }
}

