/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.snippet;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.managedfile.actions.GetPictureManagedFileRequest;
import com.openexchange.ajax.managedfile.actions.GetPictureManagedFileResponse;
import com.openexchange.ajax.managedfile.actions.NewManagedFileRequest;
import com.openexchange.ajax.managedfile.actions.NewManagedFileResponse;
import com.openexchange.ajax.snippet.actions.ListSnippetRequest;
import com.openexchange.ajax.snippet.actions.ListSnippetResponse;
import com.openexchange.ajax.snippet.actions.NewSnippetRequest;
import com.openexchange.ajax.snippet.actions.NewSnippetResponse;
import com.openexchange.configuration.MailConfig;
import com.openexchange.exception.OXException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TestSnippetSignature
extends AbstractAJAXSession {
    public TestSnippetSignature(String name) {
        super(name);
    }

    public void testCreateSignatureWithImageWorkflow() throws Exception {
        String mfID1 = this.uploadFile("contact_image.png");
        String mfID2 = this.uploadFile("ox_logo_sml.jpg");
        StringBuilder builder = new StringBuilder();
        builder.append("<img alt=\"\" width=\"120\" src=\"").append("/ajax/file?action=get&id=").append(mfID1).append("&session=").append(this.client.getSession().getId()).append("\" />");
        builder.append("<img alt=\"\" width=\"50\" src=\"").append("/ajax/file?action=get&id=").append(mfID2).append("&session=").append(this.client.getSession().getId()).append("\" />");
        JSONObject misc = new JSONObject();
        misc.put("insertion", (Object)"below");
        misc.put("content-type", (Object)"text/html");
        JSONObject body = new JSONObject();
        body.put("type", (Object)"signature");
        body.put("misc", (Object)misc);
        body.put("createdby", this.client.getValues().getUserId());
        body.put("content", (Object)("<h1>my test signature</h1>" + builder.toString()));
        body.put("accountid", 0);
        body.put("displayname", (Object)"DisplayName of signatures");
        body.put("module", (Object)"io.ox/mail");
        NewSnippetRequest req = new NewSnippetRequest(body);
        NewSnippetResponse resp = this.client.execute(req);
        Object data = resp.getData();
        TestSnippetSignature.assertNotNull((Object)data);
        int signId = Integer.parseInt((String)data);
        JSONArray array = new JSONArray();
        array.put(signId);
        ListSnippetRequest listReq = new ListSnippetRequest(array, true);
        ListSnippetResponse listResp = this.client.execute(listReq);
        TestSnippetSignature.assertNotNull((Object)((Object)listResp));
        data = listResp.getData();
        JSONArray json = (JSONArray)data;
        TestSnippetSignature.assertEquals((int)1, (int)json.length());
        JSONObject signature = json.getJSONObject(0);
        String content = signature.getString("content");
        GetPictureManagedFileRequest getPicReq = new GetPictureManagedFileRequest(mfID1);
        GetPictureManagedFileResponse getPicResp = this.client.execute(getPicReq);
        Object o = getPicResp.getData();
    }

    private String uploadFile(String filename) throws OXException, IOException, JSONException {
        byte[] file = this.readFile(filename);
        NewManagedFileRequest newMFReq = new NewManagedFileRequest("snippet", "image", file);
        NewManagedFileResponse newMFResp = this.client.execute(newMFReq);
        Object data = newMFResp.getData();
        TestSnippetSignature.assertTrue((String)"Response not a JSONArray", (boolean)(data instanceof JSONArray));
        JSONArray array = (JSONArray)data;
        TestSnippetSignature.assertEquals((String)"The response array should only contain one element", (int)1, (int)array.length());
        return array.getString(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile(String filename) throws IOException {
        byte[] ret;
        ByteArrayOutputStream ous = null;
        InputStream ios = null;
        try {
            byte[] buffer = new byte[4096];
            ous = new ByteArrayOutputStream();
            ios = new FileInputStream(new File(MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR) + filename));
            int read = 0;
            while ((read = ios.read(buffer)) != -1) {
                ous.write(buffer, 0, read);
            }
            ret = ous.toByteArray();
        }
        finally {
            if (ous != null) {
                ous.close();
            }
            if (ios != null) {
                ios.close();
            }
        }
        return ret;
    }
}

