/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.infostore.actions.DeleteInfostoreRequest;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.ajax.share.actions.ResolveShareResponse;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageGuestObjectPermission;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.recipient.RecipientType;
import java.util.Collections;
import java.util.Date;

public class RemoveGuestPermissionTest
extends ShareTest {
    public RemoveGuestPermissionTest(String name) {
        super(name);
    }

    public void testUpdateSharedFolderRandomly() throws Exception {
        int module = RemoveGuestPermissionTest.randomModule();
        this.testUpdateSharedFolder(RemoveGuestPermissionTest.randomFolderAPI(), module, RemoveGuestPermissionTest.randomGuestPermission(module));
    }

    public void testDeleteSharedFolderRandomly() throws Exception {
        int module = RemoveGuestPermissionTest.randomModule();
        this.testDeleteSharedFolder(RemoveGuestPermissionTest.randomFolderAPI(), module, this.getDefaultFolder(module), RemoveGuestPermissionTest.randomGuestPermission(module), false);
    }

    public void testHardDeleteSharedFolderRandomly() throws Exception {
        int module = RemoveGuestPermissionTest.randomModule();
        this.testDeleteSharedFolder(RemoveGuestPermissionTest.randomFolderAPI(), module, this.getDefaultFolder(module), RemoveGuestPermissionTest.randomGuestPermission(module), true);
    }

    public void noTestUpdateSharedFolderExtensively() throws Exception {
        for (EnumAPI api : TESTED_FOLDER_APIS) {
            for (OCLGuestPermission guestPermission : TESTED_PERMISSIONS) {
                for (int module : TESTED_MODULES) {
                    this.testUpdateSharedFolder(api, module, guestPermission);
                }
            }
        }
    }

    public void testUpdateSharedFileRandomly() throws Exception {
        this.testUpdateSharedFile(RemoveGuestPermissionTest.randomFolderAPI(), RemoveGuestPermissionTest.randomGuestObjectPermission());
    }

    public void testDeleteSharedFileRandomly() throws Exception {
        this.testDeleteSharedFile(RemoveGuestPermissionTest.randomFolderAPI(), this.getDefaultFolder(8), RemoveGuestPermissionTest.randomGuestObjectPermission(), false);
    }

    public void testHardDeleteSharedFileRandomly() throws Exception {
        this.testDeleteSharedFile(RemoveGuestPermissionTest.randomFolderAPI(), this.getDefaultFolder(8), RemoveGuestPermissionTest.randomGuestObjectPermission(), true);
    }

    public void noTestUpdateSharedFileExtensively() throws Exception {
        for (FileStorageGuestObjectPermission guestPermission : TESTED_OBJECT_PERMISSIONS) {
            this.testUpdateSharedFile(RemoveGuestPermissionTest.randomFolderAPI(), guestPermission);
        }
    }

    private void testUpdateSharedFolder(EnumAPI api, int module, OCLGuestPermission guestPermission) throws Exception {
        this.testUpdateSharedFolder(api, module, this.getDefaultFolder(module), guestPermission);
    }

    private void testUpdateSharedFolder(EnumAPI api, int module, int parent, OCLGuestPermission guestPermission) throws Exception {
        FolderObject folder = this.insertSharedFolder(api, module, parent, guestPermission);
        OCLPermission matchingPermission = null;
        for (OCLPermission permission : folder.getPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        RemoveGuestPermissionTest.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        RemoveGuestPermissionTest.checkPermissions(guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(api, module, folder.getObjectID(), matchingPermission.getEntity());
        RemoveGuestPermissionTest.checkGuestPermission(guestPermission, guest);
        GuestClient guestClient = this.resolveShare(guest, guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        guestClient.checkShareAccessible(guestPermission);
        folder.getPermissions().remove(matchingPermission);
        folder = this.updateFolder(api, folder);
        for (OCLPermission permission : folder.getPermissions()) {
            RemoveGuestPermissionTest.assertTrue((String)"Guest permission still present", (permission.getEntity() != matchingPermission.getEntity() ? 1 : 0) != 0);
        }
        if (RecipientType.ANONYMOUS.equals((Object)guestPermission.getRecipient().getType())) {
            this.checkGuestUserDeleted(matchingPermission.getEntity());
            guestClient.checkSessionAlive(true);
            GuestClient revokedGuestClient = new GuestClient(guest.getShareURL(), guestPermission.getRecipient(), false);
            ResolveShareResponse shareResolveResponse = revokedGuestClient.getShareResolveResponse();
            RemoveGuestPermissionTest.assertEquals((String)"Status wrong", (String)"not_found", (String)shareResolveResponse.getStatus());
        } else {
            guestClient.checkFolderNotAccessible(String.valueOf(folder.getObjectID()));
            guestClient.logout();
        }
        guest = this.discoverGuestEntity(api, module, folder.getObjectID(), matchingPermission.getEntity());
        RemoveGuestPermissionTest.assertNull((String)"guest entity still found", (Object)guest);
    }

    private void testDeleteSharedFolder(EnumAPI api, int module, int parent, OCLGuestPermission guestPermission, boolean hardDelete) throws Exception {
        FolderObject folder = this.insertSharedFolder(api, module, parent, guestPermission);
        OCLPermission matchingPermission = null;
        for (OCLPermission permission : folder.getPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        RemoveGuestPermissionTest.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        RemoveGuestPermissionTest.checkPermissions(guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(api, module, folder.getObjectID(), matchingPermission.getEntity());
        RemoveGuestPermissionTest.checkGuestPermission(guestPermission, guest);
        GuestClient guestClient = this.resolveShare(guest, guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        guestClient.checkShareAccessible(guestPermission);
        DeleteRequest deleteRequest = new DeleteRequest((API)api, folder.getObjectID(), folder.getLastModified());
        if (hardDelete) {
            deleteRequest.setHardDelete(Boolean.TRUE);
        }
        this.client.execute(deleteRequest);
        if (RecipientType.ANONYMOUS.equals((Object)guestPermission.getRecipient().getType())) {
            this.checkGuestUserDeleted(matchingPermission.getEntity());
            guestClient.checkSessionAlive(true);
            GuestClient revokedGuestClient = new GuestClient(guest.getShareURL(), guestPermission.getRecipient(), false);
            ResolveShareResponse shareResolveResponse = revokedGuestClient.getShareResolveResponse();
            RemoveGuestPermissionTest.assertEquals((String)"Status wrong", (String)"not_found", (String)shareResolveResponse.getStatus());
        } else {
            guestClient.checkFolderNotAccessible(String.valueOf(folder.getObjectID()));
            guestClient.logout();
        }
        guest = this.discoverGuestEntity(api, module, folder.getObjectID(), matchingPermission.getEntity());
        RemoveGuestPermissionTest.assertNull((String)"guest entity still found", (Object)guest);
    }

    private void testUpdateSharedFile(EnumAPI api, FileStorageGuestObjectPermission guestPermission) throws Exception {
        this.testUpdateSharedFile(api, this.getDefaultFolder(8), guestPermission);
    }

    private void testUpdateSharedFile(EnumAPI api, int parent, FileStorageGuestObjectPermission guestPermission) throws Exception {
        FolderObject folder = this.insertPrivateFolder(api, 8, parent);
        File file = this.insertSharedFile(folder.getObjectID(), (FileStorageObjectPermission)guestPermission);
        FileStorageObjectPermission matchingPermission = null;
        for (FileStorageObjectPermission permission : file.getObjectPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        RemoveGuestPermissionTest.assertNotNull((String)"No matching permission in created file found", matchingPermission);
        RemoveGuestPermissionTest.checkPermissions((FileStorageObjectPermission)guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(file.getFolderId(), file.getId(), matchingPermission.getEntity());
        RemoveGuestPermissionTest.checkGuestPermission((FileStorageObjectPermission)guestPermission, guest);
        GuestClient guestClient = this.resolveShare(guest, guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        guestClient.checkShareAccessible(guestPermission);
        Date futureTimestamp = new Date(System.currentTimeMillis() + 1000000L);
        file.setLastModified(futureTimestamp);
        file.setObjectPermissions(Collections.emptyList());
        file = this.updateFile(file, new File.Field[]{File.Field.OBJECT_PERMISSIONS});
        RemoveGuestPermissionTest.assertTrue((String)"object permissions still present", (null == file.getObjectPermissions() || 0 == file.getObjectPermissions().size() ? 1 : 0) != 0);
        if (RecipientType.ANONYMOUS.equals((Object)guestPermission.getRecipient().getType())) {
            this.checkGuestUserDeleted(matchingPermission.getEntity());
            guestClient.checkSessionAlive(true);
            GuestClient revokedGuestClient = new GuestClient(guest.getShareURL(), guestPermission.getRecipient(), false);
            ResolveShareResponse shareResolveResponse = revokedGuestClient.getShareResolveResponse();
            RemoveGuestPermissionTest.assertEquals((String)"Status wrong", (String)"not_found", (String)shareResolveResponse.getStatus());
        } else {
            guestClient.checkFileNotAccessible(file.getId());
            guestClient.logout();
        }
        guest = this.discoverGuestEntity(file.getFolderId(), file.getId(), matchingPermission.getEntity());
        RemoveGuestPermissionTest.assertNull((String)"guest entity still found", (Object)guest);
    }

    private void testDeleteSharedFile(EnumAPI api, int parent, FileStorageGuestObjectPermission guestPermission, boolean hardDelete) throws Exception {
        FolderObject folder = this.insertPrivateFolder(api, 8, parent);
        File file = this.insertSharedFile(folder.getObjectID(), (FileStorageObjectPermission)guestPermission);
        FileStorageObjectPermission matchingPermission = null;
        for (FileStorageObjectPermission permission : file.getObjectPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        RemoveGuestPermissionTest.assertNotNull((String)"No matching permission in created file found", matchingPermission);
        RemoveGuestPermissionTest.checkPermissions((FileStorageObjectPermission)guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(file.getFolderId(), file.getId(), matchingPermission.getEntity());
        RemoveGuestPermissionTest.checkGuestPermission((FileStorageObjectPermission)guestPermission, guest);
        GuestClient guestClient = this.resolveShare(guest, guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        guestClient.checkShareAccessible(guestPermission);
        Date futureTimestamp = new Date(System.currentTimeMillis() + 1000000L);
        DeleteInfostoreRequest deleteInfostoreRequest = new DeleteInfostoreRequest(file.getId(), file.getFolderId(), futureTimestamp);
        if (hardDelete) {
            deleteInfostoreRequest.setHardDelete(Boolean.TRUE);
        }
        this.getClient().execute(deleteInfostoreRequest);
        if (RecipientType.ANONYMOUS.equals((Object)guestPermission.getRecipient().getType())) {
            this.checkGuestUserDeleted(matchingPermission.getEntity());
            guestClient.checkSessionAlive(true);
            GuestClient revokedGuestClient = new GuestClient(guest.getShareURL(), guestPermission.getRecipient(), false);
            ResolveShareResponse shareResolveResponse = revokedGuestClient.getShareResolveResponse();
            RemoveGuestPermissionTest.assertEquals((String)"Status wrong", (String)"not_found", (String)shareResolveResponse.getStatus());
        } else {
            guestClient.checkFileNotAccessible(file.getId());
            guestClient.logout();
        }
        guest = this.discoverGuestEntity(file.getFolderId(), file.getId(), matchingPermission.getEntity());
        RemoveGuestPermissionTest.assertNull((String)"guest entity still found", (Object)guest);
    }
}

