/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.NotifyFolderRequest;
import com.openexchange.ajax.smtptest.actions.GetMailsRequest;
import com.openexchange.ajax.smtptest.actions.GetMailsResponse;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.recipient.GuestRecipient;
import com.openexchange.share.recipient.RecipientType;

public class NotifyFolderSharesTest
extends ShareTest {
    public NotifyFolderSharesTest(String name) {
        super(name);
    }

    public void testNotifyGuest() throws Exception {
        int module = NotifyFolderSharesTest.randomModule();
        this.testNotifyGuest(module, this.getDefaultFolder(module));
        this.testNotifyGuest(module, NotifyFolderSharesTest.getPublicRoot(module));
    }

    public void testNotifyGroup() throws Exception {
        int module = NotifyFolderSharesTest.randomModule();
        this.testNotifyGroup(module, this.getDefaultFolder(module));
        this.testNotifyGroup(module, NotifyFolderSharesTest.getPublicRoot(module));
    }

    public void testNotifyUser() throws Exception {
        int module = NotifyFolderSharesTest.randomModule();
        this.testNotifyUser(module, this.getDefaultFolder(module));
        this.testNotifyUser(module, NotifyFolderSharesTest.getPublicRoot(module));
    }

    private void testNotifyGuest(int module, int parent) throws Exception {
        OCLGuestPermission guestPermission = NotifyFolderSharesTest.randomGuestPermission(RecipientType.GUEST, module);
        String emailAddress = ((GuestRecipient)guestPermission.getRecipient()).getEmailAddress();
        this.testNotify(module, parent, guestPermission, emailAddress);
    }

    private void testNotifyGroup(int module, int parent) throws Exception {
        OCLPermission permission = new OCLPermission(0, 0);
        permission.setAllPermission(4, 4, 4, 4);
        permission.setGroupPermission(true);
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        String emailAddress = client2.getValues().getDefaultAddress();
        client2.logout();
        this.testNotify(module, parent, permission, emailAddress);
    }

    private void testNotifyUser(int module, int parent) throws Exception {
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        int userId = client2.getValues().getUserId();
        String emailAddress = client2.getValues().getDefaultAddress();
        client2.logout();
        OCLPermission permission = new OCLPermission(userId, 0);
        permission.setAllPermission(4, 4, 0, 0);
        this.testNotify(module, parent, permission, emailAddress);
    }

    private void testNotify(int module, int parent, OCLPermission permission, String emailAddress) throws Exception {
        FolderObject folder = this.insertSharedFolder(EnumAPI.OX_NEW, module, parent, permission);
        OCLPermission matchingPermission = null;
        for (OCLPermission oclPermission : folder.getPermissions()) {
            if (oclPermission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = oclPermission;
            break;
        }
        NotifyFolderSharesTest.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        NotifyFolderSharesTest.checkPermissions(permission, matchingPermission);
        this.client.execute(new GetMailsRequest());
        this.client.execute(new NotifyFolderRequest(String.valueOf(folder.getObjectID()), matchingPermission.getEntity()));
        GetMailsResponse.Message notificationMessage = this.discoverInvitationMessage(this.client, emailAddress);
        NotifyFolderSharesTest.assertNotNull((Object)notificationMessage);
    }
}

