/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.passwordchange.actions.PasswordChangeUpdateRequest;
import com.openexchange.ajax.passwordchange.actions.PasswordChangeUpdateResponse;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.ajax.share.actions.GetLinkRequest;
import com.openexchange.ajax.share.actions.ResolveShareResponse;
import com.openexchange.ajax.share.actions.ShareLink;
import com.openexchange.ajax.share.actions.UpdateLinkRequest;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.modules.Module;
import com.openexchange.java.util.UUIDs;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.ShareTarget;
import java.util.Collections;

public class LoginScreenTest
extends ShareTest {
    private FolderObject folder;

    public LoginScreenTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.folder = this.insertPrivateFolder(EnumAPI.OX_NEW, Module.INFOSTORE.getFolderConstant(), this.client.getValues().getPrivateInfostoreFolder());
    }

    @Override
    public void tearDown() throws Exception {
        LoginScreenTest.deleteFoldersSilently(this.client, Collections.singletonList(this.folder.getObjectID()));
        super.tearDown();
    }

    public void testGuestWithPassword() throws Exception {
        long now = System.currentTimeMillis();
        OCLGuestPermission perm = LoginScreenTest.createNamedGuestPermission("testGuestPasswordInit" + now + "@example.org", "Test " + now);
        this.folder.getPermissions().add(perm);
        this.folder = this.updateFolder(EnumAPI.OX_NEW, this.folder);
        OCLPermission matchingPermission = null;
        for (OCLPermission permission : this.folder.getPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        LoginScreenTest.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        LoginScreenTest.checkPermissions(perm, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(EnumAPI.OX_NEW, Module.INFOSTORE.getFolderConstant(), this.folder.getObjectID(), matchingPermission.getEntity());
        LoginScreenTest.checkGuestPermission(perm, guest);
        String shareURL = this.discoverShareURL(guest);
        GuestClient guestClient = this.resolveShare(shareURL);
        String newPW = UUIDs.getUnformattedStringFromRandom();
        PasswordChangeUpdateRequest pwChangeReq = new PasswordChangeUpdateRequest(newPW, "", true);
        PasswordChangeUpdateResponse pwChangeResp = guestClient.execute(pwChangeReq);
        LoginScreenTest.assertFalse((boolean)pwChangeResp.hasWarnings());
        LoginScreenTest.assertFalse((boolean)pwChangeResp.hasError());
        guestClient.logout();
        guestClient = this.resolveShare(shareURL, ShareTest.getUsername(perm.getRecipient()), newPW);
        ResolveShareResponse resolveResponse = guestClient.getShareResolveResponse();
        LoginScreenTest.assertEquals((String)"guest_password", (String)resolveResponse.getLoginType());
        LoginScreenTest.assertEquals((String)"INFO", (String)resolveResponse.getMessageType());
        LoginScreenTest.assertNotNull((Object)resolveResponse.getMessage());
    }

    public void testLinkWithPassword() throws Exception {
        ShareTarget target = new ShareTarget(this.folder.getModule(), Integer.toString(this.folder.getObjectID()));
        ShareLink shareLink = this.client.execute(new GetLinkRequest(target)).getShareLink();
        LoginScreenTest.assertTrue((boolean)shareLink.isNew());
        UpdateLinkRequest updateLinkRequest = new UpdateLinkRequest(target, System.currentTimeMillis());
        String newPW = UUIDs.getUnformattedStringFromRandom();
        updateLinkRequest.setPassword(newPW);
        this.client.execute(updateLinkRequest);
        GuestClient guestClient = this.resolveShare(shareLink.getShareURL(), null, newPW);
        guestClient.checkSessionAlive(false);
        ResolveShareResponse resolveResponse = guestClient.getShareResolveResponse();
        LoginScreenTest.assertEquals((String)"anonymous_password", (String)resolveResponse.getLoginType());
        LoginScreenTest.assertEquals((String)"INFO", (String)resolveResponse.getMessageType());
        LoginScreenTest.assertNotNull((Object)resolveResponse.getMessage());
    }
}

