/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.passwordchange.actions.PasswordChangeUpdateRequest;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.recipient.GuestRecipient;

public class GuestPasswordTest
extends ShareTest {
    public GuestPasswordTest(String name) {
        super(name);
    }

    public void testUpdatePasswordForNamedGuest() throws Exception {
        OCLGuestPermission guestPermission = GuestPasswordTest.createNamedGuestPermission(GuestPasswordTest.randomUID() + "@example.com", "Test Guest", "secret");
        int module = GuestPasswordTest.randomModule();
        EnumAPI api = GuestPasswordTest.randomFolderAPI();
        FolderObject folder = this.insertSharedFolder(api, module, this.getDefaultFolder(module), guestPermission);
        OCLPermission matchingPermission = null;
        for (OCLPermission permission : folder.getPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        GuestPasswordTest.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        GuestPasswordTest.checkPermissions(guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(api, module, folder.getObjectID(), matchingPermission.getEntity());
        GuestPasswordTest.checkGuestPermission(guestPermission, guest);
        String shareURL = this.discoverShareURL(guest);
        GuestClient guestClient = this.resolveShare(shareURL, guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        String newPassword = "secret2";
        PasswordChangeUpdateRequest updateRequest = new PasswordChangeUpdateRequest(newPassword, ((GuestRecipient)guestPermission.getRecipient()).getPassword(), true);
        guestClient.execute(updateRequest);
        GuestClient revokedGuestClient = new GuestClient(shareURL, guestPermission.getRecipient(), false);
        GuestPasswordTest.assertTrue((String)"No errors during login with old password", (boolean)revokedGuestClient.getLoginResponse().hasError());
        GuestPasswordTest.assertNull((String)"Got session ID from login with old password", (Object)revokedGuestClient.getLoginResponse().getSessionId());
        guestClient = this.resolveShare(shareURL, ((GuestRecipient)guestPermission.getRecipient()).getEmailAddress(), newPassword);
        guestClient.checkShareModuleAvailable();
    }
}

