/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.ajax.share.actions.FolderShare;
import com.openexchange.ajax.share.actions.ResolveShareResponse;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class FolderTransactionTest
extends ShareTest {
    public FolderTransactionTest(String name) {
        super(name);
    }

    public void testDontCreateShareOnFailingFolderCreate() throws Exception {
        for (EnumAPI api : TESTED_FOLDER_APIS) {
            for (int module : TESTED_MODULES) {
                this.testDontCreateShareOnFailingFolderCreate(api, module);
            }
        }
    }

    public void testDontCreateShareOnFailingFolderCreate(EnumAPI api, int module) throws Exception {
        FolderObject parent = this.getFolder(api, this.getDefaultFolder(module));
        FolderObject folder = this.insertPrivateFolder(api, module, parent.getObjectID());
        List<FolderShare> oldShares = this.getFolderShares(api, module);
        boolean insertionFailed = false;
        try {
            this.insertSharedFolder(api, module, parent.getObjectID(), folder.getFolderName(), FolderTransactionTest.createAnonymousGuestPermission());
        }
        catch (Throwable e) {
            insertionFailed = true;
        }
        FolderTransactionTest.assertTrue((String)("API: " + api + ", Module: " + module), (boolean)insertionFailed);
        List<FolderShare> newShares = this.getFolderShares(api, module);
        FolderTransactionTest.assertEquals((String)("The number of shares differs but should not. API: " + api + ", Module: " + module), (int)oldShares.size(), (int)newShares.size());
    }

    public void testDontCreateShareOnFailingFolderUpdate() throws Exception {
        for (EnumAPI api : TESTED_FOLDER_APIS) {
            for (int module : TESTED_MODULES) {
                this.testDontCreateShareOnFailingFolderUpdate(api, module);
            }
        }
    }

    public void testDontCreateShareOnFailingFolderUpdate(EnumAPI api, int module) throws Exception {
        FolderObject parent = this.getFolder(api, this.getDefaultFolder(module));
        FolderObject sharedFolder = this.insertPrivateFolder(api, module, parent.getObjectID());
        List<FolderShare> oldShares = this.getFolderShares(api, module);
        OCLGuestPermission guestPermission = FolderTransactionTest.createAnonymousGuestPermission();
        ArrayList<OCLGuestPermission> permissions = new ArrayList<OCLGuestPermission>(sharedFolder.getPermissions());
        permissions.add(guestPermission);
        sharedFolder.setPermissions(permissions);
        sharedFolder.setLastModified(new Date(sharedFolder.getLastModified().getTime() - 1000L));
        boolean updateFailed = false;
        try {
            this.updateFolder(api, sharedFolder);
        }
        catch (Throwable e) {
            updateFailed = true;
        }
        FolderTransactionTest.assertTrue((String)("API: " + api + ", Module: " + module), (boolean)updateFailed);
        List<FolderShare> newShares = this.getFolderShares(api, module);
        FolderTransactionTest.assertEquals((String)("The number of shares differs but should not.API: " + api + ", Module: " + module), (int)oldShares.size(), (int)newShares.size());
    }

    public void testDontRemoveSharesOnFailingFolderUpdate() throws Exception {
        for (EnumAPI api : TESTED_FOLDER_APIS) {
            for (int module : TESTED_MODULES) {
                this.testDontRemoveSharesOnFailingFolderUpdate(api, module);
            }
        }
    }

    public void testDontRemoveSharesOnFailingFolderUpdate(EnumAPI api, int module) throws Exception {
        FolderObject parent = this.getFolder(api, this.getDefaultFolder(module));
        OCLGuestPermission guestPermission = FolderTransactionTest.createAnonymousGuestPermission();
        FolderObject sharedFolder = this.insertSharedFolder(api, module, parent.getObjectID(), guestPermission);
        OCLPermission matchingPermission = null;
        for (OCLPermission permission : sharedFolder.getPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        FolderTransactionTest.assertNotNull((String)("No matching permission in created folder found.API: " + api + ", Module: " + module), (Object)matchingPermission);
        FolderTransactionTest.checkPermissions(guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(api, module, sharedFolder.getObjectID(), matchingPermission.getEntity());
        FolderTransactionTest.assertNotNull((String)("API: " + api + ", Module: " + module), (Object)guest);
        String shareURL = this.discoverShareURL(guest);
        sharedFolder.setPermissionsAsArray(new OCLPermission[0]);
        boolean updateFailed = false;
        try {
            this.updateFolder(api, sharedFolder);
        }
        catch (Throwable e) {
            updateFailed = true;
        }
        FolderTransactionTest.assertTrue((String)("API: " + api + ", Module: " + module), (boolean)updateFailed);
        GuestClient guestClient = new GuestClient(shareURL, guestPermission.getRecipient());
        ResolveShareResponse resolveResponse = guestClient.getShareResolveResponse();
        FolderTransactionTest.assertEquals((String)("API: " + api + ", Module: " + module), (String)Integer.toString(sharedFolder.getObjectID()), (String)resolveResponse.getFolder());
    }
}

