/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageGuestObjectPermission;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.groupware.container.FolderObject;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;

public class DownloadHandlerTest
extends ShareTest {
    public DownloadHandlerTest(String name) {
        super(name);
    }

    public void testDownloadSharedFileRandomly() throws Exception {
        this.testDownloadSharedFile(DownloadHandlerTest.randomFolderAPI(), DownloadHandlerTest.randomGuestObjectPermission());
    }

    public void noTestDownloadSharedFileExtensively() throws Exception {
        for (FileStorageGuestObjectPermission guestPermission : TESTED_OBJECT_PERMISSIONS) {
            this.testDownloadSharedFile(EnumAPI.OX_NEW, guestPermission);
        }
    }

    private void testDownloadSharedFile(EnumAPI api, FileStorageGuestObjectPermission guestPermission) throws Exception {
        this.testDownloadSharedFile(api, this.getDefaultFolder(8), guestPermission);
    }

    private void testDownloadSharedFile(EnumAPI api, int parent, FileStorageGuestObjectPermission guestPermission) throws Exception {
        byte[] downloadedFile;
        HttpEntity entity;
        Header disposition;
        HttpResponse httpResponse;
        HttpGet httpGet;
        byte[] contents = new byte[64 + random.nextInt(256)];
        random.nextBytes(contents);
        String filename = DownloadHandlerTest.randomUID();
        FolderObject folder = this.insertPrivateFolder(api, 8, parent);
        File file = this.insertSharedFile(folder.getObjectID(), filename, (FileStorageObjectPermission)guestPermission, contents);
        FileStorageObjectPermission matchingPermission = null;
        for (FileStorageObjectPermission permission : file.getObjectPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        DownloadHandlerTest.assertNotNull((String)"No matching permission in created file found", matchingPermission);
        DownloadHandlerTest.checkPermissions((FileStorageObjectPermission)guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(file.getFolderId(), file.getId(), matchingPermission.getEntity());
        DownloadHandlerTest.checkGuestPermission((FileStorageObjectPermission)guestPermission, guest);
        String shareURL = this.discoverShareURL(guest);
        GuestClient guestClient = this.resolveShare(shareURL, guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        guestClient.checkShareAccessible(guestPermission);
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        String password = DownloadHandlerTest.getPassword(guestPermission.getRecipient());
        if (null != password) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(DownloadHandlerTest.getUsername(guestPermission.getRecipient()), DownloadHandlerTest.getPassword(guestPermission.getRecipient()));
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            httpClient.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        for (String queryParameter : new String[]{"delivery=download", "dl=1", "dl=true"}) {
            httpGet = new HttpGet(shareURL + '?' + queryParameter);
            httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            DownloadHandlerTest.assertEquals((String)"Wrong HTTP status", (int)200, (int)httpResponse.getStatusLine().getStatusCode());
            disposition = httpResponse.getFirstHeader("Content-Disposition");
            DownloadHandlerTest.assertTrue((String)"Wrong content disposition", (null != disposition && null != disposition.getValue() && disposition.getValue().startsWith("attachment") ? 1 : 0) != 0);
            entity = httpResponse.getEntity();
            DownloadHandlerTest.assertNotNull((String)"No file downloaded", (Object)entity);
            downloadedFile = EntityUtils.toByteArray((HttpEntity)entity);
            Assert.assertArrayEquals((String)"Different contents downloaded", (byte[])contents, (byte[])downloadedFile);
        }
        for (String queryParameter : new String[]{"delivery=view", "raw=1", "raw=true"}) {
            httpGet = new HttpGet(shareURL + '?' + queryParameter);
            httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            DownloadHandlerTest.assertEquals((String)"Wrong HTTP status", (int)200, (int)httpResponse.getStatusLine().getStatusCode());
            disposition = httpResponse.getFirstHeader("Content-Disposition");
            DownloadHandlerTest.assertTrue((String)"Wrong content disposition", (null != disposition && null != disposition.getValue() && disposition.getValue().startsWith("inline") ? 1 : 0) != 0);
            entity = httpResponse.getEntity();
            DownloadHandlerTest.assertNotNull((String)"No file downloaded", (Object)entity);
            downloadedFile = EntityUtils.toByteArray((HttpEntity)entity);
            Assert.assertArrayEquals((String)"Different contents downloaded", (byte[])contents, (byte[])downloadedFile);
        }
    }
}

