/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.DefaultFileStorageObjectPermission;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageGuestObjectPermission;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.recipient.AnonymousRecipient;
import com.openexchange.share.recipient.ShareRecipient;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AnonymousGuestTest
extends ShareTest {
    private FolderObject folder;
    private File file;

    public AnonymousGuestTest(String name) {
        super(name);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.folder = this.insertPrivateFolder(EnumAPI.OX_NEW, 8, this.client.getValues().getPrivateInfostoreFolder());
        this.remember(this.folder);
        this.file = this.insertFile(this.folder.getObjectID());
        this.remember(this.file);
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testAddAnonymousGuestToFolder() throws Exception {
        OCLGuestPermission guestPermission = AnonymousGuestTest.createAnonymousGuestPermission();
        FolderObject updated = this.addPermissions(this.folder, guestPermission);
        OCLPermission matchingPermission = this.findAndCheckPermission(updated);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(EnumAPI.OX_NEW, 8, this.folder.getObjectID(), matchingPermission.getEntity());
        AnonymousGuestTest.checkGuestPermission(guestPermission, guest);
        GuestClient guestClient = this.resolveShare(guest, guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        guestClient.checkShareAccessible(guestPermission);
    }

    @Test
    public void testAddAnonymousGuestWithInvalidPermissionToFolder() throws Exception {
        OCLGuestPermission guestPermission = AnonymousGuestTest.createInvalidAnonymousGuestPermission();
        FolderObject updated = this.addPermissions(this.folder, guestPermission);
        OCLPermission matchingPermission = this.findAndCheckPermission(updated);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(EnumAPI.OX_NEW, 8, this.folder.getObjectID(), matchingPermission.getEntity());
        AnonymousGuestTest.checkGuestPermission(guestPermission, guest);
        GuestClient guestClient = this.resolveShare(guest, guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        guestClient.checkShareAccessible(guestPermission);
    }

    @Test
    public void testAddTwoAnonymousGuestsToFolder() throws Exception {
        OCLGuestPermission guestPermission1 = AnonymousGuestTest.createAnonymousGuestPermission();
        OCLGuestPermission guestPermission2 = AnonymousGuestTest.createAnonymousGuestPermission();
        boolean thrown = false;
        try {
            this.addPermissions(this.folder, guestPermission1, guestPermission2);
        }
        catch (AssertionError e) {
            AnonymousGuestTest.assertTrue((boolean)((Throwable)((Object)e)).getMessage().contains("PERMISSION_DENIED"));
            thrown = true;
        }
        AnonymousGuestTest.assertTrue((boolean)thrown);
    }

    @Test
    public void testAddTwoAnonymousGuestsSubsequentlyToFolder() throws Exception {
        OCLGuestPermission guestPermission1 = AnonymousGuestTest.createAnonymousGuestPermission();
        FolderObject updated = this.addPermissions(this.folder, guestPermission1);
        OCLGuestPermission guestPermission2 = AnonymousGuestTest.createAnonymousGuestPermission();
        boolean thrown = false;
        try {
            this.addPermissions(updated, guestPermission2);
        }
        catch (AssertionError e) {
            Assert.assertTrue((boolean)((Throwable)((Object)e)).getMessage().contains("PERMISSION_DENIED"));
            thrown = true;
        }
        AnonymousGuestTest.assertTrue((boolean)thrown);
    }

    @Test
    public void testAddExistingAnonymousGuestToNewFolder() throws Exception {
        OCLGuestPermission guestPermission = AnonymousGuestTest.createAnonymousGuestPermission();
        FolderObject updated = this.addPermissions(this.folder, guestPermission);
        OCLPermission entityPermission = this.findAndCheckPermission(updated);
        FolderObject newFolder = this.insertPrivateFolder(EnumAPI.OX_NEW, 8, this.client.getValues().getPrivateInfostoreFolder());
        this.remember(newFolder);
        boolean thrown = false;
        try {
            this.addPermissions(newFolder, entityPermission);
        }
        catch (AssertionError e) {
            Assert.assertTrue((boolean)((Throwable)((Object)e)).getMessage().contains("PERMISSION_DENIED"));
            thrown = true;
        }
        AnonymousGuestTest.assertTrue((boolean)thrown);
    }

    @Test
    public void testUpdateAnonymousGuestPermissionToWritableOnFolder() throws Exception {
        OCLGuestPermission guestPermission = AnonymousGuestTest.createAnonymousGuestPermission();
        FolderObject updated = this.addPermissions(this.folder, guestPermission);
        OCLPermission entityPermission = this.findAndCheckPermission(updated);
        entityPermission.setAllPermission(4, 4, 4, 4);
        boolean thrown = false;
        try {
            this.updateFolder(EnumAPI.OX_NEW, updated);
        }
        catch (AssertionError e) {
            Assert.assertTrue((boolean)((Throwable)((Object)e)).getMessage().contains("PERMISSION_DENIED"));
            thrown = true;
        }
        AnonymousGuestTest.assertTrue((boolean)thrown);
    }

    @Test
    public void testAddAnonymousGuestToFile() throws Exception {
        FileStorageGuestObjectPermission guestPermission = AnonymousGuestTest.asObjectPermission(AnonymousGuestTest.createAnonymousGuestPermission());
        File updated = this.addPermissions(this.file, new FileStorageObjectPermission[]{guestPermission});
        FileStorageObjectPermission matchingPermission = this.findAndCheckPermission(updated);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(this.file.getFolderId(), this.file.getId(), matchingPermission.getEntity());
        AnonymousGuestTest.checkGuestPermission((FileStorageObjectPermission)guestPermission, guest);
        GuestClient guestClient = this.resolveShare(guest, guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        guestClient.checkShareAccessible(guestPermission);
    }

    @Test
    public void testAddAnonymousGuestWithInvalidPermissionToFile() throws Exception {
        FileStorageGuestObjectPermission guestPermission = AnonymousGuestTest.asObjectPermission(AnonymousGuestTest.createInvalidAnonymousGuestPermission());
        File updated = this.addPermissions(this.file, new FileStorageObjectPermission[]{guestPermission});
        FileStorageObjectPermission matchingPermission = this.findAndCheckPermission(updated);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(this.file.getFolderId(), this.file.getId(), matchingPermission.getEntity());
        AnonymousGuestTest.checkGuestPermission((FileStorageObjectPermission)guestPermission, guest);
        GuestClient guestClient = this.resolveShare(guest, guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        guestClient.checkShareAccessible(guestPermission);
    }

    @Test
    public void testAddTwoAnonymousGuestsToFile() throws Exception {
        FileStorageGuestObjectPermission guestPermission1 = AnonymousGuestTest.asObjectPermission(AnonymousGuestTest.createAnonymousGuestPermission());
        FileStorageGuestObjectPermission guestPermission2 = AnonymousGuestTest.asObjectPermission(AnonymousGuestTest.createAnonymousGuestPermission());
        boolean thrown = false;
        try {
            this.addPermissions(this.file, new FileStorageObjectPermission[]{guestPermission1, guestPermission2});
        }
        catch (AssertionError e) {
            AnonymousGuestTest.assertTrue((boolean)((Throwable)((Object)e)).getMessage().contains("PERMISSION_DENIED"));
            thrown = true;
        }
        AnonymousGuestTest.assertTrue((boolean)thrown);
    }

    @Test
    public void testAddTwoAnonymousGuestsSubsequentlyToFile() throws Exception {
        FileStorageGuestObjectPermission guestPermission1 = AnonymousGuestTest.asObjectPermission(AnonymousGuestTest.createAnonymousGuestPermission());
        File updated = this.addPermissions(this.file, new FileStorageObjectPermission[]{guestPermission1});
        FileStorageGuestObjectPermission guestPermission2 = AnonymousGuestTest.asObjectPermission(AnonymousGuestTest.createAnonymousGuestPermission());
        boolean thrown = false;
        try {
            this.addPermissions(updated, new FileStorageObjectPermission[]{guestPermission2});
        }
        catch (AssertionError e) {
            Assert.assertTrue((boolean)((Throwable)((Object)e)).getMessage().contains("PERMISSION_DENIED"));
            thrown = true;
        }
        AnonymousGuestTest.assertTrue((boolean)thrown);
    }

    @Test
    public void testAddExistingAnonymousGuestToNewFile() throws Exception {
        FileStorageGuestObjectPermission guestPermission = AnonymousGuestTest.asObjectPermission(AnonymousGuestTest.createAnonymousGuestPermission());
        File updated = this.addPermissions(this.file, new FileStorageObjectPermission[]{guestPermission});
        FileStorageObjectPermission entityPermission = this.findAndCheckPermission(updated);
        File newFile = this.insertFile(this.client.getValues().getPrivateInfostoreFolder());
        this.remember(newFile);
        boolean thrown = false;
        try {
            this.addPermissions(newFile, entityPermission);
        }
        catch (AssertionError e) {
            Assert.assertTrue((boolean)((Throwable)((Object)e)).getMessage().contains("PERMISSION_DENIED"));
            thrown = true;
        }
        AnonymousGuestTest.assertTrue((boolean)thrown);
    }

    @Test
    public void testUpdateAnonymousGuestPermissionToWritableOnFile() throws Exception {
        FileStorageGuestObjectPermission guestPermission = AnonymousGuestTest.asObjectPermission(AnonymousGuestTest.createAnonymousGuestPermission());
        File updated = this.addPermissions(this.file, new FileStorageObjectPermission[]{guestPermission});
        FileStorageObjectPermission entityPermission = this.findAndCheckPermission(updated);
        ArrayList<DefaultFileStorageObjectPermission> newPermissions = new ArrayList<DefaultFileStorageObjectPermission>(2);
        newPermissions.addAll(updated.getObjectPermissions());
        newPermissions.remove(entityPermission);
        newPermissions.add(new DefaultFileStorageObjectPermission(entityPermission.getEntity(), false, 4));
        DefaultFile toUpdate = new DefaultFile();
        toUpdate.setId(this.file.getId());
        toUpdate.setFolderId(this.file.getFolderId());
        toUpdate.setLastModified(this.file.getLastModified());
        toUpdate.setObjectPermissions(newPermissions);
        boolean thrown = false;
        try {
            this.updateFile((File)toUpdate, new File.Field[]{File.Field.OBJECT_PERMISSIONS});
        }
        catch (AssertionError e) {
            Assert.assertTrue((boolean)((Throwable)((Object)e)).getMessage().contains("PERMISSION_DENIED"));
            thrown = true;
        }
        AnonymousGuestTest.assertTrue((boolean)thrown);
    }

    protected static OCLGuestPermission createInvalidAnonymousGuestPermission(String password) {
        OCLGuestPermission guestPermission = AnonymousGuestTest.createAnonymousPermission(password);
        guestPermission.setAllPermission(4, 4, 4, 4);
        guestPermission.getRecipient().setBits(guestPermission.getPermissionBits());
        return guestPermission;
    }

    protected static OCLGuestPermission createInvalidAnonymousGuestPermission() {
        return AnonymousGuestTest.createAnonymousGuestPermission(null);
    }

    protected static OCLGuestPermission createInvalidAnonymousPermission(String password) {
        AnonymousRecipient recipient = new AnonymousRecipient();
        recipient.setPassword(password);
        OCLGuestPermission guestPermission = new OCLGuestPermission((ShareRecipient)recipient);
        AnonymousRecipient anonymousRecipient = new AnonymousRecipient();
        anonymousRecipient.setPassword(password);
        guestPermission.setRecipient((ShareRecipient)anonymousRecipient);
        guestPermission.setGroupPermission(false);
        guestPermission.setFolderAdmin(false);
        guestPermission.getRecipient().setBits(guestPermission.getPermissionBits());
        return guestPermission;
    }

    private FolderObject addPermissions(FolderObject folder, OCLPermission ... permissions) throws Exception {
        FolderObject toUpdate = new FolderObject(folder.getObjectID());
        toUpdate.setLastModified(folder.getLastModified());
        toUpdate.setFolderName(folder.getFolderName());
        toUpdate.setPermissions(folder.getPermissions());
        for (OCLPermission p : permissions) {
            toUpdate.addPermission(p);
        }
        return this.updateFolder(EnumAPI.OX_NEW, toUpdate);
    }

    private File addPermissions(File file, FileStorageObjectPermission ... permissions) throws Exception {
        DefaultFile metadata = new DefaultFile();
        metadata.setId(file.getId());
        metadata.setFolderId(file.getFolderId());
        metadata.setLastModified(file.getLastModified());
        ArrayList<FileStorageObjectPermission> newPermissions = new ArrayList<FileStorageObjectPermission>(2);
        List oldPermissions = file.getObjectPermissions();
        if (oldPermissions != null) {
            newPermissions.addAll(oldPermissions);
        }
        for (FileStorageObjectPermission p : permissions) {
            newPermissions.add(p);
        }
        metadata.setObjectPermissions(newPermissions);
        return this.updateFile((File)metadata, new File.Field[]{File.Field.OBJECT_PERMISSIONS});
    }

    private OCLPermission findAndCheckPermission(FolderObject folder) throws Exception {
        List permissions = folder.getPermissions();
        Assert.assertEquals((String)"Wrong number of permissions", (long)2L, (long)permissions.size());
        OCLPermission matchingPermission = null;
        for (OCLPermission p : permissions) {
            if (p.getEntity() == this.client.getValues().getUserId()) continue;
            Assert.assertTrue((boolean)p.isFolderVisible());
            Assert.assertTrue((boolean)p.canReadOwnObjects());
            Assert.assertTrue((boolean)p.canReadAllObjects());
            Assert.assertFalse((boolean)p.isFolderAdmin());
            Assert.assertFalse((boolean)p.isSystem());
            Assert.assertFalse((boolean)p.isGroupPermission());
            Assert.assertFalse((boolean)p.canWriteOwnObjects());
            Assert.assertFalse((boolean)p.canWriteAllObjects());
            Assert.assertFalse((boolean)p.canDeleteOwnObjects());
            Assert.assertFalse((boolean)p.canDeleteAllObjects());
            matchingPermission = p;
        }
        Assert.assertNotNull((String)"Missing expected guest permission", matchingPermission);
        return matchingPermission;
    }

    private FileStorageObjectPermission findAndCheckPermission(File file) throws Exception {
        List permissions = file.getObjectPermissions();
        Assert.assertNotNull((String)"Missing object permissions", (Object)permissions);
        Assert.assertEquals((String)"Wrong number of permissions", (long)1L, (long)permissions.size());
        FileStorageObjectPermission matchingPermission = null;
        for (FileStorageObjectPermission p : permissions) {
            if (p.getEntity() == this.client.getValues().getUserId()) continue;
            Assert.assertTrue((boolean)p.canRead());
            Assert.assertFalse((boolean)p.canWrite());
            Assert.assertFalse((boolean)p.canDelete());
            matchingPermission = p;
        }
        Assert.assertNotNull((String)"Missing expected guest permission", matchingPermission);
        return matchingPermission;
    }
}

