/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.group.actions.CreateRequest;
import com.openexchange.ajax.group.actions.CreateResponse;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.group.GroupExceptionCodes;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;

public class AddGuestUserToGroupTest
extends ShareTest {
    public AddGuestUserToGroupTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAddGuestToGroup() throws Exception {
        OCLGuestPermission perm = AddGuestUserToGroupTest.randomGuestPermission(8);
        FolderObject folder = this.insertSharedFolder(EnumAPI.OX_NEW, 8, this.client.getValues().getPrivateInfostoreFolder(), perm);
        this.remember(folder);
        OCLPermission matchingPermission = null;
        for (OCLPermission permission : folder.getPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        AddGuestUserToGroupTest.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        AddGuestUserToGroupTest.checkPermissions(perm, matchingPermission);
        int userId = matchingPermission.getEntity();
        Group group = new Group();
        group.setDisplayName("test add guest");
        group.setSimpleName("testAddGuest");
        group.setMember(new int[]{userId});
        CreateRequest req = new CreateRequest(group, false);
        CreateResponse resp = this.client.execute(req);
        AddGuestUserToGroupTest.assertTrue((boolean)resp.hasError());
        OXException e = resp.getException();
        AddGuestUserToGroupTest.assertTrue((boolean)GroupExceptionCodes.NO_GUEST_USER_IN_GROUP.equals(e));
    }
}

