/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.infostore.actions.InfostoreTestManager;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFileStorageGuestObjectPermission;
import com.openexchange.file.storage.DefaultFileStorageObjectPermission;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.composition.FileID;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.share.recipient.ShareRecipient;
import java.io.IOException;
import java.util.ArrayList;
import org.json.JSONException;

public abstract class AbstractSharedFilesTest
extends ShareTest {
    protected static final String SHARED_FOLDER = "10";
    protected InfostoreTestManager infoMgr;
    protected FolderObject userSourceFolder;
    protected FolderObject userDestFolder;
    protected File file;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.userSourceFolder = this.insertPrivateFolder(EnumAPI.OX_NEW, 8, this.getClient().getValues().getPrivateInfostoreFolder());
        this.file = this.insertFile(this.userSourceFolder.getObjectID(), AbstractSharedFilesTest.randomUID());
        this.infoMgr = new InfostoreTestManager(this.getClient());
    }

    protected AbstractSharedFilesTest(String name) {
        super(name);
    }

    protected void addUserPermission(int userId) throws OXException, IOException, JSONException {
        ArrayList<DefaultFileStorageObjectPermission> permissions = new ArrayList<DefaultFileStorageObjectPermission>(2);
        permissions.add(new DefaultFileStorageObjectPermission(userId, false, 2));
        this.file.getObjectPermissions().addAll(permissions);
    }

    protected void addGuestPermission(ShareRecipient shareRecipient) throws OXException, IOException, JSONException {
        ArrayList<DefaultFileStorageGuestObjectPermission> permissions = new ArrayList<DefaultFileStorageGuestObjectPermission>(2);
        DefaultFileStorageGuestObjectPermission guestPermission = new DefaultFileStorageGuestObjectPermission();
        guestPermission.setPermissions(2);
        guestPermission.setRecipient(shareRecipient);
        permissions.add(guestPermission);
        this.file.getObjectPermissions().addAll(permissions);
    }

    protected static String sharedFileId(String fileId) {
        FileID tmp = new FileID(fileId);
        tmp.setFolderId(SHARED_FOLDER);
        return tmp.toUniqueID();
    }
}

