/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.bugs;

import com.openexchange.admin.rmi.OXUserInterface;
import com.openexchange.admin.rmi.dataobjects.Context;
import com.openexchange.admin.rmi.dataobjects.Credentials;
import com.openexchange.admin.rmi.dataobjects.User;
import com.openexchange.admin.rmi.dataobjects.UserModuleAccess;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.rmi.Naming;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Bug44962Test
extends ShareTest {
    private AJAXClient client2;
    private Map<Integer, FolderObject> foldersToDelete;

    public Bug44962Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.foldersToDelete = new HashMap<Integer, FolderObject>();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        try {
            if (null != this.client2) {
                if (null != this.foldersToDelete && 0 < this.foldersToDelete.size()) {
                    Bug44962Test.deleteFoldersSilently(this.client2, this.foldersToDelete);
                }
                this.client2.logout();
                this.prepareUser(true, true, null);
            }
        }
        finally {
            super.tearDown();
        }
    }

    protected static int randomPimModule() {
        int[] pimModules = new int[]{3, 1, 2};
        return pimModules[random.nextInt(pimModules.length)];
    }

    public void testInviteGuestToDriveFolderWithInviteGuestsAndReadCreateSharedFolders() throws Exception {
        this.inviteGuestToFolder(8, true, Boolean.TRUE, null);
    }

    public void testDontInviteGuestToDriveFolder() throws Exception {
        this.inviteGuestToFolder(8, false, Boolean.FALSE, "SHR-0019");
    }

    public void testInviteGuestToDriveFolderWithInviteGuests() throws Exception {
        this.inviteGuestToFolder(8, false, Boolean.TRUE, null);
    }

    public void testInviteUserToDriveFolderWithReadCreateSharedFolders() throws Exception {
        this.inviteUserToFolder(8, true, Boolean.FALSE, null);
    }

    public void testInviteUserToDriveFolderWithInviteGuestsAndReadCreateSharedFolders() throws Exception {
        this.inviteUserToFolder(8, true, Boolean.TRUE, null);
    }

    public void testInviteUserToDriveFolder() throws Exception {
        this.inviteUserToFolder(8, false, Boolean.FALSE, null);
    }

    public void testInviteUserToDriveFolderWithInviteGuests() throws Exception {
        this.inviteUserToFolder(8, false, Boolean.TRUE, null);
    }

    public void testInviteGuestToPimFolderWithInviteGuestsAndReadCreateSharedFolders() throws Exception {
        this.inviteGuestToFolder(Bug44962Test.randomPimModule(), true, Boolean.TRUE, null);
    }

    public void testDontInviteGuestToPimFolder() throws Exception {
        this.inviteGuestToFolder(Bug44962Test.randomPimModule(), false, Boolean.FALSE, "SHR-0019");
    }

    public void testDontInviteGuestToPimFolderWithInviteGuests() throws Exception {
        this.inviteGuestToFolder(Bug44962Test.randomPimModule(), false, Boolean.TRUE, "FLD-0072");
    }

    public void testInviteUserToPimFolderWithReadCreateSharedFolders() throws Exception {
        this.inviteUserToFolder(Bug44962Test.randomPimModule(), true, Boolean.FALSE, null);
    }

    public void testInviteUserToPimFolderWithInviteGuestsAndReadCreateSharedFolders() throws Exception {
        this.inviteUserToFolder(Bug44962Test.randomPimModule(), true, Boolean.TRUE, null);
    }

    public void testDontInviteUserToPimFolder() throws Exception {
        this.inviteUserToFolder(Bug44962Test.randomPimModule(), false, Boolean.FALSE, "FLD-0072");
    }

    public void testDontInviteUserToPimFolderWithInviteGuests() throws Exception {
        this.inviteUserToFolder(Bug44962Test.randomPimModule(), false, Boolean.TRUE, "FLD-0072");
    }

    public void testInviteGuestToPublicPimFolderWithInviteGuestsAndEditPublicFolders() throws Exception {
        this.inviteGuestToPublicFolder(Bug44962Test.randomPimModule(), true, Boolean.TRUE, null);
    }

    public void testDontInviteGuestToPublicPimFolder() throws Exception {
        this.inviteGuestToPublicFolder(Bug44962Test.randomPimModule(), false, Boolean.FALSE, "SHR-0019");
    }

    public void testDontInviteGuestToPublicPimFolderWithInviteGuests() throws Exception {
        this.inviteGuestToPublicFolder(Bug44962Test.randomPimModule(), false, Boolean.TRUE, "FLD-0010");
    }

    public void testInviteUserToPublicPimFolderWithEditPublicFolders() throws Exception {
        this.inviteUserToPublicFolder(Bug44962Test.randomPimModule(), true, Boolean.FALSE, null);
    }

    public void testInviteUserToPublicPimFolderWithInviteGuestsAndEditPublicFolders() throws Exception {
        this.inviteUserToPublicFolder(Bug44962Test.randomPimModule(), true, Boolean.TRUE, null);
    }

    public void testDontInviteUserToPublicPimFolder() throws Exception {
        this.inviteUserToPublicFolder(Bug44962Test.randomPimModule(), false, Boolean.FALSE, "FLD-0010");
    }

    public void testDontInviteUserToPublicPimFolderWithInviteGuests() throws Exception {
        this.inviteUserToPublicFolder(Bug44962Test.randomPimModule(), false, Boolean.TRUE, "FLD-0010");
    }

    private void setReadCreateSharedFoldersAndEditPublicFolders(boolean readCreateSharedFolders, boolean editPublicFolders) throws Exception {
        Credentials credentials = new Credentials(AJAXConfig.getProperty(AJAXClient.User.OXAdmin.getLogin()), AJAXConfig.getProperty(AJAXClient.User.OXAdmin.getPassword()));
        OXUserInterface userInterface = (OXUserInterface)Naming.lookup("rmi://" + AJAXConfig.getProperty(AJAXConfig.Property.RMI_HOST) + ":1099/" + "OXUser_V2");
        User user = new User(this.client2.getValues().getUserId());
        Context context = new Context(Integer.valueOf(this.client2.getValues().getContextId()));
        UserModuleAccess moduleAccess = userInterface.getModuleAccess(context, user, credentials);
        moduleAccess.setReadCreateSharedFolders(readCreateSharedFolders);
        moduleAccess.setEditPublicFolders(editPublicFolders);
        userInterface.changeModuleAccess(context, user, moduleAccess, credentials);
    }

    private void setInviteGuests(Boolean inviteGuests) throws Exception {
        this.changeCapability("invite_guests", inviteGuests);
    }

    private void changeCapability(String capability, Boolean value) throws Exception {
        Credentials credentials = new Credentials(AJAXConfig.getProperty(AJAXClient.User.OXAdmin.getLogin()), AJAXConfig.getProperty(AJAXClient.User.OXAdmin.getPassword()));
        OXUserInterface userInterface = (OXUserInterface)Naming.lookup("rmi://" + AJAXConfig.getProperty(AJAXConfig.Property.RMI_HOST) + ":1099/" + "OXUser_V2");
        User user = new User(this.client2.getValues().getUserId());
        Context context = new Context(Integer.valueOf(this.client2.getValues().getContextId()));
        if (null == value) {
            userInterface.changeCapabilities(context, user, Collections.emptySet(), Collections.emptySet(), Collections.singleton(capability), credentials);
        } else if (Boolean.TRUE.equals(value)) {
            userInterface.changeCapabilities(context, user, Collections.singleton(capability), Collections.emptySet(), Collections.emptySet(), credentials);
        } else {
            userInterface.changeCapabilities(context, user, Collections.emptySet(), Collections.singleton(capability), Collections.emptySet(), credentials);
        }
    }

    private void prepareUser(boolean readCreateSharedFolders, boolean editPublicFolders, Boolean inviteGuests) throws Exception {
        this.setInviteGuests(inviteGuests);
        this.setReadCreateSharedFoldersAndEditPublicFolders(readCreateSharedFolders, editPublicFolders);
    }

    private void inviteGuestToFolder(int module, boolean readCreateSharedFolders, Boolean inviteGuests, String expectedError) throws Exception {
        this.prepareUser(readCreateSharedFolders, false, inviteGuests);
        FolderObject folder = Bug44962Test.insertPrivateFolder(this.client2, EnumAPI.OX_NEW, module, Bug44962Test.getDefaultFolder(this.client2, module));
        this.foldersToDelete.put(folder.getObjectID(), folder);
        folder.getPermissions().add(Bug44962Test.createNamedGuestPermission(Bug44962Test.randomUID() + "@example.com", Bug44962Test.randomUID()));
        UpdateRequest updateRequest = new UpdateRequest((API)EnumAPI.OX_NEW, folder);
        updateRequest.setFailOnError(false);
        this.executeAndCheck(updateRequest, expectedError);
    }

    private void inviteGuestToPublicFolder(int module, boolean editPublicFolders, Boolean inviteGuests, String expectedError) throws Exception {
        this.setReadCreateSharedFoldersAndEditPublicFolders(false, true);
        FolderObject folder = Bug44962Test.insertPublicFolder(this.client2, EnumAPI.OX_NEW, module);
        this.foldersToDelete.put(folder.getObjectID(), folder);
        this.prepareUser(false, editPublicFolders, inviteGuests);
        folder.getPermissions().add(Bug44962Test.createNamedGuestPermission(Bug44962Test.randomUID() + "@example.com", Bug44962Test.randomUID()));
        UpdateRequest updateRequest = new UpdateRequest((API)EnumAPI.OX_NEW, folder);
        updateRequest.setFailOnError(false);
        this.executeAndCheck(updateRequest, expectedError);
    }

    private void inviteUserToFolder(int module, boolean readCreateSharedFolders, Boolean inviteGuests, String expectedError) throws Exception {
        this.prepareUser(readCreateSharedFolders, false, inviteGuests);
        FolderObject folder = Bug44962Test.insertPrivateFolder(this.client2, EnumAPI.OX_NEW, module, Bug44962Test.getDefaultFolder(this.client2, module));
        this.foldersToDelete.put(folder.getObjectID(), folder);
        OCLPermission permission = new OCLPermission(this.getClient().getValues().getUserId(), folder.getObjectID());
        permission.setAllPermission(4, 4, 4, 0);
        folder.getPermissions().add(permission);
        UpdateRequest updateRequest = new UpdateRequest((API)EnumAPI.OX_NEW, folder);
        updateRequest.setFailOnError(false);
        this.executeAndCheck(updateRequest, expectedError);
    }

    private void inviteUserToPublicFolder(int module, boolean editPublicFolders, Boolean inviteGuests, String expectedError) throws Exception {
        this.setReadCreateSharedFoldersAndEditPublicFolders(false, true);
        FolderObject folder = Bug44962Test.insertPublicFolder(this.client2, EnumAPI.OX_NEW, module);
        this.foldersToDelete.put(folder.getObjectID(), folder);
        this.prepareUser(false, editPublicFolders, inviteGuests);
        OCLPermission permission = new OCLPermission(this.getClient().getValues().getUserId(), folder.getObjectID());
        permission.setAllPermission(4, 4, 4, 0);
        folder.getPermissions().add(permission);
        UpdateRequest updateRequest = new UpdateRequest((API)EnumAPI.OX_NEW, folder);
        updateRequest.setFailOnError(false);
        this.executeAndCheck(updateRequest, expectedError);
    }

    private void executeAndCheck(AJAXRequest<?> request, String expectedError) throws Exception {
        Object response = this.client2.execute(request);
        if (null == expectedError) {
            Bug44962Test.assertFalse((String)((AbstractAJAXResponse)((Object)response)).getErrorMessage(), (boolean)((AbstractAJAXResponse)((Object)response)).hasError());
        } else {
            Bug44962Test.assertTrue((String)"No error in response", (boolean)((AbstractAJAXResponse)((Object)response)).hasError());
            Bug44962Test.assertEquals((String)"Unexpected error code", (String)expectedError, (String)((AbstractAJAXResponse)((Object)response)).getException().getErrorCode());
        }
    }
}

