/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.bugs;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.recipient.RecipientType;

public class Bug40993Test
extends ShareTest {
    public Bug40993Test(String name) {
        super(name);
    }

    public void testAccessSubfolderRandomly() throws Exception {
        int module = Bug40993Test.randomModule();
        this.testAccessSubfolder(Bug40993Test.randomFolderAPI(), module, Bug40993Test.randomGuestPermission(RecipientType.GUEST, module));
    }

    private void testAccessSubfolder(EnumAPI api, int module, OCLGuestPermission guestPermission) throws Exception {
        this.testAccessSubfolder(api, module, this.getDefaultFolder(module), guestPermission);
    }

    private void testAccessSubfolder(EnumAPI api, int module, int parent, OCLGuestPermission guestPermission) throws Exception {
        FolderObject folder = this.insertSharedFolder(api, module, parent, guestPermission);
        OCLPermission adminPermission = null;
        OCLPermission matchingPermission = null;
        for (OCLPermission permission : folder.getPermissions()) {
            if (permission.getEntity() != this.client.getValues().getUserId()) {
                matchingPermission = permission;
                continue;
            }
            adminPermission = permission;
        }
        Bug40993Test.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        Bug40993Test.checkPermissions(guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(api, module, folder.getObjectID(), matchingPermission.getEntity());
        Bug40993Test.checkGuestPermission(guestPermission, guest);
        String folderShareURL = this.discoverShareURL(guest);
        GuestClient guestClient = this.resolveShare(folderShareURL, guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        guestClient.checkShareAccessible(guestPermission);
        FolderObject subfolder = this.insertSharedFolder(api, module, folder.getObjectID(), matchingPermission);
        matchingPermission = null;
        for (OCLPermission permission : subfolder.getPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        Bug40993Test.assertNotNull((String)"No matching permission in created folder found", (Object)matchingPermission);
        Bug40993Test.checkPermissions(guestPermission, matchingPermission);
        guest = this.discoverGuestEntity(api, module, subfolder.getObjectID(), matchingPermission.getEntity());
        Bug40993Test.checkGuestPermission(guestPermission, guest);
        String subfolderShareURL = this.discoverShareURL(guest);
        guestClient = this.resolveShare(subfolderShareURL, guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        guestClient.checkShareAccessible(guestPermission);
        folder.setLastModified(Bug40993Test.futureTimestamp());
        folder.setPermissionsAsArray(new OCLPermission[]{adminPermission});
        folder = this.updateFolder(api, folder);
        for (OCLPermission permission : folder.getPermissions()) {
            Bug40993Test.assertTrue((String)"Guest permission still present", (permission.getEntity() != matchingPermission.getEntity() ? 1 : 0) != 0);
        }
        guest = this.discoverGuestEntity(api, module, folder.getObjectID(), matchingPermission.getEntity());
        Bug40993Test.assertNull((String)"guest entity still found", (Object)guest);
        guestClient = this.resolveShare(subfolderShareURL, guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        guestClient.checkShareAccessible(guestPermission);
        guestClient.checkFolderAccessible(String.valueOf(subfolder.getObjectID()), guestPermission);
        guestClient.checkFolderNotAccessible(String.valueOf(folder.getObjectID()));
        guestClient = this.resolveShare(folderShareURL, guestPermission.getRecipient());
        Bug40993Test.assertEquals((String)"Status wrong", (String)"not_found_continue", (String)guestClient.getShareResolveResponse().getStatus());
        guestClient.checkShareModuleAvailable();
        guestClient.checkFolderAccessible(String.valueOf(subfolder.getObjectID()), guestPermission);
        guestClient.checkFolderNotAccessible(String.valueOf(folder.getObjectID()));
    }
}

