/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.bugs;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.passwordchange.actions.PasswordChangeUpdateRequest;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.recipient.GuestRecipient;

public class Bug40722Test
extends ShareTest {
    public Bug40722Test(String name) {
        super(name);
    }

    public void testRemoveGuestPassword() throws Exception {
        OCLGuestPermission guestPermission = Bug40722Test.createNamedGuestPermission(Bug40722Test.randomUID() + "@example.com", "Test Guest", "secret");
        int module = Bug40722Test.randomModule();
        EnumAPI api = Bug40722Test.randomFolderAPI();
        FolderObject folder = this.insertSharedFolder(api, module, this.getDefaultFolder(module), guestPermission);
        OCLPermission matchingPermission = null;
        for (OCLPermission permission : folder.getPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        Bug40722Test.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        Bug40722Test.checkPermissions(guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(api, module, folder.getObjectID(), matchingPermission.getEntity());
        Bug40722Test.checkGuestPermission(guestPermission, guest);
        String shareURL = this.discoverShareURL(guest);
        GuestClient guestClient = this.resolveShare(shareURL, guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        String newPassword = null;
        PasswordChangeUpdateRequest updateRequest = new PasswordChangeUpdateRequest(newPassword, ((GuestRecipient)guestPermission.getRecipient()).getPassword(), true);
        guestClient.execute(updateRequest);
        guestClient = this.resolveShare(shareURL, ((GuestRecipient)guestPermission.getRecipient()).getEmailAddress(), newPassword);
        guestClient.checkShareModuleAvailable();
    }
}

