/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.actions;

import java.util.Date;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class ShareLink {
    private final String shareURL;
    private final int entity;
    private final String password;
    private final Date expiry;
    private final boolean isNew;

    public ShareLink(JSONObject json, TimeZone timeZone) throws JSONException {
        this.shareURL = json.optString("url", null);
        this.entity = json.getInt("entity");
        this.password = json.optString("password", null);
        this.isNew = json.optBoolean("is_new", false);
        if (json.hasAndNotNull("expiry_date")) {
            long date = json.getLong("expiry_date");
            if (null != timeZone) {
                date -= (long)timeZone.getOffset(date);
            }
            this.expiry = new Date(date);
        } else {
            this.expiry = null;
        }
    }

    public boolean isNew() {
        return this.isNew;
    }

    public String getShareURL() {
        return this.shareURL;
    }

    public int getEntity() {
        return this.entity;
    }

    public String getPassword() {
        return this.password;
    }

    public Date getExpiry() {
        return this.expiry;
    }
}

