/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.Header;
import com.openexchange.ajax.framework.Params;
import com.openexchange.ajax.share.actions.SendLinkResponse;
import com.openexchange.ajax.share.actions.ShareWriter;
import com.openexchange.share.ShareTarget;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SendLinkRequest
implements AJAXRequest<SendLinkResponse> {
    private final ShareTarget target;
    private final String recipient;
    private final String message;
    private boolean failOnError = true;

    public SendLinkRequest(ShareTarget target, String recipient) {
        this(target, recipient, null);
    }

    public SendLinkRequest(ShareTarget target, String recipient, String message) {
        this.target = target;
        this.recipient = recipient;
        this.message = message;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public String getServletPath() {
        return "/ajax/share/management";
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        return new Params("action", "sendLink").toArray();
    }

    @Override
    public AbstractAJAXParser<SendLinkResponse> getParser() {
        return new Parser(this.failOnError);
    }

    @Override
    public Object getBody() throws IOException, JSONException {
        JSONObject body = ShareWriter.writeTarget(this.target);
        JSONArray jRecipients = new JSONArray();
        JSONArray jRecipient = new JSONArray();
        jRecipient.put((Object)this.recipient);
        jRecipients.put((Object)jRecipient);
        body.put("recipients", (Object)jRecipients);
        if (this.message != null) {
            body.put("message", (Object)this.message);
        }
        return body;
    }

    @Override
    public Header[] getHeaders() {
        return NO_HEADER;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    private static final class Parser
    extends AbstractAJAXParser<SendLinkResponse> {
        protected Parser(boolean failOnError) {
            super(failOnError);
        }

        @Override
        protected SendLinkResponse createResponse(Response response) throws JSONException {
            return new SendLinkResponse(response);
        }
    }
}

