/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.folder.actions.AbstractFolderRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import java.io.IOException;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NotifyFolderRequest
extends AbstractFolderRequest<AbstractAJAXResponse> {
    private final String id;
    private final int[] entities;
    private final boolean failOnError;

    public NotifyFolderRequest(String id, int[] entities, boolean failOnError) {
        super(EnumAPI.OX_NEW);
        this.id = id;
        this.entities = entities;
        this.failOnError = failOnError;
    }

    public NotifyFolderRequest(String id, int ... entities) {
        this(id, entities, true);
    }

    @Override
    public Object getBody() throws IOException, JSONException {
        JSONObject jsonBody = new JSONObject();
        JSONArray jsonEntities = new JSONArray();
        for (int entity : this.entities) {
            jsonEntities.put(entity);
        }
        jsonBody.put("entities", (Object)jsonEntities);
        return jsonBody;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    protected void addParameters(List<AJAXRequest.Parameter> params) {
        params.add(new AJAXRequest.Parameter("action", "notify"));
        params.add(new AJAXRequest.Parameter("id", this.id));
    }

    @Override
    public AbstractAJAXParser<? extends AbstractAJAXResponse> getParser() {
        return new AbstractAJAXParser<AbstractAJAXResponse>(this.failOnError){

            @Override
            protected AbstractAJAXResponse createResponse(Response response) throws JSONException {
                return new AbstractAJAXResponse(response){};
            }
        };
    }
}

