/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.responseRenderers;

import com.openexchange.ajax.container.ByteArrayFileHolder;
import com.openexchange.ajax.container.FileHolder;
import com.openexchange.ajax.fileholder.IFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.cache.CachedResource;
import com.openexchange.ajax.requesthandler.cache.ResourceCache;
import com.openexchange.ajax.requesthandler.cache.ResourceCaches;
import com.openexchange.ajax.requesthandler.responseRenderers.FileResponseRenderer;
import com.openexchange.ajax.requesthandler.responseRenderers.FileResponseRendererTools;
import com.openexchange.config.ConfigurationService;
import com.openexchange.config.SimConfigurationService;
import com.openexchange.configuration.MailConfig;
import com.openexchange.exception.OXException;
import com.openexchange.html.HtmlService;
import com.openexchange.html.SimHtmlService;
import com.openexchange.imagetransformation.BasicTransformedImage;
import com.openexchange.imagetransformation.ImageTransformationProvider;
import com.openexchange.imagetransformation.ImageTransformationService;
import com.openexchange.imagetransformation.ImageTransformations;
import com.openexchange.imagetransformation.ScaleType;
import com.openexchange.imagetransformation.TransformedImage;
import com.openexchange.imagetransformation.java.impl.JavaImageTransformationProvider;
import com.openexchange.java.Strings;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.image.WrappingImageTransformationService;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.SimServerSession;
import com.openexchange.tools.strings.BasicTypesStringParser;
import com.openexchange.tools.strings.StringParser;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.sim.SimHttpServletRequest;
import javax.servlet.http.sim.SimHttpServletResponse;
import javax.servlet.sim.ByteArrayServletOutputStream;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;

public class FileResponseRendererTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        ServerServiceRegistry.getInstance().addService(HtmlService.class, (Object)new SimHtmlService());
        SimConfigurationService simConfigurationService = new SimConfigurationService();
        simConfigurationService.stringProperties.put("UPLOAD_DIRECTORY", "/tmp/");
        ServerServiceRegistry.getInstance().addService(ConfigurationService.class, (Object)simConfigurationService);
    }

    protected void tearDown() throws Exception {
        ServerServiceRegistry.getInstance().removeService(HtmlService.class);
        super.tearDown();
    }

    public void testProperContentLength() {
        try {
            String html = "foo\n<object/data=\"data:text/html;base64,PHNjcmlwdD5hbGVydCgiWFNTIFNjaHdhY2hzdGVsbGUiKTwvc2NyaXB0Pg==\"></object>\nbar";
            byte[] bytes = "foo\n<object/data=\"data:text/html;base64,PHNjcmlwdD5hbGVydCgiWFNTIFNjaHdhY2hzdGVsbGUiKTwvc2NyaXB0Pg==\"></object>\nbar".getBytes("ISO-8859-1");
            int length = bytes.length;
            ByteArrayFileHolder fileHolder = FileResponseRendererTools.getFileHolder(bytes, "text/html; charset=ISO-8859-1", FileResponseRendererTools.Delivery.view, FileResponseRendererTools.Disposition.inline, "document.html");
            FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
            AJAXRequestData requestData = new AJAXRequestData();
            AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
            SimHttpServletRequest req = new SimHttpServletRequest();
            SimHttpServletResponse resp = new SimHttpServletResponse();
            ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
            resp.setOutputStream((ServletOutputStream)servletOutputStream);
            fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
            int contentLength = resp.getContentLength();
            FileResponseRendererTest.assertTrue((String)("Unexpected Content-Length: " + contentLength), (contentLength > 0 ? 1 : 0) != 0);
            FileResponseRendererTest.assertTrue((String)("Unexpected Content-Length: " + contentLength + ", but should be less than " + length), (length > contentLength ? 1 : 0) != 0);
            int size = servletOutputStream.size();
            FileResponseRendererTest.assertEquals((String)"Unexpected Content-Length.", (int)size, (int)contentLength);
        }
        catch (Exception e) {
            e.printStackTrace();
            FileResponseRendererTest.fail((String)e.getMessage());
        }
    }

    public void testApplicationHtml_Bug35512() {
        try {
            String html = "foo\n<object/data=\"data:text/html;base64,PHNjcmlwdD5hbGVydCgiWFNTIFNjaHdhY2hzdGVsbGUiKTwvc2NyaXB0Pg==\"></object>\nbar";
            ByteArrayFileHolder fileHolder = FileResponseRendererTools.getFileHolder(html.getBytes(), "application/xhtml+xml", FileResponseRendererTools.Delivery.view, FileResponseRendererTools.Disposition.inline, "evil.html");
            AJAXRequestData requestData = new AJAXRequestData();
            requestData.setSession((ServerSession)new SimServerSession(1, 1));
            requestData.putParameter("width", "10");
            requestData.putParameter("height", "10");
            AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
            result.setExpires(Tools.getDefaultImageExpiry());
            SimHttpServletRequest req = new SimHttpServletRequest();
            SimHttpServletResponse resp = new SimHttpServletResponse();
            ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
            resp.setOutputStream((ServletOutputStream)servletOutputStream);
            FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
            fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
            String s = new String(servletOutputStream.toByteArray());
            FileResponseRendererTest.assertTrue((String)("HTML content not sanitized: " + s), (s.indexOf("<object/data") < 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            FileResponseRendererTest.fail((String)e.getMessage());
        }
    }

    public void testMaxAgeHeader_Bug33441() {
        try {
            ByteArrayFileHolder fileHolder = FileResponseRendererTools.getFileHolder("28082.jpg", "image/jpeg", FileResponseRendererTools.Delivery.view, FileResponseRendererTools.Disposition.inline, "28082.jpg");
            AJAXRequestData requestData = new AJAXRequestData();
            requestData.setSession((ServerSession)new SimServerSession(1, 1));
            requestData.putParameter("width", "10");
            requestData.putParameter("height", "10");
            AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
            result.setExpires(Tools.getDefaultImageExpiry());
            SimHttpServletRequest req = new SimHttpServletRequest();
            SimHttpServletResponse resp = new SimHttpServletResponse();
            ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
            resp.setOutputStream((ServletOutputStream)servletOutputStream);
            FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
            fileResponseRenderer.setScaler((ImageTransformationService)new TestableImageTransformationService(IOUtils.toByteArray((InputStream)fileHolder.getStream()), 3));
            fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
            FileResponseRendererTest.assertTrue((String)"HTTP header \"cache-control\" is missing", (boolean)resp.containsHeader("cache-control"));
            String sCacheControl = (String)resp.getHeaders().get("cache-control");
            FileResponseRendererTest.assertTrue((String)"HTTP header \"cache-control\" is missing", (!Strings.isEmpty((String)sCacheControl) ? 1 : 0) != 0);
            FileResponseRendererTest.assertTrue((String)"Invalid HTTP header \"cache-control\"", (sCacheControl.indexOf("max-age=3600") > 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            FileResponseRendererTest.fail((String)e.getMessage());
        }
    }

    public void testZeroByteTransformation_Bug28429() {
        try {
            ByteArrayFileHolder fileHolder = FileResponseRendererTools.getFileHolder("28429.jpg", "image/jpeg", FileResponseRendererTools.Delivery.view, FileResponseRendererTools.Disposition.inline, "28429.jpg");
            AJAXRequestData requestData = new AJAXRequestData();
            requestData.setSession((ServerSession)new SimServerSession(1, 1));
            requestData.putParameter("width", "10");
            requestData.putParameter("height", "10");
            AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
            SimHttpServletRequest req = new SimHttpServletRequest();
            SimHttpServletResponse resp = new SimHttpServletResponse();
            ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
            resp.setOutputStream((ServletOutputStream)servletOutputStream);
            FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
            fileResponseRenderer.setScaler((ImageTransformationService)new TestableImageTransformationService(IOUtils.toByteArray((InputStream)fileHolder.getStream()), 3));
            fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
            FileResponseRendererTest.assertFalse((String)("Got an error status: " + resp.getStatus()), (resp.getStatus() >= 400 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            FileResponseRendererTest.fail((String)e.getMessage());
        }
    }

    public void testContentTypeByFileName_Bug31648() {
        try {
            ByteArrayFileHolder fileHolder = FileResponseRendererTools.getFileHolder("31648.png", "application/binary", FileResponseRendererTools.Delivery.view, FileResponseRendererTools.Disposition.inline, "31648.png");
            AJAXRequestData requestData = new AJAXRequestData();
            requestData.setSession((ServerSession)new SimServerSession(1, 1));
            requestData.putParameter("width", "10");
            requestData.putParameter("height", "10");
            AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
            SimHttpServletRequest req = new SimHttpServletRequest();
            SimHttpServletResponse resp = new SimHttpServletResponse();
            ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
            resp.setOutputStream((ServletOutputStream)servletOutputStream);
            MimeType2ExtMap.addMimeType((String)"image/png", (String)"png");
            FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
            fileResponseRenderer.setScaler((ImageTransformationService)new TestableImageTransformationService(IOUtils.toByteArray((InputStream)fileHolder.getStream()), 3));
            fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
            String expectedContentType = "image/png";
            String currentContentType = resp.getContentType();
            FileResponseRendererTest.assertEquals((String)"Unexpected content-type.", (String)"image/png", (String)currentContentType);
        }
        catch (Exception e) {
            e.printStackTrace();
            FileResponseRendererTest.fail((String)e.getMessage());
        }
    }

    public void testRangeHeader_Bug27394() {
        try {
            ByteArrayFileHolder fileHolder = FileResponseRendererTools.getFileHolder("26926_27394.pdf", "application/pdf", FileResponseRendererTools.Delivery.view, FileResponseRendererTools.Disposition.inline, "26926_27394.pdf");
            AJAXRequestData requestData = new AJAXRequestData();
            requestData.setSession((ServerSession)new SimServerSession(1, 1));
            requestData.putParameter("width", "10");
            requestData.putParameter("height", "10");
            AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
            SimHttpServletRequest req = new SimHttpServletRequest();
            req.setHeader("Range", "bytes=0-50");
            SimHttpServletResponse resp = new SimHttpServletResponse();
            ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
            resp.setOutputStream((ServletOutputStream)servletOutputStream);
            FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
            fileResponseRenderer.setScaler((ImageTransformationService)new TestableImageTransformationService(IOUtils.toByteArray((InputStream)fileHolder.getStream()), 3));
            fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
            FileResponseRendererTest.assertTrue((String)"HTTP header \"accept-ranges\" is missing", (boolean)resp.containsHeader("accept-ranges"));
            FileResponseRendererTest.assertTrue((String)"HTTP header \"content-range\" is missing", (boolean)resp.containsHeader("content-range"));
            FileResponseRendererTest.assertEquals((String)"bytes", (String)((String)resp.getHeaders().get("accept-ranges")));
            FileResponseRendererTest.assertEquals((String)"bytes 0-50/3852226", (String)((String)resp.getHeaders().get("content-range")));
        }
        catch (Exception e) {
            e.printStackTrace();
            FileResponseRendererTest.fail((String)e.getMessage());
        }
    }

    public void test404_Bug26848() {
        FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
        AJAXRequestData requestData = new AJAXRequestData();
        AJAXRequestResult result = new AJAXRequestResult();
        SimHttpServletRequest req = new SimHttpServletRequest();
        SimHttpServletResponse resp = new SimHttpServletResponse();
        ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
        resp.setOutputStream((ServletOutputStream)servletOutputStream);
        fileResponseRenderer.write(requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
        FileResponseRendererTest.assertEquals((String)"Wrong status code", (int)404, (int)resp.getStatus());
        ByteArrayFileHolder fileHolder = FileResponseRendererTools.getFileHolder(new byte[0], "application/octet-stream", FileResponseRendererTools.Delivery.download, FileResponseRendererTools.Disposition.attachment, "");
        resp = new SimHttpServletResponse();
        servletOutputStream = new ByteArrayServletOutputStream();
        resp.setOutputStream((ServletOutputStream)servletOutputStream);
        result = new AJAXRequestResult((Object)fileHolder, "file");
        fileResponseRenderer.write(requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
        FileResponseRendererTest.assertEquals((String)"Wrong status code", (int)404, (int)resp.getStatus());
        fileHolder.setContentType("");
        resp = new SimHttpServletResponse();
        servletOutputStream = new ByteArrayServletOutputStream();
        resp.setOutputStream((ServletOutputStream)servletOutputStream);
        result = new AJAXRequestResult((Object)fileHolder, "file");
        fileResponseRenderer.write(requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
        FileResponseRendererTest.assertEquals((String)"Wrong status code", (int)404, (int)resp.getStatus());
    }

    public void testShouldDetectVulnerableHtmlTags_Bug28637() {
        try {
            ByteArrayFileHolder fileHolder = FileResponseRendererTools.getFileHolder("28637.htm", "text/html", FileResponseRendererTools.Delivery.view, FileResponseRendererTools.Disposition.inline, "28637.htm");
            AJAXRequestData requestData = new AJAXRequestData();
            AJAXRequestResult result = new AJAXRequestResult();
            SimHttpServletRequest req = new SimHttpServletRequest();
            SimHttpServletResponse resp = new SimHttpServletResponse();
            ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
            resp.setOutputStream((ServletOutputStream)servletOutputStream);
            FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
            fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
            FileResponseRendererTest.assertNotNull((Object)("No output stream found" + servletOutputStream.toString()));
            String outputString = servletOutputStream.toString();
            FileResponseRendererTest.assertFalse((String)"Output stream contains vulnerable '<script>' tag", (boolean)outputString.contains("<script>"));
        }
        catch (Exception e) {
            e.printStackTrace();
            FileResponseRendererTest.fail((String)e.getMessage());
        }
    }

    public void testXSSVuln_Bug26244() throws IOException {
        FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
        ByteArrayFileHolder fileHolder = FileResponseRendererTools.getFileHolder("xss_utf16.html");
        AJAXRequestData requestData = new AJAXRequestData();
        AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
        SimHttpServletRequest req = new SimHttpServletRequest();
        req.setParameter("content_type", "text/html; charset=UTF-16");
        req.setParameter("content_disposition", "inline");
        SimHttpServletResponse resp = new SimHttpServletResponse();
        ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
        resp.setOutputStream((ServletOutputStream)servletOutputStream);
        fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
        String expectedCT = "text/html";
        FileResponseRendererTest.assertEquals((String)"Wrong Content-Type", (String)"text/html", (String)resp.getContentType());
    }

    public void testXSSVuln_Bug29147() throws IOException {
        FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
        ByteArrayFileHolder fileHolder = FileResponseRendererTools.getFileHolder("29147.svg", "image/svg+xml", FileResponseRendererTools.Delivery.view, FileResponseRendererTools.Disposition.inline, "29147.svg");
        AJAXRequestData requestData = new AJAXRequestData();
        AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
        SimHttpServletRequest req = new SimHttpServletRequest();
        SimHttpServletResponse resp = new SimHttpServletResponse();
        ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
        resp.setOutputStream((ServletOutputStream)servletOutputStream);
        fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
        String expectedCT = "application/octet-stream";
        FileResponseRendererTest.assertEquals((String)"Wrong Content-Type", (String)"application/octet-stream", (String)resp.getContentType());
    }

    public void testXSSVuln_Bug26373_view() throws IOException {
        FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
        ByteArrayFileHolder fileHolder = FileResponseRendererTools.getFileHolder("26237.html");
        AJAXRequestData requestData = new AJAXRequestData();
        AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
        SimHttpServletRequest req = new SimHttpServletRequest();
        req.setParameter("content_disposition", "view");
        SimHttpServletResponse resp = new SimHttpServletResponse();
        ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
        resp.setOutputStream((ServletOutputStream)servletOutputStream);
        fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
        FileResponseRendererTest.assertEquals((String)"Wrong Content-Type", (String)"application/octet-stream", (String)resp.getContentType());
    }

    public void testXSSVuln_Bug26237_inline() throws IOException {
        FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
        ByteArrayFileHolder fileHolder = FileResponseRendererTools.getFileHolder("26237.html");
        AJAXRequestData requestData = new AJAXRequestData();
        AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
        SimHttpServletRequest req = new SimHttpServletRequest();
        req.setParameter("content_disposition", "inline");
        SimHttpServletResponse resp = new SimHttpServletResponse();
        ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
        resp.setOutputStream((ServletOutputStream)servletOutputStream);
        fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
        FileResponseRendererTest.assertEquals((String)"Wrong Content-Type", (String)"application/octet-stream", (String)resp.getContentType());
    }

    public void testXSSVuln_Bug26243() throws IOException {
        FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
        ByteArrayFileHolder fileHolder = FileResponseRendererTools.getFileHolder("31714.jpg");
        AJAXRequestData requestData = new AJAXRequestData();
        AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
        SimHttpServletRequest req = new SimHttpServletRequest();
        req.setParameter("content_disposition", "inline");
        req.setParameter("content_type", "text/html%0d%0a%0d%0a<script>alert(\"XSS\")</script>");
        SimHttpServletResponse resp = new SimHttpServletResponse();
        ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
        resp.setOutputStream((ServletOutputStream)servletOutputStream);
        fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
        FileResponseRendererTest.assertEquals((String)"Wrong Content-Type", (String)"image/jpeg", (String)resp.getContentType());
    }

    public void testBug31714() throws IOException {
        ByteArrayFileHolder fileHolder = FileResponseRendererTools.getFileHolder("31714.jpg", "image/jpeg", FileResponseRendererTools.Delivery.view, FileResponseRendererTools.Disposition.inline, "31714.jpg");
        FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
        AJAXRequestData requestData = new AJAXRequestData();
        requestData.putParameter("width", "1000000");
        requestData.putParameter("height", "1000000");
        requestData.setSession((ServerSession)new SimServerSession(1, 1));
        AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
        SimHttpServletRequest req = new SimHttpServletRequest();
        SimHttpServletResponse resp = new SimHttpServletResponse();
        fileResponseRenderer.setScaler((ImageTransformationService)new TestableImageTransformationService(IOUtils.toByteArray((InputStream)fileHolder.getStream()), 3));
        fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
        FileResponseRendererTest.assertEquals((String)"Unexpected status code.", (int)500, (int)resp.getStatus());
    }

    public void testBug26995() throws IOException {
        ByteArrayFileHolder fileHolder = FileResponseRendererTools.getFileHolder("26995", "application/octet-stream", FileResponseRendererTools.Delivery.view, FileResponseRendererTools.Disposition.attachment, "26995");
        FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
        AJAXRequestData requestData = new AJAXRequestData();
        requestData.setSession((ServerSession)new SimServerSession(1, 1));
        AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
        SimHttpServletRequest req = new SimHttpServletRequest();
        SimHttpServletResponse resp = new SimHttpServletResponse();
        ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
        resp.setOutputStream((ServletOutputStream)servletOutputStream);
        fileResponseRenderer.setScaler((ImageTransformationService)new TestableImageTransformationService(IOUtils.toByteArray((InputStream)fileHolder.getStream()), 3));
        fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
        FileResponseRendererTest.assertEquals((String)"Wrong Content-Type", (String)"image/jpeg", (String)resp.getContentType());
    }

    public void testBug25133() throws IOException {
        ByteArrayFileHolder fileHolder = FileResponseRendererTools.getFileHolder("25133.eml", null, FileResponseRendererTools.Delivery.download, FileResponseRendererTools.Disposition.attachment, "25133.eml");
        FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
        AJAXRequestData requestData = new AJAXRequestData();
        requestData.putParameter("transformationNeeded", "true");
        requestData.setSession((ServerSession)new SimServerSession(1, 1));
        AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
        SimHttpServletRequest req = new SimHttpServletRequest();
        SimHttpServletResponse resp = new SimHttpServletResponse();
        ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
        resp.setOutputStream((ServletOutputStream)servletOutputStream);
        fileResponseRenderer.setScaler((ImageTransformationService)new WrappingImageTransformationService((ImageTransformationProvider)new JavaImageTransformationProvider()));
        fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
        FileResponseRendererTest.assertNotNull((String)"Header content-type not found", (Object)resp.getContentType());
        FileResponseRendererTest.assertEquals((String)"Wrong Content-Type", (String)"application/octet-stream", (String)resp.getContentType());
    }

    public void testTikaShouldDetectCorrectContenType_Bug26153() throws IOException, OXException {
        ByteArrayFileHolder fileHolder = FileResponseRendererTools.getFileHolder("Rotate_90CW.jpg", "application/octet-stream", FileResponseRendererTools.Delivery.view, FileResponseRendererTools.Disposition.inline, "Rotate");
        FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
        AJAXRequestData requestData = new AJAXRequestData();
        requestData.setSession((ServerSession)new SimServerSession(1, 1));
        AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
        SimHttpServletRequest req = new SimHttpServletRequest();
        SimHttpServletResponse resp = new SimHttpServletResponse();
        ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
        resp.setOutputStream((ServletOutputStream)servletOutputStream);
        fileResponseRenderer.setScaler((ImageTransformationService)new WrappingImageTransformationService((ImageTransformationProvider)new JavaImageTransformationProvider()));
        fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
        requestData.setSession((ServerSession)new SimServerSession(1, 1));
        FileResponseRendererTest.assertEquals((String)"Wrong Content-Type", (String)"image/jpeg", (String)resp.getContentType());
    }

    public void testUnquoteContentTypeAndDisposition_Bug26153() throws IOException, OXException {
        ByteArrayFileHolder fileHolder = FileResponseRendererTools.getFileHolder("Rotate_90CW.jpg", "\"image/jpeg\"", FileResponseRendererTools.Delivery.view, FileResponseRendererTools.Disposition.inline, "Rotate_90CW.jpg");
        fileHolder.setDisposition("\"inline\"");
        fileHolder.setDelivery("\"view\"");
        FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
        AJAXRequestData requestData = new AJAXRequestData();
        requestData.setSession((ServerSession)new SimServerSession(1, 1));
        AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
        SimHttpServletRequest req = new SimHttpServletRequest();
        SimHttpServletResponse resp = new SimHttpServletResponse();
        ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
        resp.setOutputStream((ServletOutputStream)servletOutputStream);
        fileResponseRenderer.setScaler((ImageTransformationService)new WrappingImageTransformationService((ImageTransformationProvider)new JavaImageTransformationProvider()));
        fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
        requestData.setSession((ServerSession)new SimServerSession(1, 1));
        FileResponseRendererTest.assertEquals((String)"Wrong Content-Type", (String)"image/jpeg", (String)resp.getContentType());
        FileResponseRendererTest.assertNotNull((String)"Header content-disposition not present", resp.getHeaders().get("content-disposition"));
        String contentDisposition = (String)resp.getHeaders().get("content-disposition");
        contentDisposition = contentDisposition.substring(0, contentDisposition.indexOf(59));
        FileResponseRendererTest.assertEquals((String)"Wrong Content-Disposition", (String)"inline", (String)contentDisposition);
    }

    public void testSanitizingUrlParameter() throws IOException, OXException {
        ByteArrayFileHolder fileHolder = FileResponseRendererTools.getFileHolder("XSSFile.html", null, FileResponseRendererTools.Delivery.view, FileResponseRendererTools.Disposition.inline, "XSSFile.html");
        FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
        AJAXRequestData requestData = new AJAXRequestData();
        requestData.setSession((ServerSession)new SimServerSession(1, 1));
        AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
        SimHttpServletRequest req = new SimHttpServletRequest();
        req.setParameter("content_type", "text/html&amp;lt;script&amp;gt;x=/xss/;alert&amp;#40;x.source&amp;#41;&amp;lt;/script&amp;gt;");
        SimHttpServletResponse resp = new SimHttpServletResponse();
        ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
        resp.setOutputStream((ServletOutputStream)servletOutputStream);
        fileResponseRenderer.setScaler((ImageTransformationService)new WrappingImageTransformationService((ImageTransformationProvider)new JavaImageTransformationProvider()));
        fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
        requestData.setSession((ServerSession)new SimServerSession(1, 1));
        FileResponseRendererTest.assertEquals((String)"Wrong Content-Type", (String)"text/html", (String)resp.getContentType());
    }

    public void testSanitizingFileArguments() throws Exception {
        ByteArrayFileHolder fileHolder = new ByteArrayFileHolder(new byte[]{1, 1, 1, 1});
        fileHolder.setContentType("<pwn/ny");
        fileHolder.setDelivery(FileResponseRendererTools.Delivery.view.name());
        fileHolder.setDisposition(FileResponseRendererTools.Disposition.inline.name());
        fileHolder.setName("<svg onload=alert(1)>");
        FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
        AJAXRequestData requestData = new AJAXRequestData();
        requestData.setSession((ServerSession)new SimServerSession(1, 1));
        AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
        SimHttpServletRequest req = new SimHttpServletRequest();
        SimHttpServletResponse resp = new SimHttpServletResponse();
        resp.setCharacterEncoding("UTF-8");
        ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
        resp.setOutputStream((ServletOutputStream)servletOutputStream);
        fileResponseRenderer.setScaler((ImageTransformationService)new WrappingImageTransformationService((ImageTransformationProvider)new JavaImageTransformationProvider()));
        fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
        String response = new String(servletOutputStream.toByteArray(), "UTF-8");
        FileResponseRendererTest.assertFalse((String)"Response contains malicious content", (response.indexOf("<svg onload=alert") >= 0 ? 1 : 0) != 0);
    }

    public void testContentLengthMailAttachments_Bug26926() {
        String testDataDir = MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR);
        try {
            FileInputStream is = null;
            is = new FileInputStream(new File(testDataDir + "26926_27394.pdf"));
            FileHolder fileHolder = new FileHolder((InputStream)is, -1L, "image/jpeg", "28082.jpg");
            fileHolder.setDelivery("download");
            AJAXRequestData requestData = new AJAXRequestData();
            requestData.putParameter("delivery", "download");
            requestData.setAction("attachment");
            requestData.setSession((ServerSession)new SimServerSession(1, 1));
            AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
            SimHttpServletRequest req = new SimHttpServletRequest();
            SimHttpServletResponse resp = new SimHttpServletResponse();
            ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
            resp.setOutputStream((ServletOutputStream)servletOutputStream);
            requestData.setHttpServletResponse((HttpServletResponse)resp);
            requestData.setHttpServletRequest((HttpServletRequest)req);
            FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
            fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
            int contentLength = resp.getContentLength();
            FileResponseRendererTest.assertTrue((String)"Content-Length should be -1", (contentLength == -1 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            FileResponseRendererTest.fail((String)e.getMessage());
        }
    }

    public void testChunkRead() {
        try {
            byte[] bytes = FileResponseRendererTools.newByteArray(2048);
            bytes[256] = 120;
            ByteArrayFileHolder fileHolder = FileResponseRendererTools.getFileHolder(bytes, "application/octet-stream", FileResponseRendererTools.Delivery.download, FileResponseRendererTools.Disposition.attachment, "bin.data");
            FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
            AJAXRequestData requestData = new AJAXRequestData();
            AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
            SimHttpServletRequest req = new SimHttpServletRequest();
            req.setParameter("off", "0");
            req.setParameter("len", "256");
            SimHttpServletResponse resp = new SimHttpServletResponse();
            ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
            resp.setOutputStream((ServletOutputStream)servletOutputStream);
            fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
            byte[] writtenBytes = servletOutputStream.toByteArray();
            FileResponseRendererTest.assertEquals((String)"Unexpected number of written bytes.", (int)256, (int)writtenBytes.length);
            requestData = new AJAXRequestData();
            result = new AJAXRequestResult((Object)fileHolder, "file");
            req = new SimHttpServletRequest();
            req.setParameter("off", "256");
            req.setParameter("len", "256");
            resp = new SimHttpServletResponse();
            servletOutputStream = new ByteArrayServletOutputStream();
            resp.setOutputStream((ServletOutputStream)servletOutputStream);
            fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
            writtenBytes = servletOutputStream.toByteArray();
            FileResponseRendererTest.assertEquals((String)"Unexpected number of written bytes.", (int)256, (int)writtenBytes.length);
            FileResponseRendererTest.assertEquals((String)"Unexpected starting byte.", (int)120, (int)writtenBytes[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            FileResponseRendererTest.fail((String)e.getMessage());
        }
    }

    public void testChunkReadOutOfRange() {
        try {
            byte[] bytes = FileResponseRendererTools.newByteArray(2048);
            ByteArrayFileHolder fileHolder = FileResponseRendererTools.getFileHolder(bytes, "application/octet-stream", FileResponseRendererTools.Delivery.download, FileResponseRendererTools.Disposition.attachment, "bin.data");
            FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
            AJAXRequestData requestData = new AJAXRequestData();
            AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
            SimHttpServletRequest req = new SimHttpServletRequest();
            req.setParameter("off", "2049");
            req.setParameter("len", "256");
            SimHttpServletResponse resp = new SimHttpServletResponse();
            ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
            resp.setOutputStream((ServletOutputStream)servletOutputStream);
            fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
            FileResponseRendererTest.assertEquals((String)"Unexpected status code.", (int)416, (int)resp.getStatus());
            FileResponseRendererTest.assertEquals((String)"Unexpected 'Content-Range' header.", (String)"bytes */2048", (String)((String)resp.getHeaders().get("content-range")));
        }
        catch (Exception e) {
            e.printStackTrace();
            FileResponseRendererTest.fail((String)e.getMessage());
        }
    }

    public void testResourceCacheIsDisabled() throws Exception {
        byte[] bytes = FileResponseRendererTools.newByteArray(2048);
        ByteArrayFileHolder fileHolder = FileResponseRendererTools.getFileHolder(bytes, "image/jpeg", FileResponseRendererTools.Delivery.view, FileResponseRendererTools.Disposition.inline, "someimage.jpg");
        TestableResourceCache resourceCache = new TestableResourceCache(false);
        ResourceCaches.setResourceCache((ResourceCache)resourceCache);
        FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
        fileResponseRenderer.setScaler((ImageTransformationService)new TestableImageTransformationService(bytes, 3));
        AJAXRequestData requestData = new AJAXRequestData();
        requestData.setSession((ServerSession)new SimServerSession(1, 1));
        requestData.putParameter("width", "80");
        requestData.putParameter("height", "80");
        AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
        result.setHeader("ETag", "1323jjlksldfsdkfms");
        SimHttpServletRequest req = new SimHttpServletRequest();
        SimHttpServletResponse resp = new SimHttpServletResponse();
        ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
        resp.setOutputStream((ServletOutputStream)servletOutputStream);
        fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
        FileResponseRendererTest.assertEquals((String)"isEnabled() not called", (int)1, (int)resourceCache.callsToIsEnabledFor);
        FileResponseRendererTest.assertEquals((String)"get() called", (int)0, (int)resourceCache.callsToGet);
        FileResponseRendererTest.assertEquals((String)"save() called", (int)0, (int)resourceCache.callsToSave);
    }

    public void testResourceCacheIsDisabled2() throws Exception {
        byte[] bytes = FileResponseRendererTools.newByteArray(2048);
        ByteArrayFileHolder fileHolder = FileResponseRendererTools.getFileHolder(bytes, "image/jpeg", FileResponseRendererTools.Delivery.view, FileResponseRendererTools.Disposition.inline, "someimage.jpg");
        ServerServiceRegistry.getInstance().addService(StringParser.class, (Object)new BasicTypesStringParser());
        TestableResourceCache resourceCache = new TestableResourceCache(true);
        ResourceCaches.setResourceCache((ResourceCache)resourceCache);
        FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
        fileResponseRenderer.setScaler((ImageTransformationService)new TestableImageTransformationService(bytes, 3));
        AJAXRequestData requestData = new AJAXRequestData();
        requestData.setSession((ServerSession)new SimServerSession(1, 1));
        requestData.putParameter("width", "10");
        requestData.putParameter("height", "10");
        requestData.putParameter("cache", "false");
        AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
        SimHttpServletRequest req = new SimHttpServletRequest();
        SimHttpServletResponse resp = new SimHttpServletResponse();
        ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
        resp.setOutputStream((ServletOutputStream)servletOutputStream);
        fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
        FileResponseRendererTest.assertEquals((String)"get() not called", (int)0, (int)resourceCache.callsToGet);
        FileResponseRendererTest.assertEquals((String)"save() called", (int)0, (int)resourceCache.callsToSave);
    }

    public void testNoCachingOnCheapTransformations() throws Exception {
        byte[] bytes = FileResponseRendererTools.newByteArray(2048);
        ByteArrayFileHolder fileHolder = FileResponseRendererTools.getFileHolder(bytes, "image/jpeg", FileResponseRendererTools.Delivery.view, FileResponseRendererTools.Disposition.inline, "someimage.jpg");
        TestableResourceCache resourceCache = new TestableResourceCache(true);
        ResourceCaches.setResourceCache((ResourceCache)resourceCache);
        FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
        fileResponseRenderer.setScaler((ImageTransformationService)new TestableImageTransformationService(bytes, 1));
        AJAXRequestData requestData = new AJAXRequestData();
        requestData.setSession((ServerSession)new SimServerSession(1, 1));
        requestData.putParameter("width", "80");
        requestData.putParameter("height", "80");
        AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
        result.setHeader("ETag", "1323jjlksldfsdkfms");
        SimHttpServletRequest req = new SimHttpServletRequest();
        SimHttpServletResponse resp = new SimHttpServletResponse();
        ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
        resp.setOutputStream((ServletOutputStream)servletOutputStream);
        fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
        FileResponseRendererTest.assertEquals((String)"get() not called", (int)1, (int)resourceCache.callsToGet);
        FileResponseRendererTest.assertEquals((String)"save() called", (int)0, (int)resourceCache.callsToSave);
    }

    public void testCachingOnExpensiveTransformations() throws Exception {
        byte[] bytes = FileResponseRendererTools.newByteArray(2048);
        ByteArrayFileHolder fileHolder = FileResponseRendererTools.getFileHolder(bytes, "image/jpeg", FileResponseRendererTools.Delivery.view, FileResponseRendererTools.Disposition.inline, "someimage.jpg");
        ServerServiceRegistry.getInstance().addService(StringParser.class, (Object)new BasicTypesStringParser());
        TestableResourceCache resourceCache = new TestableResourceCache(true);
        ResourceCaches.setResourceCache((ResourceCache)resourceCache);
        FileResponseRenderer fileResponseRenderer = new FileResponseRenderer();
        fileResponseRenderer.setScaler((ImageTransformationService)new TestableImageTransformationService(bytes, 3));
        AJAXRequestData requestData = new AJAXRequestData();
        requestData.putParameter("width", "10");
        requestData.putParameter("height", "10");
        requestData.setSession((ServerSession)new SimServerSession(1, 1));
        AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
        result.setHeader("ETag", "1323jjlksldfsdkfms");
        SimHttpServletRequest req = new SimHttpServletRequest();
        SimHttpServletResponse resp = new SimHttpServletResponse();
        ByteArrayServletOutputStream servletOutputStream = new ByteArrayServletOutputStream();
        resp.setOutputStream((ServletOutputStream)servletOutputStream);
        fileResponseRenderer.writeFileHolder((IFileHolder)fileHolder, requestData, result, (HttpServletRequest)req, (HttpServletResponse)resp);
        FileResponseRendererTest.assertEquals((String)"get() not called", (int)1, (int)resourceCache.callsToGet);
        FileResponseRendererTest.assertEquals((String)"save() called", (int)1, (int)resourceCache.callsToSave);
    }

    private static final class TestableImageTransformationService
    implements ImageTransformationService {
        private final byte[] imageData;
        private final int expenses;

        TestableImageTransformationService(byte[] imageData, int expenses) {
            this.imageData = imageData;
            this.expenses = expenses;
        }

        public ImageTransformations transfom(BufferedImage sourceImage) {
            return new TestableImageTransformations(this.imageData, this.expenses);
        }

        public ImageTransformations transfom(BufferedImage sourceImage, Object source) {
            return new TestableImageTransformations(this.imageData, this.expenses);
        }

        public ImageTransformations transfom(InputStream imageStream) throws IOException {
            return new TestableImageTransformations(this.imageData, this.expenses);
        }

        public ImageTransformations transfom(InputStream imageStream, Object source) throws IOException {
            return new TestableImageTransformations(this.imageData, this.expenses);
        }

        public ImageTransformations transfom(IFileHolder imageFile, Object source) throws IOException {
            return new TestableImageTransformations(this.imageData, this.expenses);
        }

        public ImageTransformations transfom(byte[] imageData) throws IOException {
            return new TestableImageTransformations(imageData, this.expenses);
        }

        public ImageTransformations transfom(byte[] imageData, Object source) throws IOException {
            return new TestableImageTransformations(imageData, this.expenses);
        }
    }

    private static final class TestableImageTransformations
    implements ImageTransformations {
        private final byte[] imageData;
        private final int expenses;

        public TestableImageTransformations(byte[] imageData, int expenses) {
            this.imageData = imageData;
            this.expenses = expenses;
        }

        public ImageTransformations rotate() {
            return this;
        }

        public ImageTransformations scale(int maxWidth, int maxHeight, ScaleType scaleType) {
            return this;
        }

        public ImageTransformations scale(int maxWidth, int maxHeight, ScaleType scaleType, boolean shrinkOnly) {
            return this;
        }

        public ImageTransformations crop(int x, int y, int width, int height) {
            return this;
        }

        public ImageTransformations compress() {
            return this;
        }

        public BufferedImage getImage() throws IOException {
            return null;
        }

        public byte[] getBytes(String formatName) throws IOException {
            return null;
        }

        public InputStream getInputStream(String formatName) throws IOException {
            return null;
        }

        public BasicTransformedImage getTransformedImage(String formatName) throws IOException {
            return new BasicTransformedImage(){

                public int getTransformationExpenses() {
                    return TestableImageTransformations.this.expenses;
                }

                public long getSize() {
                    return 0L;
                }

                public byte[] getImageData() {
                    return TestableImageTransformations.this.imageData;
                }

                public InputStream getImageStream() throws OXException {
                    return new ByteArrayInputStream(TestableImageTransformations.this.imageData);
                }

                public IFileHolder getImageFile() {
                    return null;
                }

                public String getFormatName() {
                    return null;
                }

                public void close() {
                }
            };
        }

        public TransformedImage getFullTransformedImage(String formatName) throws IOException {
            return new TransformedImage(){

                public int getWidth() {
                    return 0;
                }

                public int getTransformationExpenses() {
                    return TestableImageTransformations.this.expenses;
                }

                public long getSize() {
                    return 0L;
                }

                public byte[] getMD5() {
                    return null;
                }

                public byte[] getImageData() {
                    return TestableImageTransformations.this.imageData;
                }

                public InputStream getImageStream() throws OXException {
                    return new ByteArrayInputStream(TestableImageTransformations.this.imageData);
                }

                public IFileHolder getImageFile() {
                    return null;
                }

                public int getHeight() {
                    return 0;
                }

                public String getFormatName() {
                    return null;
                }

                public void close() {
                }
            };
        }
    }

    private static final class TestableResourceCache
    implements ResourceCache {
        private final boolean isEnabled;
        int callsToIsEnabledFor = 0;
        int callsToGet = 0;
        int callsToSave = 0;

        public TestableResourceCache(boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        public boolean isEnabledFor(int contextId, int userId) throws OXException {
            ++this.callsToIsEnabledFor;
            return this.isEnabled;
        }

        public boolean save(String id, CachedResource resource, int userId, int contextId) throws OXException {
            ++this.callsToSave;
            return false;
        }

        public CachedResource get(String id, int userId, int contextId) throws OXException {
            ++this.callsToGet;
            return null;
        }

        public void remove(int userId, int contextId) throws OXException {
        }

        public void removeAlikes(String id, int userId, int contextId) throws OXException {
        }

        public void clearFor(int contextId) throws OXException {
        }

        public boolean exists(String id, int userId, int contextId) throws OXException {
            return false;
        }
    }
}

