/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.redirect.actions;

import com.openexchange.ajax.framework.AbstractRedirectParser;
import com.openexchange.ajax.redirect.actions.RedirectResponse;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;

public final class RedirectParser
extends AbstractRedirectParser<RedirectResponse> {
    RedirectParser() {
        super(false);
    }

    @Override
    public String checkResponse(HttpResponse resp, HttpRequest request) throws ParseException, IOException {
        this.setStatusCode(resp.getStatusLine().getStatusCode());
        this.setReasonPhrase(resp.getStatusLine().getReasonPhrase());
        Header[] headers = resp.getHeaders("Location");
        if (headers.length > 0) {
            this.setLocation(headers[0].getValue());
        } else {
            this.setLocation("");
        }
        return EntityUtils.toString((HttpEntity)resp.getEntity());
    }

    @Override
    public RedirectResponse parse(String location) {
        return this.createResponse(location);
    }

    @Override
    protected RedirectResponse createResponse(String location) {
        return new RedirectResponse(this.getStatusCode(), this.getReasonPhrase(), location);
    }
}

