/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.publish.tests;

import com.openexchange.ajax.infostore.actions.InfostoreTestManager;
import com.openexchange.ajax.publish.tests.AbstractPublicationTest;
import com.openexchange.ajax.publish.tests.PublicationTestManager;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.publish.Publication;
import com.openexchange.publish.PublicationTargetDiscoveryService;
import com.openexchange.publish.SimPublicationTargetDiscoveryService;
import com.openexchange.test.OXTestToolkit;
import com.openexchange.test.TestInit;
import java.io.File;
import java.io.FileInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OXMFInfostoreTest
extends AbstractPublicationTest {
    public OXMFInfostoreTest(String name) {
        super(name);
    }

    public void testLifeCycleOfInfostoreFolderPublication() throws Exception {
        InfostoreTestManager infoMgr = this.getInfostoreManager();
        FolderObject folder = this.createDefaultInfostoreFolder();
        DefaultFile data = new DefaultFile();
        data.setTitle("roundtripper");
        data.setDescription("Round-trippin' infostore folder");
        data.setFileMIMEType("text/plain");
        data.setFolderId(String.valueOf(folder.getObjectID()));
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        data.setFileName(upload.getName());
        infoMgr.newAction((com.openexchange.file.storage.File)data, upload);
        SimPublicationTargetDiscoveryService pubDiscovery = new SimPublicationTargetDiscoveryService();
        Publication publication = this.generatePublication("infostore", String.valueOf(folder.getObjectID()), pubDiscovery);
        PublicationTestManager pubMgr = this.getPublishManager();
        pubMgr.setPublicationTargetDiscoveryService((PublicationTargetDiscoveryService)pubDiscovery);
        pubMgr.newAction(publication);
        String pubUrl = (String)publication.getConfiguration().get("url");
        String website = this.getWebsite(pubUrl);
        Pattern urlPattern = Pattern.compile("href=\"(.+?/publications/files/.+?/" + this.getObjectId((com.openexchange.file.storage.File)data) + "/.+?)\"");
        Matcher matcher = urlPattern.matcher(website);
        boolean found = matcher.find();
        OXMFInfostoreTest.assertTrue((String)"Should contain reference to a published infostore item", (boolean)found);
        String downloadUrl = matcher.group(1);
        OXTestToolkit.assertSameStream(new FileInputStream(upload), this.getDownload(downloadUrl));
    }

    public void testLifeCycleOfInfostoreItemPublication() throws Exception {
        InfostoreTestManager infoMgr = this.getInfostoreManager();
        FolderObject folder = this.createDefaultInfostoreFolder();
        DefaultFile data = new DefaultFile();
        data.setTitle("roundtripper2");
        data.setDescription("Round-trippin' infostore file");
        data.setFileMIMEType("text/plain");
        data.setFolderId(String.valueOf(folder.getObjectID()));
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        data.setFileName(upload.getName());
        infoMgr.newAction((com.openexchange.file.storage.File)data, upload);
        SimPublicationTargetDiscoveryService pubDiscovery = new SimPublicationTargetDiscoveryService();
        Publication publication = this.generateInfostoreItemPublication(String.valueOf(this.getObjectId((com.openexchange.file.storage.File)data)), pubDiscovery);
        PublicationTestManager pubMgr = this.getPublishManager();
        pubMgr.setPublicationTargetDiscoveryService((PublicationTargetDiscoveryService)pubDiscovery);
        pubMgr.newAction(publication);
        String pubUrl = (String)publication.getConfiguration().get("url");
        OXTestToolkit.assertSameStream("Comparing uploaded files", new FileInputStream(upload), this.getDownload(pubUrl));
    }
}

