/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.onboarding.tests;

import com.google.common.io.BaseEncoding;
import com.openexchange.ajax.onboarding.actions.ExecuteRequest;
import com.openexchange.ajax.onboarding.actions.OnboardingTestResponse;
import com.openexchange.ajax.onboarding.tests.AbstractPlistSMSTest;
import com.openexchange.ajax.onboarding.tests.PListDownloadTestHelper;
import com.openexchange.exception.OXException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class PlistSMSTest
extends AbstractPlistSMSTest {
    private String name;
    private static final String SLASH = "/";

    public PlistSMSTest(String name) {
        super(name);
        this.name = name;
    }

    public void testExecute() throws Exception {
        String jsonString = "{\"sms\":\"+49276183850\"}";
        JSONObject body = new JSONObject(jsonString);
        for (String id : SCENARIOS) {
            ExecuteRequest req = new ExecuteRequest(id, "sms", body, false);
            OnboardingTestResponse response = this.client.execute(req);
            PlistSMSTest.assertNotNull((String)"Response is empty!", (Object)((Object)response));
            PlistSMSTest.assertNotNull((String)"Unexpected response from the server! Response does not contain an exception.", (Object)((Object)response.getException()));
            if (response.getException().getCode() == 10 && response.getException().getPrefix().equalsIgnoreCase("ONBRD")) continue;
            PlistSMSTest.assertEquals((String)"Unexpected response from the server! Response does contain a wrong exception.", (int)3, (int)response.getException().getCode());
            PlistSMSTest.assertEquals((String)"Unexpected response from the server! Response does contain a wrong exception.", (String)"SMS", (String)response.getException().getPrefix());
        }
    }

    public void testExecute_missingNumber() throws Exception {
        String jsonString = "{\"sms\":\"\"}";
        JSONObject body = new JSONObject(jsonString);
        String id = SCENARIOS[0];
        ExecuteRequest req = new ExecuteRequest(id, "sms", body, false);
        OnboardingTestResponse response = this.client.execute(req);
        PlistSMSTest.assertNotNull((String)"Response is empty!", (Object)((Object)response));
        PlistSMSTest.assertNotNull((String)"Unexpected response from the server! Response does not contain an exception.", (Object)((Object)response.getException()));
        PlistSMSTest.assertEquals((String)"Unexpected response from the server! Response does contain a wrong exception.", (int)22, (int)response.getException().getCode());
        PlistSMSTest.assertEquals((String)"Unexpected response from the server! Response does contain a wrong exception.", (String)"ONBRD", (String)response.getException().getPrefix());
    }

    public void testExecute_invalidNumber() throws Exception {
        String jsonString = "{\"sms\":\"1234\"}";
        JSONObject body = new JSONObject(jsonString);
        String id = SCENARIOS[0];
        ExecuteRequest req = new ExecuteRequest(id, "sms", body, false);
        OnboardingTestResponse response = this.client.execute(req);
        PlistSMSTest.assertNotNull((String)"Response is empty!", (Object)((Object)response));
        PlistSMSTest.assertNotNull((String)"Unexpected response from the server! Response does not contain an exception.", (Object)((Object)response.getException()));
        PlistSMSTest.assertEquals((String)"Unexpected response from the server! Response does contain a wrong exception.", (int)22, (int)response.getException().getCode());
        PlistSMSTest.assertEquals((String)"Unexpected response from the server! Response does contain a wrong exception.", (String)"ONBRD", (String)response.getException().getPrefix());
        jsonString = "{\"sms\":\"abcde\"}";
        body = new JSONObject(jsonString);
        req = new ExecuteRequest(id, "sms", body, false);
        response = this.client.execute(req);
        PlistSMSTest.assertNotNull((String)"Response is empty!", (Object)((Object)response));
        PlistSMSTest.assertNotNull((String)"Unexpected response from the server! Response does not contain an exception.", (Object)((Object)response.getException()));
        PlistSMSTest.assertEquals((String)"Unexpected response from the server! Response does contain a wrong exception.", (int)22, (int)response.getException().getCode());
        PlistSMSTest.assertEquals((String)"Unexpected response from the server! Response does contain a wrong exception.", (String)"ONBRD", (String)response.getException().getPrefix());
    }

    public void testDownload() throws Exception {
        PListDownloadTestHelper helper = new PListDownloadTestHelper(this.name);
        String url = this.getURL(this.client.getValues().getUserId(), this.client.getValues().getContextId(), "mailsync", "apple.iphone");
        helper.testMailDownload(url, this.client.getHostname());
        url = this.getURL(this.client.getValues().getUserId(), this.client.getValues().getContextId(), "eassync", "apple.iphone");
        helper.testEASDownload(url, this.client.getHostname());
        url = this.getURL(this.client.getValues().getUserId(), this.client.getValues().getContextId(), "davsync", "apple.iphone");
        helper.testDavDownload(url, this.client.getHostname());
    }

    public String getURL(int userId, int contextId, String scenario, String device) throws OXException, NoSuchAlgorithmException, UnsupportedEncodingException {
        BaseEncoding encoder = BaseEncoding.base64().omitPadding();
        StringBuilder url = new StringBuilder();
        String userString = new String(encoder.encode(String.valueOf(userId).getBytes()));
        String contextString = new String(encoder.encode(String.valueOf(contextId).getBytes()));
        String scenarioString = new String(encoder.encode(scenario.getBytes()));
        String deviceString = new String(encoder.encode(device.getBytes()));
        String challenge = PlistSMSTest.toHash(userId, contextId, scenario, device);
        url.append("/ajax/plist");
        url.append(SLASH).append(userString).append(SLASH).append(contextString).append(SLASH).append(deviceString).append(SLASH).append(scenarioString).append(SLASH).append(challenge);
        return url.toString();
    }

    private static String toHash(int userId, int contextId, String scenario, String device) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String secret = UID;
        String challenge = userId + contextId + device + scenario + secret;
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] sha1hash = new byte[40];
        md.update(challenge.getBytes("UTF-8"), 0, challenge.length());
        sha1hash = md.digest();
        return PlistSMSTest.convertToHex(sha1hash);
    }

    private static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    @Override
    protected Map<String, String> getNeededConfigurations() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("com.openexchange.sms.userlimit.enabled", String.valueOf(false));
        return map;
    }
}

