/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.onboarding.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.Header;
import com.openexchange.ajax.framework.Params;
import com.openexchange.ajax.onboarding.actions.OnboardingTestResponse;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class ExecuteRequest
implements AJAXRequest<OnboardingTestResponse> {
    private final String id;
    private final String actionId;
    private final JSONObject body;
    private final boolean failOnError;

    public ExecuteRequest(String id, String actionId) {
        this(id, actionId, null, true);
    }

    public ExecuteRequest(String id, String actionId, JSONObject body) {
        this(id, actionId, body, true);
    }

    public ExecuteRequest(String id, String actionId, JSONObject body, boolean failOnError) {
        this.id = id;
        this.actionId = actionId;
        this.body = body;
        this.failOnError = failOnError;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public String getServletPath() {
        return "/ajax/onboarding";
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        return new Params("action", "execute", "id", this.id, "action_id", this.actionId).toArray();
    }

    @Override
    public AbstractAJAXParser<? extends OnboardingTestResponse> getParser() {
        return new Parser(this.failOnError);
    }

    @Override
    public Object getBody() throws IOException, JSONException {
        return this.body;
    }

    @Override
    public Header[] getHeaders() {
        return NO_HEADER;
    }

    private static final class Parser
    extends AbstractAJAXParser<OnboardingTestResponse> {
        public Parser(boolean failOnError) {
            super(failOnError);
        }

        @Override
        protected OnboardingTestResponse createResponse(Response response) throws JSONException {
            return new OnboardingTestResponse(response);
        }
    }
}

