/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.oauth.provider;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.oauth.provider.AbstractOAuthTest;
import com.openexchange.ajax.oauth.provider.OAuthClient;
import com.openexchange.ajax.oauth.provider.actions.AllRequest;
import com.openexchange.ajax.oauth.provider.actions.AllResponse;
import com.openexchange.ajax.oauth.provider.actions.RevokeRequest;
import com.openexchange.exception.OXException;
import com.openexchange.oauth.provider.authorizationserver.grant.GrantView;
import com.openexchange.oauth.provider.resourceserver.scope.Scope;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class JSONApiTest
extends AbstractOAuthTest {
    public JSONApiTest() throws OXException {
        super(Scope.newInstance((String[])new String[]{"read_contacts"}));
    }

    @Test
    public void testAllAndRevoke() throws Exception {
        new OAuthClient(AJAXClient.User.User1, this.clientApp.getId(), this.clientApp.getSecret(), (String)this.clientApp.getRedirectURIs().get(0), Scope.newInstance((String[])new String[]{"read_calendar", "write_calendar"}));
        AllResponse allResponse = this.ajaxClient.execute(new AllRequest());
        List<GrantView> grantViews = allResponse.getGrantViews();
        GrantView expected = null;
        for (GrantView grant : grantViews) {
            if (!grant.getClient().getId().equals(this.clientApp.getId())) continue;
            expected = grant;
            break;
        }
        Assert.assertNotNull(expected);
        Assert.assertEquals((long)3L, (long)expected.getScope().size());
        this.ajaxClient.execute(new RevokeRequest(expected.getClient().getId()));
        allResponse = this.ajaxClient.execute(new AllRequest());
        grantViews = allResponse.getGrantViews();
        for (GrantView grant : grantViews) {
            Assert.assertFalse((boolean)grant.getClient().getId().equals(this.clientApp.getId()));
        }
    }
}

